/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.config.ConfigManager;
import me.chrr.scribble.config.YACLConfigScreenFactory;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Scribble {
    public static final String MOD_ID = "scribble";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    private static @Nullable Platform PLATFORM;

    public static void init(Platform platform) {
        PLATFORM = platform;
        try {
            CONFIG_MANAGER.load();
        }
        catch (IOException e) {
            LOGGER.error("failed to load config", (Throwable)e);
        }
        try {
            FileChooser.convertLegacyBooks();
        }
        catch (IOException e) {
            LOGGER.error("failed to convert legacy NBT-based book files to JSON", (Throwable)e);
        }
    }

    public static class_437 buildConfigScreen(class_437 parent) {
        return YACLConfigScreenFactory.create(CONFIG_MANAGER, parent);
    }

    public static Platform platform() {
        return Optional.ofNullable(PLATFORM).orElseThrow();
    }

    public static Config config() {
        return CONFIG_MANAGER.getConfig();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static abstract class Platform {
        public final Path CONFIG_DIR = this.getConfigDir();
        public final Path BOOK_DIR = this.getGameDir().resolve("books");
        public final String VERSION = this.getModVersion();
        public final boolean HAS_YACL = this.isModLoaded("yet_another_config_lib_v3");

        protected abstract boolean isModLoaded(String var1);

        protected abstract String getModVersion();

        protected abstract Path getConfigDir();

        protected abstract Path getGameDir();
    }
}

