/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.screen;

import java.util.ArrayList;
import java.util.List;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.gui.PageNumberWidget;
import me.chrr.scribble.gui.TextArea;
import me.chrr.scribble.gui.button.IconButtonWidget;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_474;
import net.minecraft.class_5250;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class ScribbleBookScreen<T>
extends class_437 {
    public int currentPage = 0;
    public int pagesToShow = 1;
    public class_2960 backgroundTexture = class_3872.field_17117;
    public final List<TextArea<T>> textAreas = new ArrayList<TextArea<T>>();
    public final List<PageNumberWidget> pageNumbers = new ArrayList<PageNumberWidget>();
    public @Nullable class_474 backButton;
    public @Nullable class_474 forwardButton;

    protected ScribbleBookScreen(class_2561 title) {
        super(title);
    }

    protected void method_25426() {
        int i;
        this.pagesToShow = Scribble.config().pagesToShow;
        this.backgroundTexture = this.pagesToShow == 1 ? class_3872.field_17117 : Scribble.id("textures/gui/book_" + this.pagesToShow + ".png");
        int x = this.getBackgroundX();
        int y = this.getBackgroundY();
        this.textAreas.clear();
        for (i = 0; i < this.pagesToShow; ++i) {
            TextArea<T> textArea = this.createTextArea(x + 36 + i * 126, y + 30, 114, 128, i);
            this.textAreas.add((TextArea)this.method_37063(textArea));
        }
        this.pageNumbers.clear();
        for (i = 0; i < this.pagesToShow; ++i) {
            PageNumberWidget widget = new PageNumberWidget(page -> this.jumpToPage(page - 1), x + 148 + i * 126, y + 16, this.field_22793);
            this.pageNumbers.add((PageNumberWidget)this.method_37063((class_364)widget));
        }
        this.initMenuControls(this.getMenuControlsY());
        this.backButton = (class_474)this.method_37063((class_364)new class_474(x + 43, y + 157, false, button -> this.goPageBackward(this.field_22787.method_74187()), true));
        this.initPageButtons(y + 157);
        this.forwardButton = (class_474)this.method_37063((class_364)new class_474(x + 126 * this.pagesToShow - 10, y + 157, true, button -> this.goPageForward(this.field_22787.method_74187()), true));
        if (this.shouldShowActionButtons()) {
            this.initActionButtons(x, this.getBackgroundY() + 12 + 4);
            this.initSettingsButton(x, this.getBackgroundY() + this.getBackgroundHeight() - 12 - 4 - 12);
        }
        this.updateCurrentPages();
    }

    private void initSettingsButton(int x, int y) {
        class_5250 settingsText = class_2561.method_43470((String)("Scribble " + Scribble.platform().VERSION + "\n")).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        boolean canOpenConfigScreen = Scribble.platform().HAS_YACL;
        if (canOpenConfigScreen) {
            settingsText.method_10852((class_2561)class_2561.method_43471((String)"text.scribble.action.settings").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false))));
        } else {
            settingsText.method_10852((class_2561)class_2561.method_43470((String)"YACL needs to be installed to access the settings menu.").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1061)));
        }
        IconButtonWidget widget = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)settingsText, () -> this.field_22787.method_1507(Scribble.buildConfigScreen(this)), x, y, 96, 90, 12, 12));
        widget.field_22763 = canOpenConfigScreen;
    }

    public void updateCurrentPages() {
        int pagesFromEnd;
        for (pagesFromEnd = this.getTotalPages() - this.currentPage; pagesFromEnd < this.pagesToShow && this.canInsertPages(); ++pagesFromEnd) {
            this.insertEmptyPageAt(this.getTotalPages());
        }
        for (int i = 0; i < this.pagesToShow; ++i) {
            boolean visible = i < pagesFromEnd;
            this.textAreas.get(i).setVisible(visible);
            this.pageNumbers.get((int)i).field_22764 = visible;
            if (!visible) continue;
            this.textAreas.get(i).setText(this.getPage(this.currentPage + i));
            this.pageNumbers.get(i).setPageNumber(this.currentPage + i + 1, Math.max(1, this.getTotalPages()));
        }
        if (this.backButton != null && this.forwardButton != null) {
            this.backButton.field_22764 = this.currentPage > 0;
            this.forwardButton.field_22764 = pagesFromEnd > this.pagesToShow || this.canInsertPages();
        }
    }

    public void jumpToPage(int page) {
        this.showPage(page, false);
    }

    public void showPage(int page, boolean insertIfMissing) {
        int shownPage;
        int newPage;
        if (insertIfMissing) {
            for (newPage = Math.max(Math.min(page, this.getTotalPages() - 1), 0); newPage < page && this.canInsertPages(); ++newPage) {
                this.insertEmptyPageAt(this.getTotalPages());
            }
        }
        if ((shownPage = newPage - newPage % this.pagesToShow) != this.currentPage) {
            this.currentPage = shownPage;
            this.updateCurrentPages();
            if (this.textAreas.stream().anyMatch(class_364::method_25370)) {
                this.method_25395(this.textAreas.getFirst());
            }
        }
    }

    public void goPageForward(boolean toEnd) {
        if (toEnd) {
            this.showPage(this.getTotalPages() - 1, false);
        } else {
            this.showPage(this.currentPage + this.pagesToShow, true);
        }
    }

    public void goPageBackward(boolean toStart) {
        if (toStart) {
            this.showPage(0, false);
        } else {
            this.showPage(this.currentPage - 1, false);
        }
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        super.method_25420(guiGraphics, i, j, f);
        int textureSize = this.pagesToShow == 1 ? 256 : 512;
        guiGraphics.method_25290(class_10799.field_56883, this.backgroundTexture, this.getBackgroundX(), this.getBackgroundY(), 0.0f, 0.0f, 122 * this.pagesToShow + 70, 192, textureSize, textureSize);
    }

    public boolean method_73150() {
        return true;
    }

    public void method_25419() {
        this.closeRemoteContainer();
        super.method_25419();
    }

    public int getBackgroundX() {
        return this.field_22789 / 2 - this.getBackgroundWidth() / 2;
    }

    public int getBackgroundY() {
        if (Scribble.config().centerBookGui) {
            return 2 + this.field_22790 / 3 - ScribbleBookScreen.getMenuHeight() / 3;
        }
        return 2;
    }

    public int getBackgroundWidth() {
        return this.pagesToShow * 126 + 66;
    }

    public int getBackgroundHeight() {
        return 182;
    }

    public static int getMenuHeight() {
        return 214;
    }

    public int getMenuControlsY() {
        return this.getBackgroundY() + ScribbleBookScreen.getMenuHeight() - 20;
    }

    protected void closeRemoteContainer() {
    }

    protected boolean canInsertPages() {
        return false;
    }

    protected void insertEmptyPageAt(int page) {
    }

    protected abstract boolean shouldShowActionButtons();

    protected abstract void initActionButtons(int var1, int var2);

    protected void initPageButtons(int y) {
    }

    protected abstract void initMenuControls(int var1);

    protected abstract TextArea<T> createTextArea(int var1, int var2, int var3, int var4, int var5);

    protected abstract T getPage(int var1);

    protected abstract int getTotalPages();
}

