/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsPlayer;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.sound.player.DelayedSoundPlayer;
import eu.ha3.presencefootsteps.util.BlockReport;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.util.ResourceUtils;
import eu.ha3.presencefootsteps.world.BiomeVarianceLookup;
import eu.ha3.presencefootsteps.world.GolemLookup;
import eu.ha3.presencefootsteps.world.HeuristicStateLookup;
import eu.ha3.presencefootsteps.world.Index;
import eu.ha3.presencefootsteps.world.LocomotionLookup;
import eu.ha3.presencefootsteps.world.Lookup;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.StateLookup;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_7654;
import net.minecraft.class_7923;

public record Isolator(Variator variator, Index<class_1297, Locomotion> locomotions, HeuristicStateLookup heuristics, Lookup<class_1299<?>> golems, Lookup<class_2680> globalBlocks, Map<class_1299<?>, Lookup<class_2680>> blocks, Index<class_2960, BiomeVarianceLookup.BiomeVariance> biomes, Lookup<class_3414> primitives, AcousticLibrary acoustics) implements BlockReport.Reportable
{
    private static final class_2960 BLOCK_MAP = PresenceFootsteps.id("config/blockmap.json");
    private static final class_2960 BIOME_MAP = PresenceFootsteps.id("config/biomevariancemap.json");
    private static final class_2960 GOLEM_MAP = PresenceFootsteps.id("config/golemmap.json");
    private static final class_2960 LOCOMOTION_MAP = PresenceFootsteps.id("config/locomotionmap.json");
    private static final class_2960 PRIMITIVE_MAP = PresenceFootsteps.id("config/primitivemap.json");
    private static final class_2960 ACOUSTICS = PresenceFootsteps.id("config/acoustics");
    private static final class_2960 VARIATOR = PresenceFootsteps.id("config/variator.json");

    public Isolator(SoundEngine engine) {
        this(new Variator(), new LocomotionLookup(engine.getConfig()), new HeuristicStateLookup(), new Lookup(), new Lookup<class_2680>(), new HashMap(), new BiomeVarianceLookup(), new Lookup<class_3414>(), new AcousticsPlayer(new DelayedSoundPlayer(engine.soundPlayer)));
    }

    public Lookup<class_2680> blocks(class_1299<?> sourceType) {
        if (sourceType == class_1299.field_6097) {
            return this.globalBlocks();
        }
        return this.blocks.getOrDefault(sourceType, this.globalBlocks());
    }

    public boolean load(class_3300 manager) {
        boolean hasConfigurations = false;
        hasConfigurations |= this.globalBlocks().load(ResourceUtils.load(BLOCK_MAP, manager, StateLookup::new));
        this.blocks.clear();
        this.blocks.putAll(ResourceUtils.loadDir(class_7654.method_45114((String)"config/blockmaps/entity"), manager, StateLookup::new, id -> class_7923.field_41177.method_17966(id.method_45134(p -> p.replace("config/blockmaps/entity/", "").replace(".json", ""))).orElse(null), entries -> {
            Lookup<class_2680> lookup = new Lookup<class_2680>();
            return lookup.load((Stream<Lookup.DataSegment<class_2680>>)entries, this.globalBlocks()) ? lookup : null;
        }));
        hasConfigurations |= !this.blocks.isEmpty();
        hasConfigurations |= ResourceUtils.forEach(BIOME_MAP, manager, this.biomes()::load);
        hasConfigurations |= this.golems().load(ResourceUtils.load(GOLEM_MAP, manager, GolemLookup::new));
        hasConfigurations |= this.primitives().load(ResourceUtils.load(PRIMITIVE_MAP, manager, PrimitiveLookup::new));
        hasConfigurations |= ResourceUtils.forEach(LOCOMOTION_MAP, manager, this.locomotions()::load);
        Map<class_2960, Acoustic> acoustics = ResourceUtils.loadAll(ACOUSTICS, manager, Acoustic.CODEC);
        hasConfigurations |= !acoustics.isEmpty();
        acoustics.forEach((id, acoustic) -> this.acoustics().addAcoustic(id.method_12832(), (Acoustic)acoustic));
        return hasConfigurations |= ResourceUtils.forEach(VARIATOR, manager, this.variator()::load);
    }

    @Override
    public void writeToReport(boolean full, JsonObjectWriter writer, Map<String, class_2498> groups) throws IOException {
        writer.object(() -> {
            writer.object("blocks", () -> StateLookup.writeToReport(this.globalBlocks(), full, writer, groups));
            writer.object("golems", () -> GolemLookup.writeToReport(this.golems(), full, writer, groups));
            writer.object("entities", () -> this.locomotions().writeToReport(full, writer, groups));
            writer.object("primitives", () -> PrimitiveLookup.writeToReport(this.primitives(), full, writer, groups));
        });
    }
}

