/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.Range;
import net.minecraft.class_1309;

record VaryingAcoustic(String soundName, Range volume, Range pitch) implements Acoustic
{
    public static final MapCodec<VaryingAcoustic> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.fieldOf("name").forGetter(VaryingAcoustic::soundName), (App)Range.CODEC.fieldOf("volume").forGetter(VaryingAcoustic::volume), (App)Range.CODEC.fieldOf("pitch").forGetter(VaryingAcoustic::pitch)).apply((Applicative)i, VaryingAcoustic::new));
    @Deprecated
    static final Acoustic.Serializer FACTORY = (json, context) -> {
        if (json.isJsonPrimitive()) {
            return new VaryingAcoustic(context.getSoundName(json.getAsString()), context.defaultVolume(), context.defaultPitch());
        }
        JsonObject jso = json.getAsJsonObject();
        if (!jso.has("name")) {
            throw new JsonParseException("Acoustic is missing a name");
        }
        String name = jso.get("name").getAsString();
        if (name.isEmpty()) {
            throw new JsonParseException("Acoustic is missing a name");
        }
        return new VaryingAcoustic(context.getSoundName(name), context.defaultVolume().read("volume", jso), context.defaultPitch().read("pitch", jso));
    };

    @Override
    public String type() {
        return Acoustic.BASIC;
    }

    @Override
    public void playSound(SoundPlayer player, class_1309 location, State event, Options inputOptions) {
        if (this.soundName.isEmpty()) {
            return;
        }
        float finalVolume = (inputOptions.containsKey("gliding_volume") ? this.volume.on(inputOptions.get("gliding_volume")) : this.volume.random(player.getRNG())) * inputOptions.getOrDefault("volume_scale", 1.0f);
        float finalPitch = inputOptions.containsKey("gliding_pitch") ? this.pitch.on(inputOptions.get("gliding_pitch")) : this.pitch.random(player.getRNG());
        player.playSound(location, this.soundName, finalVolume, finalPitch, inputOptions);
    }
}

