/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.util.MathUtil;
import java.util.Random;
import net.minecraft.class_3518;
import net.minecraft.class_3532;

public record Period(long min, long max) implements Options
{
    private static final Codec<Period> RANGE_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.LONG.fieldOf("min").forGetter(Period::min), (App)Codec.LONG.fieldOf("max").forGetter(Period::max)).apply((Applicative)i, Period::of));
    private static final Codec<Period> POINT_CODEC = Codec.LONG.xmap(Period::of, Period::min);
    public static final Codec<Period> CODEC = Codec.xor(POINT_CODEC, RANGE_CODEC).xmap(Either::unwrap, period -> period.min() == period.max() ? Either.left((Object)period) : Either.right((Object)period));
    public static final Period ZERO = new Period(0L, 0L);

    public static Period of(long value) {
        return Period.of(value, value);
    }

    public static Period of(long min, long max) {
        return min == max && max == 0L ? ZERO : new Period(min, max);
    }

    @Deprecated
    public static Period fromJson(JsonObject json, String key) {
        if (json.has(key)) {
            return Period.of(json.get(key).getAsLong());
        }
        return Period.of(class_3518.method_15280((JsonObject)json, (String)(key + "_min"), (long)0L), class_3518.method_15280((JsonObject)json, (String)(key + "_max"), (long)0L));
    }

    public float random(Random rand) {
        return MathUtil.randAB(rand, this.min, this.max);
    }

    public float on(float value) {
        return class_3532.method_16439((float)value, (float)this.min, (float)this.max);
    }

    @Override
    public boolean containsKey(String option) {
        return "delay_min".equals(option) || "delay_max".equals(option);
    }

    @Override
    public float get(String option) {
        return "delay_min".equals(option) ? (float)this.min : ("delay_max".equals(option) ? (float)this.max : 0.0f);
    }
}

