/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1011;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3940;
import net.minecraft.class_638;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import org.joml.Math;
import org.lwjgl.system.MemoryUtil;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.mixin.access.NativeImageAccessor;

public class TextureUtil {
    private static int highestAlpha;

    public static void boostAlpha(class_1011 img, String debugName) {
        highestAlpha = 0;
        TextureUtil.applyToAllPixels(img, rgba -> {
            Color col = new Color(rgba, true);
            highestAlpha = Math.max((int)col.getAlpha(), (int)highestAlpha);
            return rgba;
        });
        if (highestAlpha == 255 || highestAlpha == 0) {
            return;
        }
        int multiplier = 255 / highestAlpha;
        if (multiplier == 1) {
            return;
        }
        ParticleRain.LOGGER.info("Multiplying {} texture alpha by {}", (Object)debugName, (Object)multiplier);
        TextureUtil.applyToAllPixels(img, rgba -> {
            Color col = new Color(rgba, true);
            return (col.getAlpha() * multiplier & 0xFF) << 24 | (col.getRed() & 0xFF) << 16 | (col.getGreen() & 0xFF) << 8 | col.getBlue() & 0xFF;
        });
    }

    public static void desaturate(class_1011 img) {
        TextureUtil.applyToAllPixels(img, rgba -> {
            Color col = new Color(rgba, true);
            int gray = Math.max((int)Math.max((int)col.getRed(), (int)col.getGreen()), (int)col.getBlue());
            return (col.getAlpha() & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
        });
    }

    public static void applyToAllPixels(class_1011 image, IntUnaryOperator function) {
        if (image.method_4318() != class_1011.class_1012.field_4997) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "function application only works on RGBA images; have %s", image.method_4318()));
        }
        ((NativeImageAccessor)image).callCheckAllocated();
        int i = image.method_4307() * image.method_4323();
        IntBuffer intBuffer = MemoryUtil.memIntBuffer((long)((NativeImageAccessor)image).getPixels(), (int)i);
        for (int j = 0; j < i; ++j) {
            int k = TextureUtil.argbToABGR(intBuffer.get(j));
            int l = function.applyAsInt(k);
            intBuffer.put(j, TextureUtil.argbToABGR(l));
        }
    }

    public static int argbToABGR(int i) {
        return i & 0xFF00FF00 | (i & 0xFF0000) >> 16 | (i & 0xFF) << 16;
    }

    public static void applyWaterTint(class_3940 particle, class_638 level, class_2338 blockPos) {
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            if (!opts.getClass().equals(ConfigData.ParticleData.class) || !opts.id.equals("rain")) continue;
            opts.tintType.applyTint(particle, level, blockPos, opts);
        }
    }

    public static class_1011 loadTexture(class_2960 location) throws IOException {
        return TextureUtil.loadTexture(class_310.method_1551().method_1478().getResourceOrThrow(location));
    }

    public static class_1011 loadTexture(class_3298 resource) throws IOException {
        class_1011 nativeImage;
        try (InputStream inputStream = resource.method_14482();){
            nativeImage = class_1011.method_4309((InputStream)inputStream);
        }
        return nativeImage;
    }

    public static class_7764 splitImage(class_1011 image, int segment, String id) {
        int size = image.method_4307();
        class_1011 sprite = new class_1011(size, size, false);
        image.method_47594(sprite, 0, size * segment, 0, 0, size, size, true, true);
        return VersionUtil.newNonAnimatedSpriteContents(id + segment, new class_7771(size, size), sprite);
    }

    public static int getRippleResolution(List<class_7764> contents) {
        if (ConfigManager.config.ripple.useResourcepackResolution) {
            class_2960 resourceLocation = VersionUtil.getMcId("big_smoke_0");
            for (class_7764 spriteContents : contents) {
                if (!spriteContents.method_45816().equals((Object)resourceLocation)) continue;
                if (spriteContents.method_45807() < 256) {
                    return spriteContents.method_45807();
                }
                return 256;
            }
        }
        if (ConfigManager.config.ripple.resolution < 4) {
            ConfigManager.config.ripple.resolution = 4;
        }
        if (ConfigManager.config.ripple.resolution > 256) {
            ConfigManager.config.ripple.resolution = 256;
        }
        return ConfigManager.config.ripple.resolution;
    }

    public static class_7764 generateRipple(int i, int size) {
        float radius = (float)size / 2.0f / 8.0f * (float)(i + 1);
        class_1011 image = new class_1011(size, size, true);
        Color color = Color.WHITE;
        int colorint = (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
        TextureUtil.generateBresenhamCircle(image, size, (int)Math.clamp((float)1.0f, (float)((float)size / 2.0f - 1.0f), (float)radius), colorint);
        return VersionUtil.newNonAnimatedSpriteContents("ripple_" + i, new class_7771(size, size), image);
    }

    public static void generateBresenhamCircle(class_1011 image, int imgSize, int radius, int colorint) {
        int centerX = imgSize / 2;
        int centerY = imgSize / 2;
        int x = 0;
        int y = radius;
        int d = 3 - 2 * radius;
        TextureUtil.drawCirclePixel(centerX, centerY, x, y, image, colorint);
        while (y >= x) {
            d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * x + 6;
            TextureUtil.drawCirclePixel(centerX, centerY, ++x, y, image, colorint);
        }
    }

    static void drawCirclePixel(int xc, int yc, int x, int y, class_1011 img, int col) {
        img.method_61941(xc + x, yc + y, col);
        img.method_61941(xc - x, yc + y, col);
        img.method_61941(xc + x, yc - y, col);
        img.method_61941(xc - x, yc - y, col);
        img.method_61941(xc + y, yc + x, col);
        img.method_61941(xc - y, yc + x, col);
        img.method_61941(xc + y, yc - x, col);
        img.method_61941(xc - y, yc - x, col);
    }
}

