/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.mixin.tick;

import forge.me.thosea.badoptimizations.hook.CacheHooks;
import forge.me.thosea.badoptimizations.mixin.accessors.GameRendererAccessor;
import forge.me.thosea.badoptimizations.mixin.accessors.PlayerAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EndFlashState;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.attribute.EnvironmentAttributeProbe;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class})
public abstract class MixinLightTexture {
    @Shadow
    @Final
    private Minecraft minecraft;
    private EnvironmentAttributeProbe bo$probe;
    private GameRendererAccessor bo$gameRendererAccessor;
    private int bo$lastSkyColor;
    private float bo$lastSkyFactor;
    private float bo$lastEndFactor = 0.0f;
    private double bo$lastGamma;
    private DimensionType bo$lastDimension;
    private boolean bo$lastNightVision;
    private boolean bo$lastConduitPower;
    private float bo$previousSkyDarkness;

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/Minecraft;)V"}, at={@At(value="TAIL")})
    private void onInit(GameRenderer renderer, Minecraft client, CallbackInfo ci) {
        this.bo$gameRendererAccessor = (GameRendererAccessor)renderer;
        this.bo$probe = renderer.getMainCamera().attributeProbe();
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTick(CallbackInfo ci) {
        if (this.minecraft.player == null) {
            return;
        }
        if (!this.bo$isDirty()) {
            ci.cancel();
        }
    }

    private boolean bo$isDirty() {
        boolean hasNightVision;
        float factor;
        EndFlashState flash;
        int skyColor = (Integer)this.bo$probe.getValue(EnvironmentAttributes.SKY_LIGHT_COLOR, 1.0f);
        float skyFactor = ((Float)this.bo$probe.getValue(EnvironmentAttributes.SKY_LIGHT_FACTOR, 1.0f)).floatValue();
        if (this.bo$lastSkyColor != skyColor || this.bo$lastSkyFactor != skyFactor) {
            this.bo$lastSkyColor = skyColor;
            this.bo$lastSkyFactor = skyFactor;
            return true;
        }
        if (this.minecraft.player.isUnderWater() && ((PlayerAccessor)this.minecraft.player).bo$underwaterVisibilityTicks() < 600) {
            return true;
        }
        if (!((Boolean)this.minecraft.options.hideLightningFlash().get()).booleanValue() && (flash = this.minecraft.level.endFlashState()) != null && this.bo$lastEndFactor != (factor = flash.getIntensity(this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(false)))) {
            this.bo$lastEndFactor = factor;
            return true;
        }
        MobEffectInstance nightVision = this.minecraft.player.getEffect(MobEffects.NIGHT_VISION);
        boolean bl = hasNightVision = nightVision != null;
        if (this.bo$lastNightVision != hasNightVision) {
            this.bo$lastNightVision = hasNightVision;
            return true;
        }
        if (nightVision != null && nightVision.endsWithin(200)) {
            return true;
        }
        if (this.minecraft.player.hasEffect(MobEffects.DARKNESS)) {
            return true;
        }
        boolean conduitPower = this.minecraft.player.hasEffect(MobEffects.CONDUIT_POWER);
        if (this.bo$lastConduitPower != conduitPower) {
            this.bo$lastConduitPower = conduitPower;
            return true;
        }
        DimensionType dimension = this.minecraft.level.dimensionType();
        if (this.bo$lastDimension != dimension) {
            this.bo$lastDimension = dimension;
            return true;
        }
        float skyDarkness = this.bo$gameRendererAccessor.bo$getSkyDarkness();
        if (this.bo$previousSkyDarkness != skyDarkness) {
            this.bo$previousSkyDarkness = skyDarkness;
            return true;
        }
        double gamma = (Double)this.minecraft.options.gamma().get();
        if (this.bo$lastGamma != gamma) {
            this.bo$lastGamma = gamma;
            return true;
        }
        return CacheHooks.invokeCommon() || CacheHooks.invokeLightmap();
    }
}

