/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica;

import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.Reference;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.communication.FeatureSet;
import ch.endte.syncmatica.data.IFileStorage;
import ch.endte.syncmatica.data.SyncmaticManager;
import ch.endte.syncmatica.extended_core.PlayerIdentifierProvider;
import ch.endte.syncmatica.network.SyncmaticaPacket;
import ch.endte.syncmatica.network.handler.ClientPlayHandler;
import ch.endte.syncmatica.network.handler.ServerPlayHandler;
import ch.endte.syncmatica.service.DebugService;
import ch.endte.syncmatica.service.IService;
import ch.endte.syncmatica.service.JsonConfiguration;
import ch.endte.syncmatica.service.QuotaService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;

public class Context {
    private final IFileStorage files;
    private final CommunicationManager comMan;
    private final SyncmaticManager synMan;
    private FeatureSet fs = null;
    private final boolean server;
    private final boolean integratedServer;
    private final Path litematicFolder;
    private final Path worldFolder;
    private boolean isStarted = false;
    private final QuotaService quota;
    private final DebugService debugService;
    private final PlayerIdentifierProvider playerIdentifierProvider;
    private static boolean registerS2C = false;
    private static boolean registerC2S = false;

    public Context(IFileStorage fs, CommunicationManager comMan, SyncmaticManager synMan, Path litematicFolder) {
        this(fs, comMan, synMan, false, litematicFolder, false, null);
    }

    public Context(IFileStorage fs, CommunicationManager comMan, SyncmaticManager synMan, boolean isServer, Path litematicFolder, boolean integrated, Path worldFolder) {
        this.files = fs;
        fs.setContext(this);
        this.comMan = comMan;
        comMan.setContext(this);
        this.synMan = synMan;
        synMan.setContext(this);
        this.server = isServer;
        this.quota = isServer ? new QuotaService() : null;
        this.playerIdentifierProvider = new PlayerIdentifierProvider(this);
        this.debugService = new DebugService();
        this.litematicFolder = litematicFolder;
        if (!Files.exists(litematicFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(litematicFolder, new FileAttribute[0]);
            }
            catch (Exception e) {
                Syncmatica.LOGGER.fatal("Context(): Fatal error creating litematic Folder.  Exception: {}", (Object)e.getLocalizedMessage());
                throw new RuntimeException(e);
            }
        }
        this.integratedServer = integrated;
        this.worldFolder = worldFolder;
        this.loadConfiguration();
    }

    public PlayerIdentifierProvider getPlayerIdentifierProvider() {
        return this.playerIdentifierProvider;
    }

    public IFileStorage getFileStorage() {
        return this.files;
    }

    public CommunicationManager getCommunicationManager() {
        return this.comMan;
    }

    public SyncmaticManager getSyncmaticManager() {
        return this.synMan;
    }

    public QuotaService getQuotaService() {
        return this.quota;
    }

    public DebugService getDebugService() {
        return this.debugService;
    }

    public FeatureSet getFeatureSet() {
        if (this.fs == null) {
            this.generateFeatureSet();
        }
        return this.fs;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isClient() {
        return !this.server;
    }

    public boolean isIntegratedServer() {
        return this.integratedServer;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public Path getLitematicFolder() {
        return this.litematicFolder;
    }

    private void generateFeatureSet() {
        this.fs = new FeatureSet(Arrays.asList(Feature.values()));
    }

    public void startup() {
        Syncmatica.debug("Context#startup()", new Object[0]);
        this.registerReceivers();
        this.startupServices();
        this.isStarted = true;
        this.synMan.startup();
    }

    public void shutdown() {
        Syncmatica.debug("Context#shutdown()", new Object[0]);
        this.shutdownServices();
        this.unregisterReceivers();
        this.isStarted = false;
        this.synMan.shutdown();
    }

    public void registerReceivers() {
        if (this.isServer() && !registerC2S) {
            if (Reference.isServer() || Reference.isIntegratedServer() || Reference.isOpenToLan()) {
                Syncmatica.debug("Context#registerReceivers(): [SERVER] -> registerSyncmaticaHandler", new Object[0]);
                ServerPlayNetworking.registerGlobalReceiver(SyncmaticaPacket.Payload.ID, ServerPlayHandler::receiveSyncPayload);
                registerC2S = true;
            } else {
                Syncmatica.LOGGER.error("Context#registerReceivers(): isServer() Exception");
            }
        } else if (Reference.isClient() && !registerS2C) {
            Syncmatica.debug("Context#registerReceivers(): [CLIENT] -> registerSyncmaticaHandler", new Object[0]);
            ClientPlayNetworking.registerGlobalReceiver(SyncmaticaPacket.Payload.ID, ClientPlayHandler::receiveSyncPayload);
            registerS2C = true;
        } else {
            Syncmatica.LOGGER.error("Context#registerReceivers(): isClient() Exception");
        }
    }

    public void unregisterReceivers() {
        if (this.isServer()) {
            Syncmatica.debug("Context#unregisterReceivers(): [SERVER] -> unregisterSyncmaticaHandlers", new Object[0]);
            ServerPlayNetworking.unregisterGlobalReceiver((class_2960)SyncmaticaPacket.Payload.ID.comp_2242());
            registerC2S = false;
        } else {
            Syncmatica.debug("Context#unregisterReceivers(): [CLIENT] -> unregisterSyncmaticaHandlers", new Object[0]);
            ClientPlayNetworking.unregisterGlobalReceiver((class_2960)SyncmaticaPacket.Payload.ID.comp_2242());
            registerS2C = false;
        }
    }

    public boolean checkPartnerVersion(String version) {
        return !version.equals("0.0.1");
    }

    public Path getConfigFolder() {
        if (this.isServer()) {
            return this.worldFolder.resolve("syncmatica").normalize();
        }
        return Reference.CONFIG_ROOT.resolve("syncmatica").normalize();
    }

    public Path getConfigFile() {
        return this.getConfigFolder().resolve("config.json");
    }

    public Path getAndCreateConfigFile() throws IOException {
        Path dir = this.getConfigFolder();
        if (!Files.exists(dir, new LinkOption[0])) {
            Syncmatica.debug("creating config folder: [{}]", dir.toAbsolutePath().toString());
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        Syncmatica.debug("config dir: [{}]", dir.toAbsolutePath().toString());
        Path configFile = this.getConfigFile();
        if (!Files.exists(configFile, new LinkOption[0])) {
            Files.createFile(configFile, new FileAttribute[0]);
        }
        return configFile;
    }

    public void loadConfiguration() {
        JsonObject configuration;
        boolean attemptToLoad = false;
        Path f = this.getConfigFile();
        Syncmatica.debug("loadConfig(): config file: '{}'", f.toAbsolutePath().toString());
        try {
            configuration = (JsonObject)new Gson().fromJson((Reader)new BufferedReader(new FileReader(f.toFile())), JsonObject.class);
            attemptToLoad = true;
        }
        catch (Exception ignored) {
            configuration = new JsonObject();
        }
        boolean needsRewrite = false;
        if (this.isServer()) {
            needsRewrite = this.loadConfigurationForService(this.quota, configuration, attemptToLoad);
        }
        if (needsRewrite |= this.loadConfigurationForService(this.debugService, configuration, attemptToLoad).booleanValue()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getAndCreateConfigFile().toFile()));){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String jsonString = gson.toJson((JsonElement)configuration);
                writer.write(jsonString);
            }
            catch (Exception e) {
                Syncmatica.LOGGER.error("loadConfiguration(): Exception loading config file '{}'; {}", (Object)f.getFileName().toString(), (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }

    private Boolean loadConfigurationForService(IService service, JsonObject configuration, boolean attemptToLoad) {
        String configKey = service.getConfigKey();
        JsonObject serviceJson = null;
        JsonConfiguration serviceConfiguration = null;
        boolean started = false;
        if (attemptToLoad && configuration.has(configKey)) {
            try {
                serviceJson = configuration.getAsJsonObject(configKey);
                if (serviceJson != null) {
                    serviceConfiguration = new JsonConfiguration(serviceJson);
                    service.configure(serviceConfiguration);
                    started = true;
                    if (!serviceConfiguration.hadError().booleanValue()) {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                Syncmatica.LOGGER.error("loadConfigurationForService(): Exception loading service config; {}", (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (serviceJson == null) {
            serviceJson = new JsonObject();
            configuration.add(configKey, (JsonElement)serviceJson);
        }
        if (serviceConfiguration == null) {
            serviceConfiguration = new JsonConfiguration(serviceJson);
        }
        service.getDefaultConfiguration(serviceConfiguration);
        if (!started) {
            service.configure(serviceConfiguration);
        }
        return true;
    }

    private void startupServices() {
        Syncmatica.debug("Context#startupServices()", new Object[0]);
        if (this.quota != null) {
            this.quota.startup();
        }
        this.debugService.startup();
    }

    private void shutdownServices() {
        Syncmatica.debug("Context#shutdownServices()", new Object[0]);
        if (this.quota != null) {
            this.quota.shutdown();
        }
        this.debugService.shutdown();
    }

    public static class ContextMismatchException
    extends RuntimeException {
        private static final long serialVersionUID = 2769376183212635479L;

        public ContextMismatchException(String reason) {
            super(reason);
        }
    }

    public static class DuplicateContextAssignmentException
    extends RuntimeException {
        private static final long serialVersionUID = -5147544661160756303L;

        public DuplicateContextAssignmentException(String reason) {
            super(reason);
        }
    }
}

