/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Reference;
import ch.endte.syncmatica.command.SyncmaticaCommand;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.data.IFileStorage;
import ch.endte.syncmatica.data.SyncmaticManager;
import ch.endte.syncmatica.network.SyncmaticaPacket;
import ch.endte.syncmatica.network.actor.ActorClientPlayHandler;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Syncmatica {
    public static Logger LOGGER = LogManager.getLogger((String)"syncmatica");
    protected static final Path SERVER_PATH = Reference.GAME_ROOT.resolve("syncmatics");
    protected static final Path CLIENT_PATH = Reference.GAME_ROOT.resolve("schematics").resolve("sync");
    public static final class_2960 CLIENT_CONTEXT = class_2960.method_60655((String)"syncmatica", (String)"client_context");
    public static final class_2960 SERVER_CONTEXT = class_2960.method_60655((String)"syncmatica", (String)"server_context");
    public static final class_2960 NETWORK_ID = class_2960.method_60655((String)"syncmatica", (String)"main");
    public static final UUID syncmaticaId = UUID.fromString("4c1b738f-56fa-4011-8273-498c972424ea");
    protected static Map<class_2960, Context> contexts = null;
    protected static boolean context_init = false;

    public static void preInit() {
        Syncmatica.debug("Syncmatica#preInit(): registering play channel(s)", new Object[0]);
        PayloadTypeRegistry.playC2S().register(SyncmaticaPacket.Payload.ID, SyncmaticaPacket.Payload.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncmaticaPacket.Payload.ID, SyncmaticaPacket.Payload.CODEC);
    }

    public static void debug(String msg, Object ... args) {
    }

    public static Context getContext(class_2960 id) {
        if (context_init) {
            return contexts.get(id);
        }
        return null;
    }

    static void init(Context con, class_2960 contextId) {
        Syncmatica.debug("Syncmatica#init()", new Object[0]);
        if (contexts == null) {
            contexts = new HashMap<class_2960, Context>();
        }
        contexts.put(contextId, con);
        context_init = true;
    }

    public static void shutdown() {
        Syncmatica.debug("Syncmatica#shutdown()", new Object[0]);
        if (contexts != null) {
            for (Context con : contexts.values()) {
                if (!con.isStarted()) continue;
                con.shutdown();
            }
        }
        Syncmatica.deinit();
    }

    private static void deinit() {
        Syncmatica.debug("Syncmatica#deinit()", new Object[0]);
        contexts = null;
        context_init = false;
    }

    public static Context initClient(CommunicationManager comms, IFileStorage fileStorage, SyncmaticManager schematics) {
        Syncmatica.debug("Syncmatica#initClient()", new Object[0]);
        Context clientContext = new Context(fileStorage, comms, schematics, CLIENT_PATH);
        Syncmatica.init(clientContext, CLIENT_CONTEXT);
        return clientContext;
    }

    public static void restartClient() {
        Syncmatica.debug("Syncmatica#restartClient()", new Object[0]);
        Context oldClient = Syncmatica.getContext(CLIENT_CONTEXT);
        if (oldClient != null) {
            if (oldClient.isStarted()) {
                oldClient.shutdown();
            }
            contexts.remove(CLIENT_CONTEXT);
        }
        ActorClientPlayHandler.getInstance().startClient();
    }

    public static Context initServer(CommunicationManager comms, IFileStorage fileStorage, SyncmaticManager schematics, boolean isIntegratedServer, Path worldPath) {
        Syncmatica.debug("Syncmatica#initServer()", new Object[0]);
        Context serverContext = new Context(fileStorage, comms, schematics, true, SERVER_PATH, isIntegratedServer, worldPath);
        Syncmatica.debug("INIT:Server Context; world path: '{}'", worldPath.toAbsolutePath().toString());
        Syncmatica.init(serverContext, SERVER_CONTEXT);
        SyncmaticaCommand.INSTANCE.updateSyncmaticDir(serverContext);
        return serverContext;
    }

    protected Syncmatica() {
    }
}

