/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.MessageType;
import ch.endte.syncmatica.communication.exchange.DownloadExchange;
import ch.endte.syncmatica.communication.exchange.Exchange;
import ch.endte.syncmatica.communication.exchange.VersionHandshakeClient;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.ScreenHelper;
import ch.endte.syncmatica.network.PacketType;
import fi.dy.masa.malilib.gui.Message;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_2540;

public class ClientCommunicationManager
extends CommunicationManager {
    private final ExchangeTarget server;
    private final Collection<ServerPlacement> sharing;

    public ClientCommunicationManager(ExchangeTarget server) {
        this.server = server;
        this.broadcastTargets.add(server);
        this.sharing = new HashSet<ServerPlacement>();
    }

    public ExchangeTarget getServer() {
        return this.server;
    }

    @Override
    protected void handle(ExchangeTarget source, PacketType type, class_2540 packetBuf) {
        if (type.equals((Object)PacketType.REGISTER_METADATA)) {
            ServerPlacement placement = this.receiveMetaData(packetBuf, source);
            this.context.getSyncmaticManager().addPlacement(placement);
            return;
        }
        if (type.equals((Object)PacketType.REMOVE_SYNCMATIC)) {
            UUID placementId = packetBuf.method_10790();
            ServerPlacement placement = this.context.getSyncmaticManager().getPlacement(placementId);
            if (placement != null) {
                Exchange modifier = this.getModifier(placement);
                if (modifier != null) {
                    modifier.close(false);
                    this.notifyClose(modifier);
                }
                this.context.getSyncmaticManager().removePlacement(placement);
                if (LitematicManager.getInstance().isRendered(placement)) {
                    LitematicManager.getInstance().unrenderSyncmatic(placement);
                }
            }
            return;
        }
        if (type.equals((Object)PacketType.MODIFY)) {
            UUID placementId = packetBuf.method_10790();
            ServerPlacement toModify = this.context.getSyncmaticManager().getPlacement(placementId);
            this.receivePositionData(toModify, packetBuf, source);
            if (source.getFeatureSet().hasFeature(Feature.CORE_EX)) {
                PlayerIdentifier lastModifiedBy = this.context.getPlayerIdentifierProvider().createOrGet(packetBuf.method_10790(), packetBuf.method_10800(this.PACKET_MAX_STRING_SIZE));
                toModify.setLastModifiedBy(lastModifiedBy);
            }
            LitematicManager.getInstance().updateRendered(toModify);
            this.context.getSyncmaticManager().updateServerPlacement(toModify);
            return;
        }
        if (type.equals((Object)PacketType.MESSAGE)) {
            Message.MessageType msgType = this.mapMessageType(MessageType.valueOf(packetBuf.method_10800(this.PACKET_MAX_STRING_SIZE)));
            String text = packetBuf.method_10800(this.PACKET_MAX_STRING_SIZE);
            ScreenHelper.ifPresent(s -> s.addMessage(msgType, text, new Object[0]));
            return;
        }
        if (type.equals((Object)PacketType.REGISTER_VERSION)) {
            LitematicManager.clear();
            LitematicManager.getInstance().setActiveContext(this.context);
            VersionHandshakeClient hi = new VersionHandshakeClient(this.server, this.context);
            this.startExchange(hi);
            hi.handle(type, packetBuf);
        }
    }

    @Override
    protected void handleExchange(Exchange exchange) {
        if (exchange instanceof DownloadExchange && exchange.isSuccessful()) {
            LitematicManager.getInstance().renderSyncmatic(((DownloadExchange)exchange).getPlacement());
        }
    }

    @Override
    public void setDownloadState(ServerPlacement syncmatic, boolean state) {
        this.downloadState.put(syncmatic.getHash(), state);
        if (state || LitematicManager.getInstance().isRendered(syncmatic)) {
            this.context.getSyncmaticManager().updateServerPlacement(syncmatic);
        }
    }

    public void setSharingState(ServerPlacement placement, boolean state) {
        if (state) {
            this.sharing.add(placement);
        } else {
            this.sharing.remove(placement);
        }
    }

    public boolean getSharingState(ServerPlacement placement) {
        return this.sharing.contains(placement);
    }

    @Override
    public void setContext(Context con) {
        super.setContext(con);
        VersionHandshakeClient hi = new VersionHandshakeClient(this.server, this.context);
        this.startExchangeUnchecked(hi);
    }

    private Message.MessageType mapMessageType(MessageType m) {
        return switch (m) {
            case MessageType.SUCCESS -> Message.MessageType.SUCCESS;
            case MessageType.WARNING -> Message.MessageType.WARNING;
            case MessageType.ERROR -> Message.MessageType.ERROR;
            default -> Message.MessageType.INFO;
        };
    }
}

