/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication;

import ch.endte.syncmatica.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FeatureSet {
    private static final Map<String, FeatureSet> versionFeatures = new HashMap<String, FeatureSet>();
    private final Collection<Feature> features;

    public static FeatureSet fromVersionString(String version) {
        if (version.matches("^\\d+(\\.\\d+){2,4}$")) {
            int minSize = version.indexOf(".");
            while (version.length() > minSize) {
                if (versionFeatures.containsKey(version)) {
                    return versionFeatures.get(version);
                }
                int lastDot = version.lastIndexOf(".");
                version = version.substring(0, lastDot);
            }
        }
        return null;
    }

    public static FeatureSet fromString(String features) {
        FeatureSet featureSet = new FeatureSet(new ArrayList<Feature>());
        for (String feature : features.split("\n")) {
            Feature f = Feature.fromString(feature);
            if (f == null) continue;
            featureSet.features.add(f);
        }
        return featureSet;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        boolean b = false;
        for (Feature feature : this.features) {
            output.append((String)(b ? "\n" + feature.toString() : feature.toString()));
            b = true;
        }
        return output.toString();
    }

    public FeatureSet(Collection<Feature> features) {
        this.features = features;
    }

    public boolean hasFeature(Feature f) {
        return this.features.contains((Object)f);
    }

    static {
        versionFeatures.put("0.1", new FeatureSet(Collections.singletonList(Feature.CORE)));
    }
}

