/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.exchange.AbstractExchange;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.network.PacketType;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_2540;

public class ModifyExchangeServer
extends AbstractExchange {
    private final ServerPlacement placement;
    UUID placementId;

    public ModifyExchangeServer(UUID placeId, ExchangeTarget partner, Context con) {
        super(partner, con);
        this.placementId = placeId;
        this.placement = con.getSyncmaticManager().getPlacement(this.placementId);
    }

    @Override
    public boolean checkPacket(PacketType type, class_2540 packetBuf) {
        return type.equals((Object)PacketType.MODIFY_FINISH) && ModifyExchangeServer.checkUUID(packetBuf, this.placement.getId());
    }

    @Override
    public void handle(PacketType type, class_2540 packetBuf) {
        packetBuf.method_10790();
        if (type.equals((Object)PacketType.MODIFY_FINISH)) {
            this.getContext().getCommunicationManager().receivePositionData(this.placement, packetBuf, this.getPartner());
            PlayerIdentifier identifier = this.getContext().getPlayerIdentifierProvider().createOrGet(this.getPartner());
            this.placement.setLastModifiedBy(identifier);
            this.getContext().getSyncmaticManager().updateServerPlacement(this.placement);
            this.succeed();
        }
    }

    @Override
    public void init() {
        if (this.getPlacement() == null || this.getContext().getCommunicationManager().getModifier(this.placement) != null) {
            this.close(true);
        } else {
            this.accept();
        }
    }

    private void accept() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(this.placement.getId());
        this.getPartner().sendPacket(PacketType.MODIFY_REQUEST_ACCEPT, buf, this.getContext());
        this.getContext().getCommunicationManager().setModifier(this.placement, this);
    }

    @Override
    protected void sendCancelPacket() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(this.placementId);
        this.getPartner().sendPacket(PacketType.MODIFY_REQUEST_DENY, buf, this.getContext());
    }

    public ServerPlacement getPlacement() {
        return this.placement;
    }

    @Override
    protected void onClose() {
        if (this.getContext().getCommunicationManager().getModifier(this.placement) == this) {
            this.getContext().getCommunicationManager().setModifier(this.placement, null);
        }
    }
}

