/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.communication.ClientCommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.exchange.AbstractExchange;
import ch.endte.syncmatica.communication.exchange.UploadExchange;
import ch.endte.syncmatica.data.RedirectFileStorage;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.network.PacketType;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import net.minecraft.class_2540;

public class ShareLitematicExchange
extends AbstractExchange {
    private final SchematicPlacement schematicPlacement;
    private final ServerPlacement toShare;
    private final Path toUpload;

    public ShareLitematicExchange(SchematicPlacement schematicPlacement, ExchangeTarget partner, Context con) {
        this(schematicPlacement, partner, con, null);
    }

    public ShareLitematicExchange(SchematicPlacement schematicPlacement, ExchangeTarget partner, Context con, ServerPlacement p) {
        super(partner, con);
        this.schematicPlacement = schematicPlacement;
        this.toShare = p == null ? LitematicManager.getInstance().syncmaticFromSchematic(schematicPlacement) : p;
        this.toUpload = schematicPlacement.getSchematicFile();
    }

    @Override
    public boolean checkPacket(PacketType type, class_2540 packetBuf) {
        if (type.equals((Object)PacketType.REQUEST_LITEMATIC) || type.equals((Object)PacketType.REGISTER_METADATA) || type.equals((Object)PacketType.CANCEL_SHARE)) {
            return AbstractExchange.checkUUID(packetBuf, this.toShare.getId());
        }
        return false;
    }

    @Override
    public void handle(PacketType type, class_2540 packetBuf) {
        if (type.equals((Object)PacketType.REQUEST_LITEMATIC)) {
            UploadExchange upload;
            packetBuf.method_10790();
            try {
                upload = new UploadExchange(this.toShare, this.toUpload, this.getPartner(), this.getContext());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return;
            }
            this.getManager().startExchange(upload);
            return;
        }
        if (type.equals((Object)PacketType.REGISTER_METADATA)) {
            RedirectFileStorage redirect = (RedirectFileStorage)this.getContext().getFileStorage();
            redirect.addRedirect(this.toUpload);
            LitematicManager.getInstance().renderSyncmatic(this.toShare, this.schematicPlacement, false);
            this.getContext().getSyncmaticManager().addPlacement(this.toShare);
            this.succeed();
            return;
        }
        if (type.equals((Object)PacketType.CANCEL_SHARE)) {
            this.close(false);
        }
    }

    @Override
    public void init() {
        if (this.toShare == null) {
            this.close(false);
            return;
        }
        ((ClientCommunicationManager)this.getManager()).setSharingState(this.toShare, true);
        this.getContext().getSyncmaticManager().updateServerPlacement(this.toShare);
        this.getManager().sendMetaData(this.toShare, this.getPartner());
    }

    @Override
    public void onClose() {
        ((ClientCommunicationManager)this.getManager()).setSharingState(this.toShare, false);
    }
}

