/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.data;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.data.ServerPosition;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.extended_core.SubRegionData;
import ch.endte.syncmatica.litematica.schematic.SchematicMetadata;
import ch.endte.syncmatica.litematica.schematic.SchematicSchema;
import ch.endte.syncmatica.material.SyncmaticaMaterialList;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import org.apache.commons.lang3.tuple.Pair;

public class ServerPlacement {
    private final UUID id;
    private final UUID hashValue;
    private Path file;
    private String fileName;
    private PlayerIdentifier owner;
    private PlayerIdentifier lastModifiedBy;
    private ServerPosition origin;
    private class_2470 rotation;
    private class_2415 mirror;
    private SubRegionData subRegionData = new SubRegionData();
    private String displayName;
    private boolean dirty;
    private int dataVersion;
    private int litematicVersion;
    private SyncmaticaMaterialList matList;

    public ServerPlacement(UUID id, Path file, String fileName, String displayName, UUID hashValue, PlayerIdentifier owner, int litematicVersion, int dataVersion) {
        this.id = id;
        this.file = file;
        this.fileName = fileName;
        this.displayName = displayName;
        this.hashValue = hashValue;
        this.owner = owner;
        this.lastModifiedBy = owner;
        this.litematicVersion = litematicVersion;
        this.dataVersion = dataVersion;
        this.dirty = false;
    }

    public ServerPlacement(UUID id, Path file, String displayName, PlayerIdentifier owner) {
        this(id, file, file.toAbsolutePath().toString(), displayName, ServerPlacement.generateHash(file), owner, -1, -1);
    }

    public ServerPlacement(UUID id, String fileName, String displayName, UUID hash, PlayerIdentifier owner) {
        this(id, Path.of(fileName, new String[0]), fileName, displayName, hash, owner, -1, -1);
    }

    public ServerPlacement(UUID id, String fileName, String displayName, UUID hash, PlayerIdentifier owner, int litematicVersion, int dataVersion) {
        this(id, Path.of(fileName, new String[0]), fileName, displayName, hash, owner, litematicVersion, dataVersion);
    }

    public UUID getId() {
        return this.id;
    }

    public Path getFile() {
        return this.file;
    }

    public String getName() {
        return this.displayName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public UUID getHash() {
        return this.hashValue;
    }

    public String getDimension() {
        return this.origin.getDimensionId();
    }

    public class_2338 getPosition() {
        return this.origin.getBlockPosition();
    }

    public ServerPosition getOrigin() {
        return this.origin;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    public int getLitematicVersion() {
        return this.litematicVersion;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public ServerPlacement setVersion(int litematicVersion, int dataVersion) {
        this.litematicVersion = litematicVersion;
        this.dataVersion = dataVersion;
        return this;
    }

    public ServerPlacement move(String dimensionId, class_2338 origin, class_2470 rotation, class_2415 mirror) {
        this.move(new ServerPosition(origin, dimensionId), rotation, mirror);
        return this;
    }

    public ServerPlacement move(ServerPosition origin, class_2470 rotation, class_2415 mirror) {
        this.origin = origin;
        this.rotation = rotation;
        this.mirror = mirror;
        return this;
    }

    public ServerPlacement setFile(Path file) {
        this.file = file;
        this.fileName = file.toAbsolutePath().toString();
        return this;
    }

    public ServerPlacement setSchema(SchematicSchema schema) {
        this.litematicVersion = schema.litematicVersion();
        this.dataVersion = schema.minecraftDataVersion();
        return this;
    }

    public ServerPlacement setMetadata(SchematicMetadata meta) {
        this.displayName = meta.getName();
        return this;
    }

    public PlayerIdentifier getOwner() {
        return this.owner;
    }

    public void setOwner(PlayerIdentifier playerIdentifier) {
        this.owner = playerIdentifier;
    }

    public PlayerIdentifier getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(PlayerIdentifier lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public SubRegionData getSubRegionData() {
        return this.subRegionData;
    }

    public SyncmaticaMaterialList getMaterialList() {
        return this.matList;
    }

    public ServerPlacement setMaterialList(SyncmaticaMaterialList matList) {
        if (this.matList != null) {
            this.matList = matList;
        }
        return this;
    }

    public static String removeExtension(Path file) {
        String fileName = file.toString();
        int pos = fileName.lastIndexOf(".");
        return fileName.substring(0, pos);
    }

    public static String removeExtension(String fileName) {
        int pos = fileName.lastIndexOf(".");
        return fileName.substring(0, pos);
    }

    public static String normalizeFileName(String badFileName) {
        String fileName = badFileName;
        if (badFileName.contains("/") || badFileName.contains("\\")) {
            fileName = SyncmaticaUtil.sanitizeUnicodeSubDirFileName(badFileName);
            Path dirtyPath = Paths.get(fileName, new String[0]);
            fileName = dirtyPath.getFileName().toString();
        } else {
            fileName = SyncmaticaUtil.sanitizeUnicodeFileName(badFileName);
        }
        Syncmatica.debug("normalizeFileName(): Normalizing placement filename '{}' to: '{}'", badFileName, fileName);
        return fileName;
    }

    public String getNormalFileName() {
        return ServerPlacement.normalizeFileName(this.fileName);
    }

    private static UUID generateHash(Path file) {
        UUID hash = null;
        try {
            hash = SyncmaticaUtil.createChecksum(new FileInputStream(file.toFile()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return hash;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("id", (JsonElement)new JsonPrimitive(this.id.toString()));
        obj.add("file_name", (JsonElement)new JsonPrimitive(this.fileName));
        obj.add("display_name", (JsonElement)new JsonPrimitive(this.displayName));
        obj.add("hash", (JsonElement)new JsonPrimitive(this.hashValue.toString()));
        obj.add("origin", (JsonElement)this.origin.toJson());
        obj.add("rotation", (JsonElement)new JsonPrimitive(this.rotation.name()));
        obj.add("mirror", (JsonElement)new JsonPrimitive(this.mirror.name()));
        obj.add("owner", (JsonElement)this.owner.toJson());
        if (!this.owner.equals(this.lastModifiedBy)) {
            obj.add("lastModifiedBy", (JsonElement)this.lastModifiedBy.toJson());
        }
        if (this.subRegionData.isModified()) {
            obj.add("subregionData", this.subRegionData.toJson());
        }
        if (this.litematicVersion > -1) {
            obj.add("litematicVersion", (JsonElement)new JsonPrimitive((Number)this.litematicVersion));
        }
        if (this.dataVersion > -1) {
            obj.add("dataVersion", (JsonElement)new JsonPrimitive((Number)this.dataVersion));
        }
        return obj;
    }

    public static ServerPlacement fromJson(JsonObject obj, Context context) {
        if (obj.has("id") && obj.has("file_name") && obj.has("hash") && obj.has("origin") && obj.has("rotation") && obj.has("mirror")) {
            Path testFile;
            Pair<SchematicMetadata, SchematicSchema> pair;
            String displayName;
            UUID id = UUID.fromString(obj.get("id").getAsString());
            String badFileName = obj.get("file_name").getAsString();
            UUID hashValue = UUID.fromString(obj.get("hash").getAsString());
            int version = -1;
            int dataVersion = -1;
            boolean dirty = false;
            PlayerIdentifier owner = PlayerIdentifier.MISSING_PLAYER;
            if (obj.has("owner")) {
                owner = context.getPlayerIdentifierProvider().fromJson(obj.get("owner").getAsJsonObject());
            }
            if (obj.has("display_name")) {
                displayName = obj.get("display_name").getAsString();
            } else {
                displayName = ServerPlacement.normalizeFileName(badFileName);
                Syncmatica.debug("ServerPlacement#fromJson(): displayName NORMALIZE [{}] --> Dirty", displayName);
                dirty = true;
            }
            if (obj.has("litematicVersion")) {
                version = obj.get("litematicVersion").getAsInt();
            }
            if (obj.has("dataVersion")) {
                dataVersion = obj.get("dataVersion").getAsInt();
            }
            Object fileName = badFileName;
            if (!badFileName.endsWith(".litematic")) {
                fileName = SyncmaticaUtil.sanitizeUnicodeFileName(badFileName) + ".litematic";
                Syncmatica.debug("ServerPlacement#fromJson(): no Extension [{}] -> [{}] --> Dirty", badFileName, fileName);
                dirty = true;
            }
            if (context.isServer() && (pair = SyncmaticaUtil.litematicPeek(testFile = context.getLitematicFolder().resolve(String.valueOf(hashValue) + ".litematic"))).getLeft() != null && !displayName.equals(((SchematicMetadata)pair.getLeft()).getName())) {
                displayName = ((SchematicMetadata)pair.getLeft()).getName();
                version = ((SchematicSchema)pair.getRight()).litematicVersion();
                dataVersion = ((SchematicSchema)pair.getRight()).minecraftDataVersion();
                Syncmatica.debug("ServerPlacement#fromJson(): Fix Metadata Name: [{}] --> Dirty", displayName);
                dirty = true;
            }
            ServerPlacement newPlacement = new ServerPlacement(id, (String)fileName, displayName, hashValue, owner, version, dataVersion);
            ServerPosition pos = ServerPosition.fromJson(obj.get("origin").getAsJsonObject());
            if (pos == null) {
                return null;
            }
            newPlacement.origin = pos;
            newPlacement.rotation = class_2470.valueOf((String)obj.get("rotation").getAsString());
            newPlacement.mirror = class_2415.valueOf((String)obj.get("mirror").getAsString());
            if (obj.has("lastModifiedBy")) {
                newPlacement.lastModifiedBy = context.getPlayerIdentifierProvider().fromJson(obj.get("lastModifiedBy").getAsJsonObject());
            } else {
                if (!newPlacement.lastModifiedBy.getName().equals(owner.getName())) {
                    Syncmatica.debug("ServerPlacement#fromJson(): Update owner: [{}] -> [{}] --> Dirty", newPlacement.lastModifiedBy.getName(), owner.getName());
                    dirty = true;
                }
                newPlacement.lastModifiedBy = owner;
            }
            if (obj.has("subregionData")) {
                newPlacement.subRegionData = SubRegionData.fromJson(obj.get("subregionData"));
            }
            if (dirty) {
                newPlacement.markDirty();
            }
            return newPlacement;
        }
        return null;
    }
}

