/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.data.RedirectFileStorage;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.data.ServerPosition;
import ch.endte.syncmatica.data.SyncmaticManager;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.extended_core.SubRegionData;
import ch.endte.syncmatica.extended_core.SubRegionPlacementModification;
import ch.endte.syncmatica.litematica.PlacementEventHandler;
import ch.endte.syncmatica.litematica.ScreenHelper;
import ch.endte.syncmatica.litematica.schematic.FileType;
import ch.endte.syncmatica.litematica.schematic.SchematicMetadata;
import ch.endte.syncmatica.litematica.schematic.SchematicSchema;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.interfaces.ISchematicPlacementEventListener;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementEventFlag;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementEventHandler;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.malilib.gui.Message;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;

public class LitematicManager {
    private static LitematicManager instance = null;
    protected static PlacementEventHandler eventHandler = null;
    private final Map<ServerPlacement, SchematicPlacement> rendering;
    private Collection<SchematicPlacement> preLoadList = new ArrayList<SchematicPlacement>();
    private Context context;

    public static LitematicManager getInstance() {
        if (instance == null) {
            instance = new LitematicManager();
            if (eventHandler == null) {
                eventHandler = new PlacementEventHandler();
                SchematicPlacementEventHandler.getInstance().registerSchematicPlacementEventListener((ISchematicPlacementEventListener)eventHandler, List.of(SchematicPlacementEventFlag.ALL_EVENTS));
            }
        }
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    private LitematicManager() {
        this.rendering = new HashMap<ServerPlacement, SchematicPlacement>();
    }

    public void setActiveContext(Context con) {
        if (con.isServer()) {
            throw new Context.ContextMismatchException("Applied server context where client context was expected");
        }
        this.context = con;
        ScreenHelper.ifPresent(s -> s.setActiveContext(con));
        this.context.getSyncmaticManager().addServerPlacementConsumer(this::checkSyncMatches);
        for (ServerPlacement p : this.context.getSyncmaticManager().getAll()) {
            this.checkSyncMatches(p);
        }
    }

    private void checkSyncMatches(ServerPlacement p) {
        for (SchematicPlacement sm : DataManager.getSchematicPlacementManager().getAllSchematicsPlacements()) {
            UUID smId = eventHandler.getServerId(sm);
            if (smId == null || !smId.equals(p.getId())) continue;
            if (this.rendering.containsKey(p)) break;
            this.rendering.put(p, sm);
            ((RedirectFileStorage)this.context.getFileStorage()).addRedirect(sm.getSchematicFile());
            this.readVersionInfo(p, sm);
            break;
        }
    }

    public Context getActiveContext() {
        return this.context;
    }

    public void renderSyncmatic(ServerPlacement placement) {
        String dimension = class_310.method_1551().method_1560().method_73183().method_27983().method_29177().toString();
        if (!dimension.equals(placement.getDimension())) {
            ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.player_dimension_mismatch", new Object[0]));
            this.context.getSyncmaticManager().updateServerPlacement(placement);
            return;
        }
        if (this.rendering.containsKey(placement)) {
            return;
        }
        Path file = this.context.getFileStorage().getLocalLitematic(placement);
        LitematicaSchematic schematic = SchematicHolder.getInstance().getOrLoad(file);
        if (schematic == null) {
            ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.failed_to_load", file.toAbsolutePath().toString()));
            return;
        }
        class_2338 origin = placement.getPosition();
        String displayName = placement.getName();
        if (displayName.equals(placement.getFileName())) {
            displayName = schematic.getMetadata().getName();
        } else if (displayName.isEmpty()) {
            displayName = ServerPlacement.removeExtension(file.toString());
        }
        Syncmatica.debug("renderSyncmatic() - displayName [{}] (schem: [{}])", displayName, schematic.getMetadata().getName());
        SchematicPlacement litematicaPlacement = SchematicPlacement.createFor((LitematicaSchematic)schematic, (class_2338)origin, (String)displayName, (boolean)true, (boolean)true);
        ServerPlacement adjusted = this.readVersionInfo(placement, litematicaPlacement);
        eventHandler.setServerId(litematicaPlacement, placement.getId());
        if (litematicaPlacement.isLocked()) {
            litematicaPlacement.toggleLocked();
        }
        litematicaPlacement.setRotation(placement.getRotation(), null);
        litematicaPlacement.setMirror(placement.getMirror(), null);
        this.transferSubregionDataToClientPlacement(placement, litematicaPlacement);
        litematicaPlacement.toggleLocked();
        this.rendering.put(Objects.requireNonNullElse(adjusted, placement), litematicaPlacement);
        DataManager.getSchematicPlacementManager().addSchematicPlacement(litematicaPlacement, true);
        if (DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement() == null) {
            DataManager.getSchematicPlacementManager().setSelectedSchematicPlacement(litematicaPlacement);
        }
        this.context.getSyncmaticManager().updateServerPlacement(placement);
    }

    public ServerPlacement syncmaticFromSchematic(SchematicPlacement schem) {
        if (this.rendering.containsValue(schem)) {
            for (ServerPlacement checkPlacement : this.rendering.keySet()) {
                if (this.rendering.get(checkPlacement) != schem) continue;
                return checkPlacement;
            }
            return null;
        }
        try {
            Path placementFile = schem.getSchematicFile();
            if (placementFile == null) {
                return null;
            }
            FileType fileType = FileType.fromFile(placementFile);
            if (fileType == FileType.VANILLA_STRUCTURE || fileType == FileType.SCHEMATICA_SCHEMATIC) {
                ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.share_incompatible_schematic", new Object[0]));
                return null;
            }
            if (fileType != FileType.LITEMATICA_SCHEMATIC) {
                ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.invalid_file", new Object[0]));
                return null;
            }
            PlayerIdentifier owner = this.context.getPlayerIdentifierProvider().createOrGet(class_310.method_1551().method_1548().method_44717(), class_310.method_1551().method_1548().method_1676());
            ServerPlacement placement = new ServerPlacement(UUID.randomUUID(), placementFile, schem.getName(), owner);
            String dimension = class_310.method_1551().method_1560().method_73183().method_27983().method_29177().toString();
            placement.move(dimension, schem.getOrigin(), schem.getRotation(), schem.getMirror());
            this.transferSubregionDataToServerPlacement(schem, placement);
            ServerPlacement adjusted = this.readVersionInfo(placement, schem);
            return Objects.requireNonNullElse(adjusted, placement);
        }
        catch (Exception e) {
            ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.ERROR, "syncmatica.error.create_from_schematic", e.getMessage()));
            return null;
        }
    }

    private void transferSubregionDataToServerPlacement(SchematicPlacement schem, ServerPlacement placement) {
        Collection subLitematica = schem.getAllSubRegionsPlacements();
        Map defaultPositionMap = schem.getSchematic().getAreaPositions();
        SubRegionData subRegionData = placement.getSubRegionData();
        subRegionData.reset();
        for (SubRegionPlacement subRegionPlacement : subLitematica) {
            class_2338 defaultPos;
            if (!this.isSubregionModified(subRegionPlacement, defaultPos = (class_2338)defaultPositionMap.get(subRegionPlacement.getName()))) continue;
            subRegionData.modify(subRegionPlacement.getName(), subRegionPlacement.getPos(), subRegionPlacement.getRotation(), subRegionPlacement.getMirror());
        }
    }

    private void transferSubregionDataToClientPlacement(ServerPlacement placement, SchematicPlacement schem) {
        Collection subLitematica = schem.getAllSubRegionsPlacements();
        Map defaultPositionMap = schem.getSchematic().getAreaPositions();
        Map<String, SubRegionPlacementModification> modificationData = placement.getSubRegionData().getModificationData();
        for (SubRegionPlacement subRegionPlacement : subLitematica) {
            SubRegionPlacementModification modification = modificationData != null ? modificationData.get(subRegionPlacement.getName()) : null;
            class_2338 defaultPos = (class_2338)defaultPositionMap.get(subRegionPlacement.getName());
            if (modification != null) {
                SchematicPlacementEventHandler.getInstance().invokePrePlacementChange((ISchematicPlacementEventListener)eventHandler, schem);
                SchematicPlacementEventHandler.getInstance().invokeSetSubRegionOrigin((ISchematicPlacementEventListener)eventHandler, subRegionPlacement, modification.position);
                SchematicPlacementEventHandler.getInstance().invokeSetSubRegionRotation((ISchematicPlacementEventListener)eventHandler, subRegionPlacement, modification.rotation);
                SchematicPlacementEventHandler.getInstance().invokeSetSubRegionMirror((ISchematicPlacementEventListener)eventHandler, subRegionPlacement, modification.mirror);
                SchematicPlacementEventHandler.getInstance().invokeSubRegionModified((ISchematicPlacementEventListener)eventHandler, schem, subRegionPlacement.getName());
                continue;
            }
            if (!this.isSubregionModified(subRegionPlacement, defaultPos)) continue;
            SchematicPlacementEventHandler.getInstance().invokePrePlacementChange((ISchematicPlacementEventListener)eventHandler, schem);
            this.resetSubRegion(subRegionPlacement, defaultPos);
            SchematicPlacementEventHandler.getInstance().invokeSubRegionModified((ISchematicPlacementEventListener)eventHandler, schem, subRegionPlacement.getName());
        }
    }

    public SchematicPlacement schematicFromSyncmatic(ServerPlacement p) {
        return this.rendering.get(p);
    }

    public void renderSyncmatic(ServerPlacement placement, SchematicPlacement litematicaPlacement, boolean addToRendering) {
        if (this.rendering.containsKey(placement)) {
            return;
        }
        UUID serverId = eventHandler.getServerId(litematicaPlacement);
        if (serverId != null && !serverId.equals(placement.getId())) {
            return;
        }
        ServerPlacement adjusted = this.readVersionInfo(placement, litematicaPlacement);
        eventHandler.setServerId(litematicaPlacement, placement.getId());
        if (litematicaPlacement.isLocked()) {
            litematicaPlacement.toggleLocked();
        }
        litematicaPlacement.setOrigin(placement.getPosition(), null);
        litematicaPlacement.setRotation(placement.getRotation(), null);
        litematicaPlacement.setMirror(placement.getMirror(), null);
        this.transferSubregionDataToClientPlacement(placement, litematicaPlacement);
        litematicaPlacement.toggleLocked();
        this.rendering.put(Objects.requireNonNullElse(adjusted, placement), litematicaPlacement);
        this.context.getSyncmaticManager().updateServerPlacement(placement);
        if (addToRendering) {
            DataManager.getSchematicPlacementManager().addSchematicPlacement(litematicaPlacement, false);
            if (DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement() == null) {
                DataManager.getSchematicPlacementManager().setSelectedSchematicPlacement(litematicaPlacement);
            }
        }
    }

    public void unrenderSyncmatic(ServerPlacement placement) {
        if (!this.isRendered(placement)) {
            return;
        }
        DataManager.getSchematicPlacementManager().removeSchematicPlacement(this.rendering.get(placement));
        this.rendering.remove(placement);
        this.context.getSyncmaticManager().updateServerPlacement(placement);
    }

    public void updateRendered(ServerPlacement placement) {
        if (!this.isRendered(placement)) {
            return;
        }
        SchematicPlacement litematicaPlacement = this.rendering.get(placement);
        boolean wasLocked = litematicaPlacement.isLocked();
        if (wasLocked) {
            litematicaPlacement.toggleLocked();
        }
        litematicaPlacement.setOrigin(placement.getPosition(), null);
        litematicaPlacement.setRotation(placement.getRotation(), null);
        litematicaPlacement.setMirror(placement.getMirror(), null);
        this.transferSubregionDataToClientPlacement(placement, litematicaPlacement);
        if (wasLocked) {
            litematicaPlacement.toggleLocked();
        }
    }

    public void updateServerPlacement(SchematicPlacement placement, ServerPlacement serverPlacement) {
        serverPlacement.move(serverPlacement.getDimension(), placement.getOrigin(), placement.getRotation(), placement.getMirror());
        this.transferSubregionDataToServerPlacement(placement, serverPlacement);
    }

    public boolean isRendered(ServerPlacement placement) {
        return this.rendering.containsKey(placement);
    }

    public boolean isSyncmatic(SchematicPlacement schem) {
        return this.rendering.containsValue(schem);
    }

    @Nullable
    public ServerPlacement getRenderingSyncmatic(SchematicPlacement schem) {
        AtomicReference temp = new AtomicReference();
        this.rendering.forEach((placement, schematicPlacement) -> {
            if (schematicPlacement.equals(schem)) {
                temp.set(placement);
            }
        });
        return (ServerPlacement)temp.get();
    }

    public boolean isSubregionModified(SubRegionPlacement subRegionPlacement, class_2338 defaultPos) {
        return subRegionPlacement.getMirror() != class_2415.field_11302 || subRegionPlacement.getRotation() != class_2470.field_11467 || !subRegionPlacement.getPos().equals((Object)defaultPos);
    }

    public void resetSubRegion(SubRegionPlacement subRegionPlacement, class_2338 defaultPos) {
        SchematicPlacementEventHandler.getInstance().invokeSetSubRegionOrigin((ISchematicPlacementEventListener)eventHandler, subRegionPlacement, defaultPos);
        SchematicPlacementEventHandler.getInstance().invokeSetSubRegionRotation((ISchematicPlacementEventListener)eventHandler, subRegionPlacement, class_2470.field_11467);
        SchematicPlacementEventHandler.getInstance().invokeSetSubRegionMirror((ISchematicPlacementEventListener)eventHandler, subRegionPlacement, class_2415.field_11302);
    }

    public void preLoad(SchematicPlacement schem) {
        if (this.context != null && this.context.isStarted()) {
            UUID id = eventHandler.getServerId(schem);
            ServerPlacement p = this.context.getSyncmaticManager().getPlacement(id);
            if (p == null) {
                return;
            }
            if (!this.isRendered(p)) {
                ServerPlacement adjusted = this.readVersionInfo(p, schem);
                this.rendering.put(Objects.requireNonNullElse(adjusted, p), schem);
                if (this.context.getFileStorage().getLocalLitematic(p) != schem.getSchematicFile()) {
                    ((RedirectFileStorage)this.context.getFileStorage()).addRedirect(schem.getSchematicFile());
                }
                DataManager.getSchematicPlacementManager().addSchematicPlacement(schem, false);
            }
        } else if (this.preLoadList != null) {
            this.preLoadList.add(schem);
        }
    }

    @Nullable
    private ServerPlacement readVersionInfo(ServerPlacement p, SchematicPlacement s) {
        try {
            Pair<SchematicMetadata, SchematicSchema> pair;
            Path file = s.getSchematicFile();
            if (file != null && file.toString().endsWith(".litematic") && (pair = SyncmaticaUtil.litematicPeek(file)) != null) {
                SchematicSchema schema = (SchematicSchema)pair.getRight();
                return p.setVersion(schema.litematicVersion(), schema.minecraftDataVersion());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void commitLoad() {
        SyncmaticManager man = this.context.getSyncmaticManager();
        if (this.preLoadList != null) {
            for (SchematicPlacement schem : this.preLoadList) {
                UUID id = eventHandler.getServerId(schem);
                ServerPlacement p = man.getPlacement(id);
                if (p == null) continue;
                if (this.context.getFileStorage().getLocalLitematic(p) != schem.getSchematicFile()) {
                    ((RedirectFileStorage)this.context.getFileStorage()).addRedirect(schem.getSchematicFile());
                }
                this.renderSyncmatic(p, schem, true);
            }
        }
        this.preLoadList = null;
    }

    public void unrenderSchematic(LitematicaSchematic l) {
        this.rendering.entrySet().removeIf(e -> {
            if (((SchematicPlacement)e.getValue()).getSchematic() == l) {
                this.context.getSyncmaticManager().updateServerPlacement((ServerPlacement)e.getKey());
                return true;
            }
            return false;
        });
    }

    public void unrenderSchematicPlacement(SchematicPlacement placement) {
        UUID id = eventHandler.getServerId(placement);
        ServerPlacement p = this.context.getSyncmaticManager().getPlacement(id);
        if (p != null) {
            this.unrenderSyncmatic(p);
        }
    }

    public ServerPosition getPlayerPosition() {
        if (class_310.method_1551().method_1560() != null) {
            class_2338 blockPos = class_310.method_1551().method_1560().method_24515();
            String dimensionId = this.getPlayerDimension();
            return new ServerPosition(blockPos, dimensionId);
        }
        return new ServerPosition(new class_2338(0, 0, 0), "minecraft:overworld");
    }

    public String getPlayerDimension() {
        if (class_310.method_1551().method_1560() != null) {
            return class_310.method_1551().method_1560().method_73183().method_27983().method_29177().toString();
        }
        return "minecraft:overworld";
    }
}

