/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica.schematic;

import ch.endte.syncmatica.litematica.schematic.FileType;
import ch.endte.syncmatica.litematica.schematic.Schema;
import ch.endte.syncmatica.litematica.schematic.SchematicSchema;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class SchematicMetadata {
    public static final Codec<SchematicMetadata> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.STRING.fieldOf("Name").forGetter(get -> get.name), (App)PrimitiveCodec.STRING.fieldOf("Author").forGetter(get -> get.author), (App)PrimitiveCodec.STRING.fieldOf("Description").forGetter(get -> get.description), (App)PrimitiveCodec.INT.fieldOf("RegionCount").forGetter(get -> get.regionCount), (App)PrimitiveCodec.INT.fieldOf("TotalVolume").forGetter(get -> get.totalVolume), (App)PrimitiveCodec.INT.fieldOf("TotalBlocks").forGetter(get -> get.totalBlocks), (App)PrimitiveCodec.LONG.fieldOf("TimeCreated").forGetter(get -> get.timeCreated), (App)PrimitiveCodec.LONG.fieldOf("TimeModified").forGetter(get -> get.timeModified), (App)class_2382.field_25123.fieldOf("EnclosingSize").forGetter(get -> get.enclosingSize), (App)PrimitiveCodec.INT_STREAM.optionalFieldOf("PreviewImageData", null).forGetter(get -> get.thumbnailPixelData)).apply((Applicative)inst, SchematicMetadata::new));
    private String name;
    private String author;
    private String description;
    private class_2382 enclosingSize;
    private long timeCreated;
    private long timeModified;
    protected int minecraftDataVersion;
    protected int schematicVersion;
    protected Schema schema;
    protected FileType type;
    private int regionCount;
    protected int entityCount;
    protected int blockEntityCount;
    private int totalVolume;
    private int totalBlocks;
    private boolean modifiedSinceSaved;
    @Nullable
    protected IntStream thumbnailPixelData;

    public SchematicMetadata() {
        this.name = "?";
        this.author = "?";
        this.description = "";
        this.enclosingSize = class_2382.field_11176;
        this.totalVolume = -1;
        this.totalBlocks = -1;
        this.thumbnailPixelData = null;
    }

    private SchematicMetadata(String name, String author, String desc, int regionCount, int volume, int blocks, long created, long modified, class_2382 size, @Nullable IntStream thumbnail) {
        this.name = name;
        this.author = author;
        this.description = desc;
        this.regionCount = regionCount;
        this.totalVolume = volume;
        this.totalBlocks = blocks;
        this.timeCreated = created;
        this.timeModified = modified;
        this.thumbnailPixelData = thumbnail;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public int[] getPreviewImagePixelData() {
        if (this.thumbnailPixelData == null) {
            return null;
        }
        int[] result = this.thumbnailPixelData.toArray();
        this.thumbnailPixelData = Arrays.stream((int[])result.clone());
        return result;
    }

    public int getRegionCount() {
        return this.regionCount;
    }

    public int getTotalVolume() {
        return this.totalVolume;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public int getBlockEntityCount() {
        return this.blockEntityCount;
    }

    public class_2382 getEnclosingSize() {
        return this.enclosingSize;
    }

    public class_2382 getEnclosingSizeAsVanilla() {
        return this.enclosingSize;
    }

    public class_2338 getEnclosingSizeAsBlockPos() {
        return new class_2338(this.enclosingSize);
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeModified() {
        return this.timeModified;
    }

    public int getSchematicVersion() {
        return this.schematicVersion;
    }

    public int getMinecraftDataVersion() {
        return this.minecraftDataVersion;
    }

    public SchematicSchema getSchematicSchema() {
        return new SchematicSchema(this.schematicVersion, this.minecraftDataVersion);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getMinecraftVersion() {
        return this.schema.getString();
    }

    public String getSchemaString() {
        return this.schema.toString();
    }

    public FileType getFileType() {
        return Objects.requireNonNullElse(this.type, FileType.UNKNOWN);
    }

    public boolean hasBeenModified() {
        return this.timeCreated != this.timeModified;
    }

    public boolean wasModifiedSinceSaved() {
        return this.modifiedSinceSaved;
    }

    public void setModifiedSinceSaved() {
        this.modifiedSinceSaved = true;
    }

    public void clearModifiedSinceSaved() {
        this.modifiedSinceSaved = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPreviewImagePixelData(@Nullable int[] pixelData) {
        this.thumbnailPixelData = pixelData == null ? null : IntStream.of(pixelData);
    }

    public void setRegionCount(int regionCount) {
        this.regionCount = regionCount;
    }

    public void setTotalVolume(int totalVolume) {
        this.totalVolume = totalVolume;
    }

    public void setTotalBlocks(int totalBlocks) {
        this.totalBlocks = totalBlocks;
    }

    public void setEnclosingSize(class_2382 enclosingSize) {
        this.enclosingSize = enclosingSize;
    }

    public void setEnclosingSize(class_2338 enclosingSize) {
        this.enclosingSize = enclosingSize;
    }

    public void setTimeCreated(long timeCreated) {
        this.timeCreated = timeCreated;
    }

    public void setTimeModified(long timeModified) {
        this.timeModified = timeModified;
    }

    public void setTimeModifiedToNow() {
        this.timeModified = System.currentTimeMillis();
    }

    public void setTimeModifiedToNowIfNotRecentlyCreated() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.timeCreated > 600000L) {
            this.timeModified = currentTime;
        }
    }

    public void setSchematicVersion(int version) {
        this.schematicVersion = version;
    }

    public void setMinecraftDataVersion(int minecraftDataVersion) {
        this.minecraftDataVersion = minecraftDataVersion;
        this.schema = Schema.getSchemaByDataVersion(this.minecraftDataVersion);
    }

    public void setSchema() {
        this.schema = Schema.getSchemaByDataVersion(this.minecraftDataVersion);
    }

    public void setFileType(FileType type) {
        this.type = type;
    }

    public void copyFrom(SchematicMetadata other) {
        this.name = other.name;
        this.author = other.author;
        this.description = other.description;
        this.enclosingSize = other.enclosingSize;
        this.timeCreated = other.timeCreated;
        this.timeModified = other.timeModified;
        this.regionCount = other.regionCount;
        this.totalVolume = other.totalVolume;
        this.totalBlocks = other.totalBlocks;
        this.modifiedSinceSaved = false;
        this.schematicVersion = other.schematicVersion;
        this.minecraftDataVersion = other.minecraftDataVersion;
        this.schema = Schema.getSchemaByDataVersion(other.minecraftDataVersion);
        this.type = other.getFileType();
        if (other.thumbnailPixelData != null) {
            int[] result = other.thumbnailPixelData.toArray();
            this.thumbnailPixelData = IntStream.of(result);
        } else {
            this.thumbnailPixelData = null;
        }
    }

    public class_2487 writeToNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("Name", this.name);
        nbt.method_10582("Author", this.author);
        nbt.method_10582("Description", this.description);
        if (this.regionCount > 0) {
            nbt.method_10569("RegionCount", this.regionCount);
        }
        if (this.totalVolume > 0) {
            nbt.method_10569("TotalVolume", this.totalVolume);
        }
        if (this.totalBlocks >= 0) {
            nbt.method_10569("TotalBlocks", this.totalBlocks);
        }
        if (this.timeCreated > 0L) {
            nbt.method_10544("TimeCreated", this.timeCreated);
        }
        if (this.timeModified > 0L) {
            nbt.method_10544("TimeModified", this.timeModified);
        }
        nbt.method_10566("EnclosingSize", (class_2520)SyncmaticaUtil.createVec3iTag(this.enclosingSize));
        if (this.thumbnailPixelData != null) {
            int[] result = this.thumbnailPixelData.toArray();
            if (result.length > 0) {
                nbt.method_10539("PreviewImageData", result);
                this.thumbnailPixelData = IntStream.of(result);
            } else {
                this.thumbnailPixelData = null;
            }
        }
        return nbt;
    }

    public void readFromNBT(class_2487 nbt) {
        class_2382 size;
        this.name = nbt.method_68564("Name", "?");
        this.author = nbt.method_68564("Author", "?");
        this.description = nbt.method_68564("Description", "");
        this.regionCount = nbt.method_68083("RegionCount", 0);
        this.timeCreated = nbt.method_68080("TimeCreated", -1L);
        this.timeModified = nbt.method_68080("TimeModified", -1L);
        if (nbt.method_10545("TotalVolume")) {
            this.totalVolume = nbt.method_68083("TotalVolume", 0);
        }
        if (nbt.method_10545("TotalBlocks")) {
            this.totalBlocks = nbt.method_68083("TotalBlocks", 0);
        }
        if (nbt.method_10545("EnclosingSize") && (size = SyncmaticaUtil.readVec3iFromTag(nbt.method_68568("EnclosingSize"))) != null) {
            this.enclosingSize = size;
        }
        this.thumbnailPixelData = nbt.method_10545("PreviewImageData") ? Arrays.stream(nbt.method_10561("PreviewImageData").orElse(new int[0])) : null;
    }

    public class_2487 writeToNbtExtra() {
        class_2487 nbt = this.writeToNBT();
        nbt.method_10582("FileType", this.type.name());
        if (this.minecraftDataVersion > 0) {
            nbt.method_10569("MinecraftDataVersion", this.minecraftDataVersion);
        }
        if (this.schematicVersion > 0) {
            nbt.method_10569("SchematicVersion", this.schematicVersion);
        }
        if (this.schema != null) {
            nbt.method_10582("Schema", this.schema.toString());
        }
        if (this.entityCount > 0) {
            nbt.method_10569("EntityCount", this.entityCount);
        }
        if (this.blockEntityCount > 0) {
            nbt.method_10569("BlockEntityCount", this.blockEntityCount);
        }
        nbt.method_10556("IsModified", this.modifiedSinceSaved);
        return nbt;
    }

    public String toString() {
        class_2487 nbt = this.writeToNbtExtra();
        if (nbt.method_10545("PreviewImageData")) {
            nbt.method_10551("PreviewImageData");
            nbt.method_10556("PreviewImageData", true);
        }
        return "SchematicMetadata[" + nbt.toString() + "]";
    }

    public void dumpMetadata() {
        System.out.print("SchematicMetadata() DUMP -->\n");
        System.out.printf("   %s\n", this.toString());
        System.out.print("<END>\n");
    }
}

