/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.network.actor;

import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.ClientCommunicationManager;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.data.RedirectFileStorage;
import ch.endte.syncmatica.data.SyncmaticManager;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.ScreenHelper;
import ch.endte.syncmatica.network.PacketType;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class ActorClientPlayHandler {
    private static ActorClientPlayHandler instance;
    private static class_634 clientPlayNetworkHandler;
    private CommunicationManager clientCommunication;
    private ExchangeTarget exTarget;

    public static ActorClientPlayHandler getInstance() {
        if (instance == null) {
            instance = new ActorClientPlayHandler();
        }
        return instance;
    }

    public void startEvent(class_634 handler) {
        Syncmatica.debug("ActorClientPlayHandler#startEvent()", new Object[0]);
        if (clientPlayNetworkHandler == null) {
            ActorClientPlayHandler.setClientContext(handler);
        }
        this.startClient();
    }

    public void startClient() {
        Syncmatica.debug("ActorClientPlayHandler#startClient()", new Object[0]);
        RedirectFileStorage data = new RedirectFileStorage();
        SyncmaticManager man = new SyncmaticManager();
        this.exTarget = new ExchangeTarget(clientPlayNetworkHandler);
        ClientCommunicationManager comms = new ClientCommunicationManager(this.exTarget);
        Syncmatica.initClient(comms, data, man);
        this.clientCommunication = comms;
        ScreenHelper.init();
        LitematicManager.getInstance().setActiveContext(Objects.requireNonNull(Syncmatica.getContext(Syncmatica.CLIENT_CONTEXT)));
    }

    public void packetEvent(PacketType type, class_2540 data, class_634 clientContext, CallbackInfo ci) {
        if (this.clientCommunication == null || this.exTarget.clientPlayNetworkHandler != clientContext) {
            Syncmatica.debug("ActorClientPlayHandler#packetEvent: re-init client context (communication null: %b, handler mismatch: %b)".formatted(this.clientCommunication == null, this.exTarget == null || this.exTarget.clientPlayNetworkHandler != clientContext), new Object[0]);
            this.reset();
            ActorClientPlayHandler.getInstance().startEvent(clientContext);
        }
        if (this.packetEvent(type, data) && ci.isCancellable()) {
            ci.cancel();
        }
    }

    public boolean packetEvent(PacketType type, class_2540 bufSupplier) {
        if (this.clientCommunication.handlePacket(type)) {
            this.clientCommunication.onPacket(this.exTarget, type, bufSupplier);
            return true;
        }
        return false;
    }

    public void reset() {
        Syncmatica.debug("ActorClientPlayHandler#reset()", new Object[0]);
        this.clientCommunication = null;
        this.exTarget = null;
        clientPlayNetworkHandler = null;
    }

    private static void setClientContext(class_634 clientHandler) {
        clientPlayNetworkHandler = clientHandler;
    }
}

