/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import com.mojang.serialization.DynamicOps;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.debug.IMixinClientPlayNetworkHandler;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.DebugRenderType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_11633;
import net.minecraft.class_11635;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class DebugDataManager {
    private static final DebugDataManager INSTANCE = new DebugDataManager();
    private final class_310 mc = class_310.method_1551();
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion = "";
    private boolean shouldRegisterDebugService;
    private List<DebugRenderType> enabledRenderers = new ArrayList<DebugRenderType>();

    public static DebugDataManager getInstance() {
        return INSTANCE;
    }

    public void onGameInit() {
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.debugLog("DebugDataManager#reset() - log-out", new Object[0]);
            this.servuxServer = false;
            this.hasInValidServux = false;
            this.servuxVersion = "";
        }
        this.onConfigSync();
    }

    public void onWorldPre() {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            // empty if block
        }
        this.onConfigSync();
    }

    public void onWorldJoin() {
        MiniHUD.debugLog("DebugDataManager#onWorldJoin()", new Object[0]);
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            if (RendererToggle.DEBUG_DATA_MAIN_TOGGLE.getBooleanValue()) {
                this.registerDebugService();
            } else {
                this.unregisterDebugService();
            }
        }
    }

    public boolean isF3Enabled() {
        return this.mc.field_61504.method_72776();
    }

    public boolean isDebugAlwaysEnabled(class_2960 type) {
        return this.mc.field_61504.method_72766(type) == class_11635.field_61593;
    }

    public boolean toggleDebugAlwaysEnabled(class_2960 type) {
        if (this.isDebugAlwaysEnabled(type)) {
            this.mc.field_61504.method_72767(type, class_11635.field_61595);
            return false;
        }
        this.mc.field_61504.method_72767(type, class_11635.field_61593);
        return true;
    }

    public boolean setDebugAlwaysEnabled(class_2960 type, boolean enabled) {
        if (!enabled) {
            this.mc.field_61504.method_72767(type, class_11635.field_61595);
            return false;
        }
        if (enabled) {
            this.mc.field_61504.method_72767(type, class_11635.field_61593);
            return true;
        }
        return this.isDebugAlwaysEnabled(type);
    }

    public boolean shouldShowDebugHudFix() {
        class_11633 profile = this.mc.field_61504;
        Collection list = profile.method_72771();
        return !(!profile.method_72776() && this.checkVisibleEntries(list) || this.mc.field_1690.field_1842 && this.mc.field_1755 == null);
    }

    private boolean checkVisibleEntries(Collection<class_2960> list) {
        if (list.isEmpty()) {
            return true;
        }
        block34: for (class_2960 entry : list) {
            switch (entry.method_12832()) {
                case "entity_hitboxes": {
                    continue block34;
                }
                case "chunk_borders": {
                    continue block34;
                }
                case "3d_crosshair": {
                    continue block34;
                }
                case "chunk_section_paths": {
                    continue block34;
                }
                case "chunk_section_octree": {
                    continue block34;
                }
                case "visualize_water_levels": {
                    continue block34;
                }
                case "visualize_heightmap": {
                    continue block34;
                }
                case "visualize_collision_boxes": {
                    continue block34;
                }
                case "visualize_entity_supporting_blocks": {
                    continue block34;
                }
                case "visualize_block_light_levels": {
                    continue block34;
                }
                case "visualize_sky_light_levels": {
                    continue block34;
                }
                case "visualize_solid_faces": {
                    continue block34;
                }
                case "visualize_chunks_on_server": {
                    continue block34;
                }
                case "visualize_sky_light_sections": {
                    continue block34;
                }
                case "chunk_section_visibility": {
                    continue block34;
                }
            }
            return false;
        }
        return true;
    }

    public List<DebugRenderType> getEnabledRenderers() {
        return this.enabledRenderers;
    }

    public boolean isDebugRendererEnabled(DebugRenderType type) {
        return this.enabledRenderers.contains((Object)type);
    }

    public void setDebugRenderer(DebugRenderType type, boolean toggle) {
        MiniHUD.debugLog("DebugDataManager#setDebugRenderer: type [{}] -> [{}]", type.getName(), toggle);
        type.toggleSharedConstant(toggle);
        if (toggle) {
            this.enabledRenderers.add(type);
        } else {
            this.enabledRenderers.remove((Object)type);
        }
    }

    public void toggleDebugRenderer(DebugRenderType type, boolean toggle) {
        this.setDebugRenderer(type, toggle);
        type.getCallback().setBooleanValue(toggle);
    }

    public boolean isDebugRenderingEnabled() {
        boolean result = this.enabledRenderers.contains((Object)DebugRenderType.DEBUG_ENABLED);
        boolean config = RendererToggle.DEBUG_DATA_MAIN_TOGGLE.getBooleanValue();
        if (config != result) {
            this.toggleDebugRendering(config);
            result = config;
        }
        return result;
    }

    public void toggleDebugRendering(boolean toggle) {
        this.setDebugRenderer(DebugRenderType.DEBUG_ENABLED, toggle);
        this.reloadDebugRenderer();
    }

    public void onConfigSync() {
        boolean changed = false;
        for (DebugRenderType entry : DebugRenderType.VALUES) {
            boolean enabled;
            boolean config = entry.getCallback().getBooleanValue();
            if (config == (enabled = this.isDebugRendererEnabled(entry))) continue;
            this.setDebugRenderer(entry, config);
            changed = true;
        }
        if (changed) {
            this.reloadDebugRenderer();
        }
    }

    public void reloadDebugRenderer() {
        if (this.mc.method_1562() != null) {
            ((IMixinClientPlayNetworkHandler)this.mc.method_1562()).minihud_getDebugManager().method_74712();
        }
        this.mc.field_1769.field_63067.method_74928();
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        if (this.hasInValidServux) {
            this.hasInValidServux = false;
        }
    }

    public void setServuxVersion(String ver) {
        this.servuxVersion = ver != null && !ver.isEmpty() ? ver : "unknown";
    }

    public String getServuxVersion() {
        if (this.hasServuxServer()) {
            return this.servuxVersion;
        }
        return "not_connected";
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public void registerDebugService() {
        this.shouldRegisterDebugService = true;
        if (this.hasServuxServer() || DataStorage.getInstance().hasIntegratedServer() || this.hasInValidServux) {
            this.shouldRegisterDebugService = false;
        }
    }

    public void requestMetadata() {
        if (!this.shouldRegisterDebugService || this.hasServuxServer() || DataStorage.getInstance().hasIntegratedServer() || !this.hasInValidServux) {
            // empty if block
        }
    }

    public void updateMetadata() {
        if (!this.shouldRegisterDebugService || !this.hasServuxServer() || DataStorage.getInstance().hasIntegratedServer() || !this.hasInValidServux) {
            // empty if block
        }
    }

    private class_2499 toNbtList() {
        class_2499 list = new class_2499();
        this.enabledRenderers.forEach(type -> list.add((Object)((class_2520)DebugRenderType.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)type).getOrThrow())));
        return list;
    }

    private void fromNbtList(@Nonnull class_2499 list) {
        if (list.isEmpty()) {
            return;
        }
        ArrayList<DebugRenderType> received = new ArrayList<DebugRenderType>();
        for (class_2520 entry : list) {
            try {
                DebugRenderType type = (DebugRenderType)((Object)DebugRenderType.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)entry).getOrThrow());
                if (type == null) continue;
                received.add(type);
                if (!this.isDebugRenderingEnabled()) {
                    this.toggleDebugRendering(true);
                }
                this.toggleDebugRenderer(type, true);
            }
            catch (Exception err) {
                MiniHUD.LOGGER.warn("debug_data#fromNbtList: Exception decoding Nbt List; {}", (Object)err.getLocalizedMessage());
            }
        }
    }

    private void resyncFromList(List<DebugRenderType> list) {
        ArrayList disable = new ArrayList();
        this.enabledRenderers.forEach(type -> {
            if (!list.contains(type)) {
                disable.add(type);
            }
        });
        for (DebugRenderType entry : disable) {
            this.toggleDebugRenderer(entry, false);
        }
    }

    public boolean receiveMetadata(class_2487 data) {
        if (!this.hasServuxServer() && !DataStorage.getInstance().hasIntegratedServer() && this.shouldRegisterDebugService) {
            MiniHUD.debugLog("DebugDataManager#receiveMetadata(): received METADATA from Servux", new Object[0]);
        }
        return false;
    }

    public void unregisterDebugService() {
        if (this.hasServuxServer() || !RendererToggle.DEBUG_DATA_MAIN_TOGGLE.getBooleanValue()) {
            this.servuxServer = false;
            if (!this.hasInValidServux) {
                MiniHUD.debugLog("DebugDataManager#unregisterDebugService(): for {}", this.servuxVersion != null ? this.servuxVersion : "<unknown>");
            }
        }
        this.shouldRegisterDebugService = false;
    }

    public void onPacketFailure() {
        this.shouldRegisterDebugService = false;
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    public boolean isEnabled() {
        return RendererToggle.DEBUG_DATA_MAIN_TOGGLE.getBooleanValue() && DataStorage.getInstance().hasIntegratedServer();
    }
}

