/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.chunk;

import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class InfoLineBlockChunkRegionBase
extends InfoLine {
    private static final String BLOCK_KEY = "minihud.info_line.block_pos";
    private static final String CHUNK_KEY = "minihud.info_line.chunk_pos";
    private static final String REGION_KEY = "minihud.info_line.region_file";

    public InfoLineBlockChunkRegionBase(InfoToggle type) {
        super(type);
    }

    @Override
    public boolean succeededType() {
        return this.succeeded;
    }

    @Override
    public List<InfoLine.Entry> parse(@NotNull InfoLineContext ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.pos() != null && ctx.chunkPos() != null) {
            ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
            String pre = "";
            StringBuilder str = new StringBuilder(256);
            if (InfoToggle.BLOCK_POS.getBooleanValue()) {
                try {
                    String fmt = Configs.Generic.BLOCK_POS_FORMAT_STRING.getStringValue();
                    str.append(String.format(fmt, ctx.pos().method_10263(), ctx.pos().method_10264(), ctx.pos().method_10260()));
                }
                catch (Exception e) {
                    str.append(StringUtils.translate((String)"minihud.info_line.block_pos.exception", (Object[])new Object[0]));
                }
                pre = " / ";
            }
            if (InfoToggle.CHUNK_POS.getBooleanValue()) {
                str.append(pre).append(this.qt(CHUNK_KEY, ctx.chunkPos().field_9181, ctx.pos().method_10264() >> 4, ctx.chunkPos().field_9180));
                pre = " / ";
            }
            if (InfoToggle.REGION_FILE.getBooleanValue()) {
                str.append(pre).append(this.qt(REGION_KEY, ctx.pos().method_10263() >> 9, ctx.pos().method_10260() >> 9));
            }
            list.add(this.of(str.toString()));
            this.succeeded = true;
            return list;
        }
        return null;
    }
}

