/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.class_10588;
import net.minecraft.class_10686;
import net.minecraft.class_10689;
import net.minecraft.class_10730;
import net.minecraft.class_10733;
import net.minecraft.class_10758;
import net.minecraft.class_12119;
import net.minecraft.class_12321;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1428;
import net.minecraft.class_1438;
import net.minecraft.class_1451;
import net.minecraft.class_1452;
import net.minecraft.class_1453;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1474;
import net.minecraft.class_1493;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_4019;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5762;
import net.minecraft.class_7102;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InfoLineEntityVariant
extends InfoLine {
    private static final String VARIANT_KEY = "minihud.info_line.entity_variant";

    public InfoLineEntityVariant(InfoToggle type) {
        super(type);
    }

    public InfoLineEntityVariant() {
        super(InfoToggle.ENTITY_VARIANT);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLineContext ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasLiving() && ctx.hasData()) {
            class_1299 entityType = DataEntityUtils.getEntityType((CompoundData)ctx.data());
            if (entityType == null) {
                return null;
            }
            return this.parseData(ctx.world(), entityType, ctx.data());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public List<InfoLine.Entry> parseData(@Nonnull class_1937 world, @Nonnull class_1299<?> entityType, @Nonnull CompoundData data) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (entityType.equals((Object)class_1299.field_28315)) {
            class_5762.class_5767 variant = DataEntityUtils.getAxolotlVariant((CompoundData)data);
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.axolotl", variant.method_33238()));
            }
        } else if (entityType.equals((Object)class_1299.field_16281)) {
            Pair catPair = DataEntityUtils.getCatVariant((CompoundData)data, (class_5455)world.method_30349());
            if (catPair.getLeft() != null) {
                list.add(this.translate("minihud.info_line.entity_variant.cat", ((class_5321)catPair.getLeft()).method_29177().method_12832(), ((class_1767)catPair.getRight()).method_7792()));
            }
        } else if (entityType.equals((Object)class_1299.field_6085)) {
            class_5321 variant = DataEntityUtils.getCowVariant((CompoundData)data, (class_5455)world.method_30349());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.cow", variant.method_29177().method_12832()));
            }
        } else if (entityType.equals((Object)class_1299.field_6132)) {
            class_5321 variant = DataEntityUtils.getChickenVariant((CompoundData)data, (class_5455)world.method_30349());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.chicken", variant.method_29177().method_12832()));
            }
        } else if (entityType.equals((Object)class_1299.field_6143)) {
            class_1438.class_4053 mooType = DataEntityUtils.getMooshroomVariant((CompoundData)data);
            if (mooType != null) {
                list.add(this.translate("minihud.info_line.entity_variant.mooshroom", mooType.method_15434()));
            }
        } else if (entityType.equals((Object)class_1299.field_17943)) {
            class_4019.class_4039 foxType = DataEntityUtils.getFoxVariant((CompoundData)data);
            if (foxType != null) {
                list.add(this.translate("minihud.info_line.entity_variant.fox", foxType.method_15434()));
            }
        } else if (entityType.equals((Object)class_1299.field_37419)) {
            class_5321 variant = DataEntityUtils.getFrogVariant((CompoundData)data, (class_5455)world.method_30349());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.frog", variant.method_29177().method_12832()));
            }
        } else if (entityType.equals((Object)class_1299.field_6139)) {
            Pair horsePair = DataEntityUtils.getHorseVariant((CompoundData)data);
            if (horsePair.getLeft() != null) {
                list.add(this.translate("minihud.info_line.entity_variant.horse", ((class_5149)horsePair.getLeft()).method_15434(), ((class_5148)horsePair.getRight()).name().toLowerCase()));
            }
        } else if (entityType.equals((Object)class_1299.field_6074) || entityType.equals((Object)class_1299.field_17714)) {
            Pair llamaPair = DataEntityUtils.getLlamaType((CompoundData)data);
            if (llamaPair.getLeft() != null) {
                list.add(this.translate("minihud.info_line.entity_variant.llama", ((class_1501.class_7993)llamaPair.getLeft()).method_15434(), llamaPair.getRight()));
            }
        } else if (entityType.equals((Object)class_1299.field_6120)) {
            Pair paintingPair = DataEntityUtils.getPaintingData((CompoundData)data, (class_5455)world.method_30349());
            if (paintingPair.getRight() != null) {
                Optional title = ((class_1535)paintingPair.getRight()).comp_2918();
                Optional author = ((class_1535)paintingPair.getRight()).comp_2919();
                if (title.isPresent() && author.isPresent()) {
                    list.add(this.translate("minihud.info_line.entity_variant.painting.both", ((class_2561)title.get()).getString(), ((class_2561)author.get()).getString()));
                } else if (title.isPresent()) {
                    list.add(this.translate("minihud.info_line.entity_variant.painting.title_only", ((class_2561)title.get()).getString()));
                } else {
                    author.ifPresent(text -> list.add(this.translate("minihud.info_line.entity_variant.painting.author_only", text.getString())));
                }
            }
        } else if (entityType.equals((Object)class_1299.field_6104)) {
            class_1453.class_7989 variant = DataEntityUtils.getParrotVariant((CompoundData)data);
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.parrot", variant.method_15434()));
            }
        } else if (entityType.equals((Object)class_1299.field_6093)) {
            class_5321 variant = DataEntityUtils.getPigVariant((CompoundData)data, (class_5455)world.method_30349());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.pig", variant.method_29177().method_12832()));
            }
        } else if (entityType.equals((Object)class_1299.field_6140)) {
            class_1463.class_7990 rabbitType = DataEntityUtils.getRabbitType((CompoundData)data);
            if (rabbitType != null) {
                list.add(this.translate("minihud.info_line.entity_variant.rabbit", rabbitType.method_15434()));
            }
        } else if (entityType.equals((Object)class_1299.field_6073)) {
            class_1462.class_9869 salmonVariant = DataEntityUtils.getSalmonVariant((CompoundData)data);
            if (salmonVariant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.salmon", salmonVariant.method_15434()));
            }
        } else if (entityType.equals((Object)class_1299.field_6115)) {
            class_1767 color = DataEntityUtils.getSheepColor((CompoundData)data);
            if (color != null) {
                list.add(this.translate("minihud.info_line.entity_variant.sheep", color.method_7792()));
            }
        } else if (entityType.equals((Object)class_1299.field_6111)) {
            class_1474.class_7992 variant = DataEntityUtils.getFishVariant((CompoundData)data);
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.tropical_fish", variant.comp_1177().method_15434(), variant.comp_1178().method_15434(), variant.comp_1179().method_15434()));
            }
        } else if (entityType.equals((Object)class_1299.field_63290)) {
            @NotNull class_5321 variant = DataEntityUtils.getZombieNautilusVariantFromNbt((CompoundData)data, (class_5455)world.method_30349());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.nautilus", variant.method_29177().method_12832()));
            }
        } else if (entityType.equals((Object)class_1299.field_6055)) {
            Pair wolfPair = DataEntityUtils.getWolfVariant((CompoundData)data, (class_5455)world.method_30349());
            class_5321 soundType = DataEntityUtils.getWolfSoundType((CompoundData)data, (class_5455)world.method_30349());
            if (wolfPair.getLeft() != null) {
                if (soundType != null) {
                    list.add(this.translate("minihud.info_line.entity_variant.wolf.sound_type", ((class_5321)wolfPair.getLeft()).method_29177().method_12832(), soundType.method_29177().method_12832(), ((class_1767)wolfPair.getRight()).method_7792()));
                } else {
                    list.add(this.translate("minihud.info_line.entity_variant.wolf", ((class_5321)wolfPair.getLeft()).method_29177().method_12832(), ((class_1767)wolfPair.getRight()).method_7792()));
                }
            }
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@Nonnull class_1937 world, @Nonnull class_1297 ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        class_1297 class_12972 = ent;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_5762.class, class_1451.class, class_1428.class, class_10730.class, class_1438.class, class_4019.class, class_7102.class, class_1498.class, class_1501.class, class_1534.class, class_1453.class, class_1452.class, class_1463.class, class_1462.class, class_1472.class, class_1474.class, class_12119.class, class_1493.class}, (Object)class_12973, n)) {
            case 0: {
                class_5762 axolotl = (class_5762)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.axolotl", axolotl.method_33225().method_33238()));
                break;
            }
            case 1: {
                class_1451 cat = (class_1451)class_12973;
                class_5321 variant = cat.method_47843().method_40230().orElse(class_10686.field_56260);
                list.add(this.translate("minihud.info_line.entity_variant.cat", variant.method_29177().method_12832(), cat.method_16096().method_7792()));
                break;
            }
            case 2: {
                class_1428 chicken = (class_1428)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.chicken", chicken.method_67522().method_40230().orElse(class_10758.field_56550).method_29177().method_12832()));
                break;
            }
            case 3: {
                class_10730 cow = (class_10730)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.cow", cow.method_67349().method_40230().orElse(class_10733.field_56438).method_29177().method_12832()));
                break;
            }
            case 4: {
                class_1438 mooshroom = (class_1438)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.mooshroom", mooshroom.method_47847().method_15434()));
                break;
            }
            case 5: {
                class_4019 fox = (class_4019)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.fox", fox.method_47845().method_15434()));
                break;
            }
            case 6: {
                class_7102 frog = (class_7102)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.frog", frog.method_41354().method_40230().orElse(class_10689.field_56278).method_29177().method_12832()));
                break;
            }
            case 7: {
                class_1498 horse = (class_1498)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.horse", horse.method_27077().method_15434(), horse.method_27078().name().toLowerCase()));
                break;
            }
            case 8: {
                class_1501 llama = (class_1501)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.llama", llama.method_6809().method_15434(), llama.method_6803()));
                break;
            }
            case 9: {
                class_1534 painting = (class_1534)class_12973;
                class_1535 paintingVariant = (class_1535)painting.method_43404().comp_349();
                if (paintingVariant == null) break;
                Optional title = paintingVariant.comp_2918();
                Optional author = paintingVariant.comp_2919();
                if (title.isPresent() && author.isPresent()) {
                    list.add(this.translate("minihud.info_line.entity_variant.painting.both", ((class_2561)title.get()).getString(), ((class_2561)author.get()).getString()));
                    break;
                }
                if (title.isPresent()) {
                    list.add(this.translate("minihud.info_line.entity_variant.painting.title_only", ((class_2561)title.get()).getString()));
                    break;
                }
                author.ifPresent(text -> list.add(this.translate("minihud.info_line.entity_variant.painting.author_only", text.getString())));
                break;
            }
            case 10: {
                class_1453 parrot = (class_1453)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.parrot", parrot.method_6584().method_15434()));
                break;
            }
            case 11: {
                class_1452 pig = (class_1452)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.pig", pig.method_66299().method_40230().orElse(class_10588.field_55699).method_29177().method_12832()));
                break;
            }
            case 12: {
                class_1463 rabbit = (class_1463)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.rabbit", rabbit.method_47855().method_15434()));
                break;
            }
            case 13: {
                class_1462 salmon = (class_1462)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.salmon", salmon.method_61472().method_15434()));
                break;
            }
            case 14: {
                class_1472 sheep = (class_1472)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.sheep", sheep.method_6633().method_7792()));
                break;
            }
            case 15: {
                class_1474 fish = (class_1474)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.tropical_fish", fish.method_66681().method_15434()));
                break;
            }
            case 16: {
                class_12119 nautilus = (class_12119)class_12973;
                list.add(this.translate("minihud.info_line.entity_variant.nautilus", nautilus.method_76453().method_40230().orElse(class_12321.field_64372).method_29177().method_12832()));
                break;
            }
            case 17: {
                class_1493 wolf = (class_1493)class_12973;
                Pair wolfPair = EntityUtils.getWolfVariantFromComponents((class_1493)wolf);
                class_5321 soundType = EntityUtils.getWolfSoundTypeFromComponents((class_1493)wolf);
                if (soundType != null) {
                    list.add(this.translate("minihud.info_line.entity_variant.wolf.sound_type", ((class_5321)wolfPair.getLeft()).method_29177().method_12832(), soundType.method_29177().method_12832(), ((class_1767)wolfPair.getRight()).method_7792()));
                    break;
                }
                list.add(this.translate("minihud.info_line.entity_variant.wolf", ((class_5321)wolfPair.getLeft()).method_29177().method_12832(), ((class_1767)wolfPair.getRight()).method_7792()));
                break;
            }
        }
        return list;
    }
}

