/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_638;
import net.minecraft.class_9801;

public class OverlayRendererSpawnableColumnHeights
extends OverlayRendererBase {
    public static final OverlayRendererSpawnableColumnHeights INSTANCE = new OverlayRendererSpawnableColumnHeights();
    private final Set<Long> DIRTY_CHUNKS = new HashSet<Long>();
    private final class_2338.class_2339 posMutable = new class_2338.class_2339();
    private long lastCheckTime;
    private final List<class_238> boxes = new ArrayList<class_238>();

    protected OverlayRendererSpawnableColumnHeights() {
        this.renderThrough = false;
        this.useCulling = false;
    }

    @Override
    public String getName() {
        return "SpawnableColumnHeights";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChunkChanged(int cx, int cz) {
        if (RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue()) {
            Set<Long> set = this.DIRTY_CHUNKS;
            synchronized (set) {
                this.DIRTY_CHUNKS.add(class_1923.method_8331((int)cx, (int)cz));
            }
        }
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        if (Math.abs(lx - ex) > 8 || Math.abs(lz - ez) > 8) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastCheckTime > 1000L) {
            int radius = class_3532.method_15340((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
            int xStart = (int)entity.method_23317() - radius >> 4;
            int zStart = (int)entity.method_23321() - radius >> 4;
            int xEnd = (int)entity.method_23317() + radius >> 4;
            int zEnd = (int)entity.method_23321() + radius >> 4;
            Set<Long> set = this.DIRTY_CHUNKS;
            synchronized (set) {
                for (int cx = xStart; cx <= xEnd; ++cx) {
                    for (int cz = zStart; cz <= zEnd; ++cz) {
                        if (!this.DIRTY_CHUNKS.contains(class_1923.method_8331((int)cx, (int)cz))) continue;
                        return true;
                    }
                }
            }
            this.lastCheckTime = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        this.calculateChunks(cameraPos, entity, mc);
        this.lastCheckTime = System.currentTimeMillis();
        Set<Long> set = this.DIRTY_CHUNKS;
        synchronized (set) {
            this.DIRTY_CHUNKS.clear();
        }
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
    }

    @Override
    public boolean hasData() {
        return !this.boxes.isEmpty();
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        Color4f color = Configs.Colors.SPAWNABLE_COLUMNS_OVERLAY_COLOR.getColor();
        profiler.method_15396("column_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:spawnable_column/quads", MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH);
        for (class_238 bb : this.boxes) {
            RenderUtils.drawBoxHorizontalSidesBatchedQuads((float)((float)bb.field_1323), (float)((float)bb.field_1322), (float)((float)bb.field_1321), (float)((float)bb.field_1320), (float)((float)bb.field_1325), (float)((float)bb.field_1324), (Color4f)color, (class_287)builder);
            RenderUtils.drawBoxTopBatchedQuads((float)((float)bb.field_1323), (float)((float)bb.field_1321), (float)((float)bb.field_1320), (float)((float)bb.field_1325), (float)((float)bb.field_1324), (Color4f)color, (class_287)builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSpawnableColumnHeights#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        Color4f color = Configs.Colors.SPAWNABLE_COLUMNS_OVERLAY_COLOR.getColor();
        profiler.method_15396("column_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:spawnable_column/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        for (class_238 bb : this.boxes) {
            RenderUtils.drawBoxAllEdgesBatchedLines((float)((float)bb.field_1323), (float)((float)bb.field_1322), (float)((float)bb.field_1321), (float)((float)bb.field_1320), (float)((float)bb.field_1325), (float)((float)bb.field_1324), (Color4f)color, (float)this.glLineWidth, (class_287)builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSpawnableColumnHeights#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void calculateChunks(class_243 cameraPos, class_1297 entity, class_310 mc) {
        if (mc.field_1687 == null) {
            return;
        }
        int radius = class_3532.method_15340((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
        int xStart = (int)entity.method_23317() - radius;
        int zStart = (int)entity.method_23321() - radius;
        int xEnd = (int)entity.method_23317() + radius;
        int zEnd = (int)entity.method_23321() + radius;
        class_638 world = mc.field_1687;
        this.boxes.clear();
        for (int x = xStart; x <= xEnd; ++x) {
            double minX = (double)x + 0.25 - cameraPos.field_1352;
            double maxX = minX + 0.5;
            for (int z = zStart; z <= zEnd; ++z) {
                int height = world.method_8500((class_2338)this.posMutable.method_10103(x, 0, z)).method_12005(class_2902.class_2903.field_13202, x, z) + 1;
                double minY = (double)height - cameraPos.field_1351;
                double maxY = minY + 0.09375;
                double minZ = (double)z + 0.25 - cameraPos.field_1350;
                double maxZ = minZ + 0.5;
                this.boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        this.boxes.clear();
        this.lastCheckTime = -1L;
        Set<Long> set = this.DIRTY_CHUNKS;
        synchronized (set) {
            this.DIRTY_CHUNKS.clear();
        }
    }
}

