/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.data.tag.util.DataOps;
import fi.dy.masa.malilib.util.data.tag.util.DataTypeUtils;
import fi.dy.masa.malilib.util.nbt.INbtEntityInvoker;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10586;
import net.minecraft.class_10588;
import net.minecraft.class_10630;
import net.minecraft.class_10686;
import net.minecraft.class_10689;
import net.minecraft.class_10731;
import net.minecraft.class_10733;
import net.minecraft.class_10756;
import net.minecraft.class_10758;
import net.minecraft.class_10823;
import net.minecraft.class_12319;
import net.minecraft.class_12321;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1438;
import net.minecraft.class_1440;
import net.minecraft.class_1453;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1474;
import net.minecraft.class_1501;
import net.minecraft.class_1535;
import net.minecraft.class_156;
import net.minecraft.class_1702;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1916;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3441;
import net.minecraft.class_3850;
import net.minecraft.class_4019;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5135;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5762;
import net.minecraft.class_5955;
import net.minecraft.class_6880;
import net.minecraft.class_7106;
import net.minecraft.class_7375;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9346;
import net.minecraft.class_9347;
import net.minecraft.class_9817;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class DataEntityUtils {
    public static CompoundData invokeEntityDataTagNoPassengers(class_1297 entity, int id) {
        return ((INbtEntityInvoker)entity).malilib$getDataTagWithId(id).orElseGet(CompoundData::new);
    }

    @Nullable
    public static class_1299<?> getEntityType(@Nonnull CompoundData data) {
        if (data.contains("id", 8)) {
            return class_7923.field_41177.method_17966(class_2960.method_12829((String)data.getString("id"))).orElse(null);
        }
        return null;
    }

    public CompoundData setEntityType(class_1299<?> type, @Nullable CompoundData dataIn) {
        CompoundData data = new CompoundData();
        class_2960 id = class_1299.method_5890(type);
        if (id != null) {
            if (dataIn != null) {
                dataIn.putString("id", id.toString());
                return dataIn;
            }
            data.putString("id", id.toString());
        }
        return data;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    class_6880.class_6883<@NotNull class_1299<?>> getEntityTypeEntry(class_2960 id, @Nonnull class_5455 registry) {
        try {
            return (class_6880.class_6883)registry.method_30530(class_7923.field_41177.method_46765()).method_10223(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static class_5131 getAttributes(@Nonnull CompoundData data) {
        class_1299<?> type = DataEntityUtils.getEntityType(data);
        if (type != null && data.contains("attributes", 9)) {
            class_5131 container = new class_5131(class_5135.method_26873(type));
            ListData list = data.getList("attributes");
            container.method_71381((List)class_1324.class_11345.field_60358.parse((DynamicOps)class_2509.field_11560, (Object)DataConverterNbt.toVanillaList(list)).getPartialOrThrow());
            return container;
        }
        return null;
    }

    public static double getAttributeBaseValue(@Nonnull CompoundData data, class_6880<class_1320> attribute) {
        class_5131 attributes = DataEntityUtils.getAttributes(data);
        if (attributes != null) {
            return attributes.method_26856(attribute);
        }
        return -1.0;
    }

    public static double getAttributeValue(@Nonnull CompoundData data, class_6880<@NotNull class_1320> attribute) {
        class_5131 attributes = DataEntityUtils.getAttributes(data);
        if (attributes != null) {
            return attributes.method_26852(attribute);
        }
        return -1.0;
    }

    public static Pair<Double, Double> getHealth(@Nonnull CompoundData data) {
        double maxHealth;
        double health = 0.0;
        if (data.contains("Health", 5)) {
            health = data.getFloat("Health");
        }
        if ((maxHealth = DataEntityUtils.getAttributeValue(data, (class_6880<class_1320>)class_5134.field_23716)) < 0.0) {
            maxHealth = 20.0;
        }
        return Pair.of((Object)health, (Object)maxHealth);
    }

    public static Pair<Double, Double> getSpeedAndJumpStrength(@Nonnull CompoundData data) {
        class_5131 container = DataEntityUtils.getAttributes(data);
        double moveSpeed = 0.0;
        double jumpStrength = 0.0;
        if (container != null) {
            moveSpeed = container.method_26852(class_5134.field_23719);
            jumpStrength = container.method_26852(class_5134.field_23728);
        }
        return Pair.of((Object)moveSpeed, (Object)jumpStrength);
    }

    @Nullable
    public static class_2561 getCustomName(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("CustomName", 10)) {
            return data.getCodec("CustomName", class_8824.field_46597, (DynamicOps<BaseData>)registry.method_57093((DynamicOps)DataOps.INSTANCE)).orElse(null);
        }
        return null;
    }

    public static CompoundData setCustomNameToDataTag(@Nonnull class_2561 name, @Nonnull class_5455 registry, @Nullable CompoundData dataIn, String key) {
        CompoundData data;
        CompoundData compoundData = data = dataIn != null ? dataIn.copy() : new CompoundData();
        if (key == null || key.isEmpty()) {
            key = "CustomName";
        }
        return data.putCodec(key, class_8824.field_46597, (DynamicOps<BaseData>)registry.method_57093((DynamicOps)DataOps.INSTANCE), name);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Map<class_6880<@NotNull class_1291>, class_1293> getActiveStatusEffects(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        @NotNull HashMap statusEffects = Maps.newHashMap();
        if (data.contains("active_effects", 9)) {
            List list = data.getCodec("active_effects", class_1293.field_48821.listOf(), (DynamicOps<BaseData>)registry.method_57093((DynamicOps)DataOps.INSTANCE)).orElse(List.of());
            for (class_1293 instance : list) {
                statusEffects.put(instance.method_5579(), instance);
            }
        }
        return statusEffects;
    }

    @Nullable
    public static class_10630 getEquipmentSlots(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("equipment", 10)) {
            CompoundData comp = data.getCompound("equipment");
            Optional opt = class_10630.field_55943.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(comp)).result();
            if (opt.isPresent()) {
                return (class_10630)opt.get();
            }
        }
        return null;
    }

    @Nullable
    public static BaseData setEquipmentSlotsToDataTag(@Nonnull class_10630 equipment, @Nonnull class_5455 registry) {
        try {
            return DataConverterNbt.fromVanillaNbt((class_2520)class_10630.field_55943.encodeStart((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)equipment).getOrThrow());
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("setEquipmentSlotsToNbt(): Failed to parse Equipment Slots Object; {}", (Object)err.getMessage());
            return null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static class_2371<@NotNull class_1799> getHandItems(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        @NotNull class_2371 list = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        class_10630 equipment = DataEntityUtils.getEquipmentSlots(data, registry);
        if (equipment != null) {
            class_1799 mainHand = equipment.method_66659(class_1304.field_6173);
            class_1799 offHand = equipment.method_66659(class_1304.field_6171);
            if (mainHand != null && !mainHand.method_7960()) {
                list.set(0, (Object)mainHand.method_7972());
            }
            if (offHand != null && !offHand.method_7960()) {
                list.set(1, (Object)offHand.method_7972());
            }
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static class_2371<@NotNull class_1799> getHumanoidArmor(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        @NotNull class_2371 list = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        class_10630 equipment = DataEntityUtils.getEquipmentSlots(data, registry);
        if (equipment != null) {
            class_1799 head = equipment.method_66659(class_1304.field_6169);
            class_1799 chest = equipment.method_66659(class_1304.field_6174);
            class_1799 legs = equipment.method_66659(class_1304.field_6172);
            class_1799 feet = equipment.method_66659(class_1304.field_6166);
            if (head != null && !head.method_7960()) {
                list.set(0, (Object)head.method_7972());
            }
            if (chest != null && !chest.method_7960()) {
                list.set(1, (Object)chest.method_7972());
            }
            if (legs != null && !legs.method_7960()) {
                list.set(2, (Object)legs.method_7972());
            }
            if (feet != null && !feet.method_7960()) {
                list.set(3, (Object)feet.method_7972());
            }
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static class_2371<@NotNull class_1799> getHorseEquipment(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        @NotNull class_2371 list = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        class_10630 equipment = DataEntityUtils.getEquipmentSlots(data, registry);
        if (equipment != null) {
            class_1799 bodyArmor = equipment.method_66659(class_1304.field_48824);
            class_1799 saddle = equipment.method_66659(class_1304.field_55946);
            if (bodyArmor != null && !bodyArmor.method_7960()) {
                list.set(0, (Object)bodyArmor.method_7972());
            }
            if (saddle != null && !saddle.method_7960()) {
                list.set(1, (Object)saddle.method_7972());
            }
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static class_2371<@NotNull class_1799> getAllEquipment(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        @NotNull class_2371 list = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
        class_10630 equipment = DataEntityUtils.getEquipmentSlots(data, registry);
        if (equipment != null) {
            class_1799 mainHand = equipment.method_66659(class_1304.field_6173);
            class_1799 offHand = equipment.method_66659(class_1304.field_6171);
            class_1799 head = equipment.method_66659(class_1304.field_6169);
            class_1799 chest = equipment.method_66659(class_1304.field_6174);
            class_1799 legs = equipment.method_66659(class_1304.field_6172);
            class_1799 feet = equipment.method_66659(class_1304.field_6166);
            class_1799 bodyArmor = equipment.method_66659(class_1304.field_48824);
            class_1799 saddle = equipment.method_66659(class_1304.field_55946);
            if (mainHand != null && !mainHand.method_7960()) {
                list.set(0, (Object)mainHand.method_7972());
            }
            if (offHand != null && !offHand.method_7960()) {
                list.set(1, (Object)offHand.method_7972());
            }
            if (head != null && !head.method_7960()) {
                list.set(2, (Object)head.method_7972());
            }
            if (chest != null && !chest.method_7960()) {
                list.set(3, (Object)chest.method_7972());
            }
            if (legs != null && !legs.method_7960()) {
                list.set(4, (Object)legs.method_7972());
            }
            if (feet != null && !feet.method_7960()) {
                list.set(5, (Object)feet.method_7972());
            }
            if (bodyArmor != null && !bodyArmor.method_7960()) {
                list.set(6, (Object)bodyArmor.method_7972());
            }
            if (saddle != null && !saddle.method_7960()) {
                list.set(7, (Object)saddle.method_7972());
            }
        }
        return list;
    }

    public static Pair<UUID, Boolean> getTamableOwner(@Nonnull CompoundData data) {
        UUID owner = class_156.field_25140;
        boolean sitting = false;
        if (data.contains("Owner", 11)) {
            owner = DataTypeUtils.getUUIDCodec(data, "Owner");
        }
        if (data.contains("Sitting", 1)) {
            sitting = data.getBoolean("Sitting");
        }
        return Pair.of((Object)owner, (Object)sitting);
    }

    public static Pair<Integer, Integer> getAge(@Nonnull CompoundData data) {
        int breedingAge = 0;
        int forcedAge = 0;
        if (data.contains("Age", 3)) {
            breedingAge = data.getInt("Age");
        }
        if (data.contains("ForcedAge", 3)) {
            forcedAge = data.getInt("ForcedAge");
        }
        return Pair.of((Object)breedingAge, (Object)forcedAge);
    }

    @Nullable
    public static class_1916 getTradeOffers(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.containsLenient("Offers")) {
            return data.getCodec("Offers", class_1916.field_48850, (DynamicOps<BaseData>)registry.method_57093((DynamicOps)DataOps.INSTANCE)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static class_3850 getVillagerData(@Nonnull CompoundData data) {
        if (data.contains("VillagerData", 10)) {
            return data.getCodec("VillagerData", class_3850.field_24669).orElse(null);
        }
        return null;
    }

    public static Pair<Integer, UUID> getZombieConversionTimer(@Nonnull CompoundData data) {
        int timer = -1;
        UUID player = class_156.field_25140;
        if (data.contains("ConversionTime", 3)) {
            timer = data.getInt("ConversionTime");
        }
        if (data.contains("ConversionPlayer", 11)) {
            player = DataTypeUtils.getUUIDCodec(data, "ConversionPlayer");
        }
        return Pair.of((Object)timer, (Object)player);
    }

    public static Pair<Integer, Integer> getDrownedConversionTimer(@Nonnull CompoundData data) {
        int drowning = -1;
        int inWater = -1;
        if (data.contains("DrownedConversionTime", 3)) {
            drowning = data.getInt("DrownedConversionTime");
        }
        if (data.contains("InWaterTime", 3)) {
            inWater = data.getInt("InWaterTime");
        }
        return Pair.of((Object)drowning, (Object)inWater);
    }

    public static int getStrayConversionTime(@Nonnull CompoundData data) {
        if (data.contains("StrayConversionTime", 3)) {
            return data.getInt("StrayConversionTime");
        }
        return -1;
    }

    @Nullable
    public static class_9817.class_9818 getLeashData(@Nonnull CompoundData data) {
        if (data.contains("leash", 10)) {
            return data.getCodec("leash", class_9817.class_9818.field_56648).orElse(null);
        }
        return null;
    }

    public static Pair<class_1440.class_1443, class_1440.class_1443> getPandaGenes(@Nonnull CompoundData data) {
        class_1440.class_1443 mainGene = null;
        class_1440.class_1443 hiddenGene = null;
        if (data.contains("MainGene", 8)) {
            mainGene = data.getCodec("MainGene", class_1440.class_1443.field_41673).orElse(class_1440.class_1443.field_6788);
        }
        if (data.contains("HiddenGene", 8)) {
            hiddenGene = data.getCodec("HiddenGene", class_1440.class_1443.field_41673).orElse(class_1440.class_1443.field_6788);
        }
        return Pair.of((Object)mainGene, hiddenGene);
    }

    public static Pair<class_2350, class_2350> getItemFrameDirections(@Nonnull CompoundData data) {
        class_2350 facing = DataTypeUtils.readDirectionFromTag(data, "Facing");
        class_2350 rotation = null;
        if (data.contains("ItemRotation", 1)) {
            rotation = class_2350.method_10143((int)data.getByte("ItemRotation"));
        }
        return Pair.of((Object)facing, rotation);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Pair<class_2350, class_1535> getPaintingData(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_2350 facing = DataTypeUtils.readDirectionFromTag(data, "facing");
        @NotNull class_6880 variant = null;
        if (data.contains("variant", 8)) {
            variant = class_1535.field_51597.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial().orElse(null);
        }
        return Pair.of((Object)facing, variant != null ? (class_1535)variant.comp_349() : null);
    }

    @Nullable
    public static class_5762.class_5767 getAxolotlVariant(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return data.getCodec("Variant", class_5762.class_5767.field_56659).orElse(class_5762.class_5767.field_28341);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Pair<class_5321<@NotNull class_7375>, class_1767> getCatVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        @NotNull class_5321 variantKey = null;
        class_1767 collar = null;
        if (data.contains("variant", 8)) {
            @NotNull Optional variant = class_7375.field_55959.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            variantKey = variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_10686.field_56260);
        }
        if (data.containsLenient("CollarColor")) {
            collar = data.getCodec("CollarColor", class_1767.field_56666).orElse(class_1767.field_7964);
        }
        if (variantKey == null) {
            variantKey = class_10686.field_56260;
        }
        if (collar == null) {
            collar = class_1767.field_7964;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_10756> getChickenVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("variant", 8)) {
            @NotNull Optional variant = class_10756.field_56540.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            return variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_10758.field_56550);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_10731> getCowVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("variant", 8)) {
            @NotNull Optional variant = class_10731.field_56427.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            return variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_10733.field_56438);
        }
        return null;
    }

    @Nullable
    public static class_1438.class_4053 getMooshroomVariant(@Nonnull CompoundData data) {
        if (data.contains("Type", 8)) {
            return data.getCodec("Type", class_1438.class_4053.field_41549).orElse(class_1438.class_4053.field_18109);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_7106> getFrogVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("variant", 8)) {
            @NotNull Optional variant = class_7106.field_55961.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            return variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_10689.field_56278);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_12319> getZombieNautilusVariantFromNbt(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("variant", 8)) {
            @NotNull Optional variant = class_12319.field_64363.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            return variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_12321.field_64372);
        }
        return null;
    }

    public static Pair<class_5149, class_5148> getHorseVariant(@Nonnull CompoundData data) {
        class_5149 color = null;
        class_5148 marking = null;
        if (data.contains("Variant", 3)) {
            int variant = data.getInt("Variant");
            color = class_5149.method_27083((int)(variant & 0xFF));
            marking = class_5148.method_27080((int)((variant & 0xFF00) >> 8));
        }
        return Pair.of(color, marking);
    }

    @Nullable
    public static class_1453.class_7989 getParrotVariant(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return data.getCodec("Variant", class_1453.class_7989.field_56653).orElse(class_1453.class_7989.field_41550);
        }
        return null;
    }

    @Nullable
    public static class_1474.class_7992 getFishVariant(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return data.getCodec("Variant", class_1474.class_7992.field_49236).orElse(class_1474.field_55968);
        }
        return null;
    }

    @Nullable
    public static class_1474.class_1475 getFishPattern(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return data.getCodec("Variant", class_1474.class_7992.field_49236).orElse(class_1474.field_55968).comp_1177();
        }
        if (data.contains("BucketVariantTag", 3)) {
            return class_1474.class_1475.method_47868((int)(data.getInt("BucketVariantTag") & 0xFFFF));
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Pair<class_5321<@NotNull class_9346>, class_1767> getWolfVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        @NotNull class_5321 variantKey = null;
        class_1767 collar = null;
        if (data.contains("variant", 8)) {
            @NotNull Optional variant = class_9346.field_49980.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            variantKey = variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_9347.field_51588);
        }
        if (data.containsLenient("CollarColor")) {
            collar = data.getCodec("CollarColor", class_1767.field_56666).orElse(class_1767.field_7964);
        }
        if (variantKey == null) {
            variantKey = class_9347.field_51588;
        }
        if (collar == null) {
            collar = class_1767.field_7964;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    @Nullable
    public static class_5321<@NotNull class_10823> getWolfSoundType(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_6880.class_6883 soundVariant;
        if (data.contains("sound_variant", 8) && (soundVariant = (class_6880.class_6883)registry.method_30530(class_7924.field_57110).method_10223(class_2960.method_12829((String)data.getString("sound_variant"))).orElse(null)) != null) {
            return soundVariant.method_40237();
        }
        return null;
    }

    @Nullable
    public static class_1767 getSheepColor(@Nonnull CompoundData data) {
        if (data.contains("Color", 3)) {
            return data.getCodec("Color", class_1767.field_56666).orElse(class_1767.field_7952);
        }
        return null;
    }

    @Nullable
    public static class_1463.class_7990 getRabbitType(@Nonnull CompoundData data) {
        if (data.contains("RabbitType", 3)) {
            return data.getCodec("RabbitType", class_1463.class_7990.field_56654).orElse(class_1463.class_7990.field_41561);
        }
        return null;
    }

    public static Pair<class_1501.class_7993, Integer> getLlamaType(@Nonnull CompoundData data) {
        class_1501.class_7993 variant = null;
        int strength = -1;
        if (data.contains("Variant", 3)) {
            variant = data.getCodec("Variant", class_1501.class_7993.field_56660).orElse(class_1501.class_7993.field_41586);
        }
        if (data.contains("Strength", 3)) {
            strength = data.getInt("Strength");
        }
        return Pair.of((Object)variant, (Object)strength);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_10586> getPigVariant(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        if (data.contains("variant", 8)) {
            try {
                @NotNull Optional opt = registry.method_30530(class_7924.field_55883).method_10223(Objects.requireNonNull(class_2960.method_12829((String)data.getString("variant"))));
                return opt.map(class_6880.class_6883::method_40237).orElse(class_10588.field_55699);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static class_4019.class_4039 getFoxVariant(@Nonnull CompoundData data) {
        if (data.contains("Type", 8)) {
            return data.getCodec("Type", class_4019.class_4039.field_41548).orElse(class_4019.class_4039.field_17996);
        }
        return null;
    }

    @Nullable
    public static class_1462.class_9869 getSalmonVariant(@Nonnull CompoundData data) {
        if (data.contains("type", 8)) {
            return data.getCodec("type", class_1462.class_9869.field_52473).orElse(class_1462.class_9869.field_52471);
        }
        return null;
    }

    public static Pair<Integer, Boolean> getDolphinData(@Nonnull CompoundData data) {
        boolean hasFish = false;
        int moist = -1;
        if (data.contains("Moistness", 3)) {
            moist = data.getInt("Moistness");
        }
        if (data.contains("GotFish", 1)) {
            hasFish = data.getBoolean("GotFish");
        }
        return Pair.of((Object)moist, (Object)hasFish);
    }

    public static Triple<Integer, Integer, Float> getPlayerExp(@Nonnull CompoundData data) {
        int level = -1;
        int total = -1;
        float progress = 0.0f;
        if (data.contains("XpLevel", 3)) {
            level = data.getInt("XpLevel");
        }
        if (data.contains("XpTotal", 3)) {
            total = data.getInt("XpTotal");
        }
        if (data.contains("XpP", 5)) {
            progress = data.getFloat("XpP");
        }
        return Triple.of((Object)level, (Object)total, (Object)Float.valueOf(progress));
    }

    @Nullable
    public static class_1702 getPlayerHunger(@Nonnull CompoundData data, @Nonnull class_5455 registry) {
        class_1702 hunger = null;
        if (data.containsLenient("foodLevel")) {
            hunger = new class_1702();
            NbtView view = NbtView.getReader(data, registry);
            hunger.method_7584(view.getReader());
        }
        return hunger;
    }

    @Nullable
    public static class_3441 getPlayerRecipeBook(@Nonnull CompoundData data, @Nonnull class_1863 manager) {
        class_3441 book = null;
        if (data.contains("recipeBook", 10)) {
            book = new class_3441((arg_0, arg_1) -> ((class_1863)manager).method_64679(arg_0, arg_1));
            class_2487 nbt = DataConverterNbt.toVanillaCompound(data.getCompoundOrDefault("recipeBook", new CompoundData()));
            book.method_71343((class_3441.class_11328)class_3441.class_11328.field_60346.parse((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow(), key -> manager.method_8130(key).isPresent());
        }
        return book;
    }

    public static Pair<class_2338, Integer> getHomePos(@Nonnull CompoundData data) {
        class_2338 pos = class_2338.field_10980;
        int radius = -1;
        if (data.containsLenient("home_pos")) {
            pos = data.getCodec("home_pos", class_2338.field_25064).orElse(class_2338.field_10980);
        }
        if (data.contains("home_radius", 3)) {
            radius = data.getInt("home_radius");
        }
        return Pair.of((Object)pos, (Object)radius);
    }

    public static Pair<class_5955.class_5811, Long> getWeatheringData(@Nonnull CompoundData data) {
        class_5955.class_5811 level = class_5955.class_5811.field_28704;
        long age = -1L;
        if (data.contains("weather_state", 8)) {
            level = data.getCodec("weather_state", class_5955.class_5811.field_46493).orElse(class_5955.class_5811.field_28704);
        }
        if (data.contains("next_weather_age", 4)) {
            age = data.getLong("next_weather_age");
        }
        return Pair.of((Object)level, (Object)age);
    }
}

