/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.time;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.time.DurationFmtType;
import fi.dy.masa.malilib.util.time.formatter.DurationFmt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public enum DurationFormat implements IConfigOptionListEntry,
class_3542
{
    REGULAR("regular", DurationFmtType.REGULAR, "malilib.gui.label.duration_format.regular"),
    PRETTY("pretty", DurationFmtType.PRETTY, "malilib.gui.label.duration_format.pretty"),
    ISO_EXTENDED("iso_extended", DurationFmtType.ISO_EXTENDED, "malilib.gui.label.duration_format.iso_extended"),
    FORMATTED("formatted", DurationFmtType.FORMATTED, "malilib.gui.label.duration_format.formatted");

    public static final // Could not load outer class - annotation placement on inner may be incorrect
    class_3542.class_7292<@NotNull DurationFormat> CODEC;
    public static final ImmutableList<@NotNull DurationFormat> VALUES;
    private final String configString;
    private final DurationFmtType<?> type;
    private final String translationKey;

    private DurationFormat(String name, DurationFmtType<?> type, String translationKey) {
        this.configString = name;
        this.type = type;
        this.translationKey = translationKey;
    }

    @Nonnull
    public String method_15434() {
        return this.configString;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    public DurationFmtType<?> getType() {
        return this.type;
    }

    @Nullable
    private DurationFmt init() {
        return this.type.init(this);
    }

    public String format(long duration) {
        return this.format(duration, null);
    }

    public String format(long duration, @Nullable String fmt) {
        DurationFmt formatter = this.init();
        if (formatter != null) {
            if (duration < 1L) {
                return StringUtils.translate("malilib.gui.label.duration_format.error.invalid", duration);
            }
            return formatter.format(duration, fmt);
        }
        return "";
    }

    public String getFormatString() {
        DurationFmt formatter = this.init();
        if (formatter != null) {
            return formatter.getFormatString();
        }
        return "";
    }

    @Override
    @Nullable
    public DurationFormat fromString(String value) {
        return DurationFormat.fromStringStatic(value);
    }

    public static DurationFormat fromStringStatic(String value) {
        for (DurationFormat val : VALUES) {
            if (value.compareToIgnoreCase(val.getStringValue()) != 0) continue;
            return val;
        }
        return null;
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= DurationFormat.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = DurationFormat.values().length - 1;
        }
        return DurationFormat.values()[id % DurationFormat.values().length];
    }

    public String toString() {
        return this.getStringValue();
    }

    static {
        CODEC = class_3542.method_28140(DurationFormat::values);
        VALUES = ImmutableList.copyOf((Object[])DurationFormat.values());
    }
}

