/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.config;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thecsdev.common.util.ReflectionUtils;
import com.thecsdev.common.util.TUtils;
import com.thecsdev.common.util.annotations.Virtual;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonConfig {
    protected static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
    @Nullable
    protected volatile transient File configFile;
    private static final Map<Field, String[]> PROPERTY_NAME_CACHE = new ConcurrentHashMap<Field, String[]>();

    public JsonConfig() {
        this(null);
    }

    public JsonConfig(@Nullable File configFile) {
        this.configFile = configFile;
    }

    @Virtual
    @Nullable
    protected File getConfigFile() {
        return this.configFile;
    }

    @Virtual
    protected void setConfigFile(@Nullable File file) {
        this.configFile = file;
    }

    @Virtual
    protected void onSave(JsonObject to) {
    }

    @Virtual
    protected void onLoad(JsonObject from) {
    }

    @NotNull
    public final JsonObject saveToJson() {
        JsonObject json = new JsonObject();
        this.saveToJson(json);
        return json;
    }

    public final void saveToJson(JsonObject json) throws NullPointerException {
        Objects.requireNonNull(json);
        JsonConfig.getSerializableProperties(this.getClass()).forEach(property -> TUtils.uncheckedCall(() -> {
            JsonElement jsonElement;
            property.setAccessible(true);
            @Nullable Object pValue = property.get(this);
            if (pValue == null) {
                return;
            }
            String pName = JsonConfig.getPropertyNames(property)[0];
            if (pValue instanceof JsonConfig) {
                JsonConfig jc = (JsonConfig)pValue;
                jsonElement = jc.saveToJson();
            } else {
                jsonElement = GSON.toJsonTree(pValue);
            }
            json.add(pName, jsonElement);
        }));
    }

    public final void loadFromJson(JsonObject json) {
        Objects.requireNonNull(json);
        JsonConfig.getDeserializableProperties(this.getClass()).forEach(property -> TUtils.uncheckedCall(() -> {
            property.setAccessible(true);
            String[] pNames = JsonConfig.getPropertyNames(property);
            JsonElement pjElement = null;
            for (String pName : pNames) {
                if (!json.has(pName)) continue;
                pjElement = json.get(pName);
                break;
            }
            if (pjElement == null || pjElement.isJsonNull()) {
                return;
            }
            Class<?> pType = property.getType();
            if (JsonConfig.class.isAssignableFrom(pType)) {
                JsonConfig jc;
                JsonConfig cfg;
                JsonObject obj;
                Object pValue = property.get(this);
                JsonObject jsonObject = obj = pjElement.isJsonObject() ? pjElement.getAsJsonObject() : null;
                if (obj == null) {
                    return;
                }
                JsonConfig jsonConfig = cfg = pValue instanceof JsonConfig ? (jc = (JsonConfig)pValue) : (JsonConfig)ReflectionUtils.createClassInstance(pType, new Object[0]);
                if (cfg == null) {
                    return;
                }
                cfg.loadFromJson(obj);
                property.set(this, cfg);
                return;
            }
            Object pValue = null;
            try {
                pValue = GSON.fromJson(pjElement, pType);
            }
            catch (JsonSyntaxException ignored) {
                return;
            }
            property.set(this, pValue);
        }));
    }

    public final void saveToFile() throws NullPointerException, IOException {
        File file = Objects.requireNonNull(this.getConfigFile());
        Optional.ofNullable(file.getParentFile()).ifPresent(File::mkdirs);
        Files.writeString(file.toPath(), (CharSequence)GSON.toJson((JsonElement)this.saveToJson()), new OpenOption[0]);
    }

    public final void loadFromFile() throws NullPointerException, IOException {
        File file = Objects.requireNonNull(this.getConfigFile());
        if (!file.exists()) {
            return;
        }
        try {
            this.loadFromJson((JsonObject)GSON.fromJson(Files.readString(file.toPath()), JsonObject.class));
        }
        catch (Exception e) {
            throw new IOException("Failed to load JSON config file: " + String.valueOf(file), e);
        }
    }

    public static final Stream<Field> getProperties(Class<? extends JsonConfig> clazz) throws NullPointerException {
        return Arrays.stream(ReflectionUtils.getAllDeclaredFields(clazz)).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).filter(f -> !f.getType().isArray()).filter(f -> f.getType().isPrimitive() || Serializable.class.isAssignableFrom(f.getType()) || JsonConfig.class.isAssignableFrom(f.getType())).filter(f -> f.isAnnotationPresent(Expose.class));
    }

    public static final Stream<Field> getSerializableProperties(Class<? extends JsonConfig> clazz) throws NullPointerException {
        return JsonConfig.getProperties(clazz).filter(f -> f.getAnnotation(Expose.class).serialize());
    }

    public static final Stream<Field> getDeserializableProperties(Class<? extends JsonConfig> clazz) throws NullPointerException {
        return JsonConfig.getProperties(clazz).filter(f -> f.getAnnotation(Expose.class).deserialize());
    }

    public static String[] getPropertyNames(Field property) throws NullPointerException {
        Objects.requireNonNull(property);
        return PROPERTY_NAME_CACHE.computeIfAbsent(property, f -> {
            SerializedName sn = f.getAnnotation(SerializedName.class);
            if (sn != null) {
                return (String[])Streams.concat((Stream[])new Stream[]{Stream.of(sn.value()), Arrays.stream(sn.alternate())}).toArray(String[]::new);
            }
            return new String[]{f.getName()};
        });
    }
}

