/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.io.buffer;

import com.thecsdev.common.util.annotations.Virtual;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Virtual
public class TByteBuf
extends ByteBuf {
    @NotNull
    private final ByteBuf target;

    public TByteBuf(@NotNull ByteBuf target) {
        this.target = Objects.requireNonNull(target);
    }

    @NotNull
    public ByteBuf getTarget() {
        return this.target;
    }

    public final String toString() {
        return String.format("%s[%s]", new Object[]{this, this.target});
    }

    public final int hashCode() {
        return this.target.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return this.target.equals((Object)((TByteBuf)((Object)obj)).target);
    }

    public final int capacity() {
        return this.target.capacity();
    }

    public final ByteBuf capacity(int newCapacity) {
        return this.target.capacity(newCapacity);
    }

    public final int maxCapacity() {
        return this.target.maxCapacity();
    }

    public final ByteBufAllocator alloc() {
        return this.target.alloc();
    }

    public final ByteOrder order() {
        return this.target.order();
    }

    public final ByteBuf order(ByteOrder endianness) {
        return this.target.order(endianness);
    }

    public final ByteBuf unwrap() {
        return this.target.unwrap();
    }

    public final boolean isDirect() {
        return this.target.isDirect();
    }

    public final boolean isReadOnly() {
        return this.target.isReadOnly();
    }

    public final ByteBuf asReadOnly() {
        return this.target.asReadOnly();
    }

    public final int readerIndex() {
        return this.target.readerIndex();
    }

    public final ByteBuf readerIndex(int readerIndex) {
        return this.target.readerIndex(readerIndex);
    }

    public final int writerIndex() {
        return this.target.writerIndex();
    }

    public final ByteBuf writerIndex(int writerIndex) {
        return this.target.writerIndex(writerIndex);
    }

    public final ByteBuf setIndex(int readerIndex, int writerIndex) {
        return this.target.setIndex(readerIndex, writerIndex);
    }

    public final int readableBytes() {
        return this.target.readableBytes();
    }

    public final int writableBytes() {
        return this.target.writableBytes();
    }

    public final int maxWritableBytes() {
        return this.target.maxWritableBytes();
    }

    public final boolean isReadable() {
        return this.target.isReadable();
    }

    public final boolean isReadable(int size) {
        return this.target.isReadable(size);
    }

    public final boolean isWritable() {
        return this.target.isWritable();
    }

    public final boolean isWritable(int size) {
        return this.target.isWritable(size);
    }

    public final ByteBuf clear() {
        return this.target.clear();
    }

    public final ByteBuf markReaderIndex() {
        return this.target.markReaderIndex();
    }

    public final ByteBuf resetReaderIndex() {
        return this.target.resetReaderIndex();
    }

    public final ByteBuf markWriterIndex() {
        return this.target.markWriterIndex();
    }

    public final ByteBuf resetWriterIndex() {
        return this.target.resetWriterIndex();
    }

    public final ByteBuf discardReadBytes() {
        return this.target.discardReadBytes();
    }

    public final ByteBuf discardSomeReadBytes() {
        return this.target.discardSomeReadBytes();
    }

    public final ByteBuf ensureWritable(int minWritableBytes) {
        return this.target.ensureWritable(minWritableBytes);
    }

    public final int ensureWritable(int minWritableBytes, boolean force) {
        return this.target.ensureWritable(minWritableBytes, force);
    }

    public final boolean getBoolean(int index) {
        return this.target.getBoolean(index);
    }

    public final byte getByte(int index) {
        return this.target.getByte(index);
    }

    public final short getUnsignedByte(int index) {
        return this.target.getUnsignedByte(index);
    }

    public final short getShort(int index) {
        return this.target.getShort(index);
    }

    public final short getShortLE(int index) {
        return this.target.getShortLE(index);
    }

    public final int getUnsignedShort(int index) {
        return this.target.getUnsignedShort(index);
    }

    public final int getUnsignedShortLE(int index) {
        return this.target.getUnsignedShortLE(index);
    }

    public final int getMedium(int index) {
        return this.target.getMedium(index);
    }

    public final int getMediumLE(int index) {
        return this.target.getMediumLE(index);
    }

    public final int getUnsignedMedium(int index) {
        return this.target.getUnsignedMedium(index);
    }

    public final int getUnsignedMediumLE(int index) {
        return this.target.getUnsignedMediumLE(index);
    }

    public final int getInt(int index) {
        return this.target.getInt(index);
    }

    public final int getIntLE(int index) {
        return this.target.getIntLE(index);
    }

    public final long getUnsignedInt(int index) {
        return this.target.getUnsignedInt(index);
    }

    public final long getUnsignedIntLE(int index) {
        return this.target.getUnsignedIntLE(index);
    }

    public final long getLong(int index) {
        return this.target.getLong(index);
    }

    public final long getLongLE(int index) {
        return this.target.getLongLE(index);
    }

    public final char getChar(int index) {
        return this.target.getChar(index);
    }

    public final float getFloat(int index) {
        return this.target.getFloat(index);
    }

    public final double getDouble(int index) {
        return this.target.getDouble(index);
    }

    public final ByteBuf getBytes(int index, ByteBuf dst) {
        return this.target.getBytes(index, dst);
    }

    public final ByteBuf getBytes(int index, ByteBuf dst, int length) {
        return this.target.getBytes(index, dst, length);
    }

    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        return this.target.getBytes(index, dst, dstIndex, length);
    }

    public final ByteBuf getBytes(int index, byte[] dst) {
        return this.target.getBytes(index, dst);
    }

    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        return this.target.getBytes(index, dst, dstIndex, length);
    }

    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        return this.target.getBytes(index, dst);
    }

    public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        return this.target.getBytes(index, out, length);
    }

    public final int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.target.getBytes(index, out, length);
    }

    public final int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        return this.target.getBytes(index, out, position, length);
    }

    public final CharSequence getCharSequence(int index, int length, Charset charset) {
        return this.target.getCharSequence(index, length, charset);
    }

    public final ByteBuf setBoolean(int index, boolean value) {
        return this.target.setBoolean(index, value);
    }

    public final ByteBuf setByte(int index, int value) {
        return this.target.setByte(index, value);
    }

    public final ByteBuf setShort(int index, int value) {
        return this.target.setShort(index, value);
    }

    public final ByteBuf setShortLE(int index, int value) {
        return this.target.setShortLE(index, value);
    }

    public final ByteBuf setMedium(int index, int value) {
        return this.target.setMedium(index, value);
    }

    public final ByteBuf setMediumLE(int index, int value) {
        return this.target.setMediumLE(index, value);
    }

    public final ByteBuf setInt(int index, int value) {
        return this.target.setInt(index, value);
    }

    public final ByteBuf setIntLE(int index, int value) {
        return this.target.setIntLE(index, value);
    }

    public final ByteBuf setLong(int index, long value) {
        return this.target.setLong(index, value);
    }

    public final ByteBuf setLongLE(int index, long value) {
        return this.target.setLongLE(index, value);
    }

    public final ByteBuf setChar(int index, int value) {
        return this.target.setChar(index, value);
    }

    public final ByteBuf setFloat(int index, float value) {
        return this.target.setFloat(index, value);
    }

    public final ByteBuf setDouble(int index, double value) {
        return this.target.setDouble(index, value);
    }

    public final ByteBuf setBytes(int index, ByteBuf src) {
        return this.target.setBytes(index, src);
    }

    public final ByteBuf setBytes(int index, ByteBuf src, int length) {
        return this.target.setBytes(index, src, length);
    }

    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        return this.target.setBytes(index, src, srcIndex, length);
    }

    public final ByteBuf setBytes(int index, byte[] src) {
        return this.target.setBytes(index, src);
    }

    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        return this.target.setBytes(index, src, srcIndex, length);
    }

    public final ByteBuf setBytes(int index, ByteBuffer src) {
        return this.target.setBytes(index, src);
    }

    public final int setBytes(int index, InputStream in, int length) throws IOException {
        return this.target.setBytes(index, in, length);
    }

    public final int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.target.setBytes(index, in, length);
    }

    public final int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        return this.target.setBytes(index, in, position, length);
    }

    public final ByteBuf setZero(int index, int length) {
        return this.target.setZero(index, length);
    }

    public final int setCharSequence(int index, CharSequence sequence, Charset charset) {
        return this.target.setCharSequence(index, sequence, charset);
    }

    public final boolean readBoolean() {
        return this.target.readBoolean();
    }

    public final byte readByte() {
        return this.target.readByte();
    }

    public final short readUnsignedByte() {
        return this.target.readUnsignedByte();
    }

    public final short readShort() {
        return this.target.readShort();
    }

    public final short readShortLE() {
        return this.target.readShortLE();
    }

    public final int readUnsignedShort() {
        return this.target.readUnsignedShort();
    }

    public final int readUnsignedShortLE() {
        return this.target.readUnsignedShortLE();
    }

    public final int readMedium() {
        return this.target.readMedium();
    }

    public final int readMediumLE() {
        return this.target.readMediumLE();
    }

    public final int readUnsignedMedium() {
        return this.target.readUnsignedMedium();
    }

    public final int readUnsignedMediumLE() {
        return this.target.readUnsignedMediumLE();
    }

    public final int readInt() {
        return this.target.readInt();
    }

    public final int readIntLE() {
        return this.target.readIntLE();
    }

    public final long readUnsignedInt() {
        return this.target.readUnsignedInt();
    }

    public final long readUnsignedIntLE() {
        return this.target.readUnsignedIntLE();
    }

    public final long readLong() {
        return this.target.readLong();
    }

    public final long readLongLE() {
        return this.target.readLongLE();
    }

    public final char readChar() {
        return this.target.readChar();
    }

    public final float readFloat() {
        return this.target.readFloat();
    }

    public final double readDouble() {
        return this.target.readDouble();
    }

    public final ByteBuf readBytes(int length) {
        return this.target.readBytes(length);
    }

    public final ByteBuf readSlice(int length) {
        return this.target.readSlice(length);
    }

    public final ByteBuf readRetainedSlice(int length) {
        return this.target.readRetainedSlice(length);
    }

    public final ByteBuf readBytes(ByteBuf dst) {
        return this.target.readBytes(dst);
    }

    public final ByteBuf readBytes(ByteBuf dst, int length) {
        return this.target.readBytes(dst, length);
    }

    public final ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        return this.target.readBytes(dst, dstIndex, length);
    }

    public final ByteBuf readBytes(byte[] dst) {
        return this.target.readBytes(dst);
    }

    public final ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        return this.target.readBytes(dst, dstIndex, length);
    }

    public final ByteBuf readBytes(ByteBuffer dst) {
        return this.target.readBytes(dst);
    }

    public final ByteBuf readBytes(OutputStream out, int length) throws IOException {
        return this.target.readBytes(out, length);
    }

    public final int readBytes(GatheringByteChannel out, int length) throws IOException {
        return this.target.readBytes(out, length);
    }

    public final CharSequence readCharSequence(int length, Charset charset) {
        return this.target.readCharSequence(length, charset);
    }

    public final int readBytes(FileChannel out, long position, int length) throws IOException {
        return this.target.readBytes(out, position, length);
    }

    public final TByteBuf skipBytes(int length) {
        this.target.skipBytes(length);
        return this;
    }

    public final TByteBuf writeBoolean(boolean value) {
        this.target.writeBoolean(value);
        return this;
    }

    public final TByteBuf writeByte(int value) {
        this.target.writeByte(value);
        return this;
    }

    public final TByteBuf writeShort(int value) {
        this.target.writeShort(value);
        return this;
    }

    public final TByteBuf writeShortLE(int value) {
        this.target.writeShortLE(value);
        return this;
    }

    public final TByteBuf writeMedium(int value) {
        this.target.writeMedium(value);
        return this;
    }

    public final TByteBuf writeMediumLE(int value) {
        this.target.writeMediumLE(value);
        return this;
    }

    public final TByteBuf writeInt(int value) {
        this.target.writeInt(value);
        return this;
    }

    public final TByteBuf writeIntLE(int value) {
        this.target.writeIntLE(value);
        return this;
    }

    public final TByteBuf writeLong(long value) {
        this.target.writeLong(value);
        return this;
    }

    public final TByteBuf writeLongLE(long value) {
        this.target.writeLongLE(value);
        return this;
    }

    public final TByteBuf writeChar(int value) {
        this.target.writeChar(value);
        return this;
    }

    public final TByteBuf writeFloat(float value) {
        this.target.writeFloat(value);
        return this;
    }

    public final TByteBuf writeDouble(double value) {
        this.target.writeDouble(value);
        return this;
    }

    public final TByteBuf writeBytes(ByteBuf src) {
        this.target.writeBytes(src);
        return this;
    }

    public final TByteBuf writeBytes(ByteBuf src, int length) {
        this.target.writeBytes(src, length);
        return this;
    }

    public final TByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.target.writeBytes(src, srcIndex, length);
        return this;
    }

    public final TByteBuf writeBytes(byte[] src) {
        this.target.writeBytes(src);
        return this;
    }

    public final TByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.target.writeBytes(src, srcIndex, length);
        return this;
    }

    public final TByteBuf writeBytes(ByteBuffer src) {
        this.target.writeBytes(src);
        return this;
    }

    public final int writeBytes(InputStream in, int length) throws IOException {
        return this.target.writeBytes(in, length);
    }

    public final int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this.target.writeBytes(in, length);
    }

    public final int writeBytes(FileChannel in, long position, int length) throws IOException {
        return this.target.writeBytes(in, position, length);
    }

    public final TByteBuf writeZero(int length) {
        this.target.writeZero(length);
        return this;
    }

    public final int writeCharSequence(CharSequence sequence, Charset charset) {
        return this.target.writeCharSequence(sequence, charset);
    }

    public final int indexOf(int fromIndex, int toIndex, byte value) {
        return this.target.indexOf(fromIndex, toIndex, value);
    }

    public final int bytesBefore(byte value) {
        return this.target.bytesBefore(value);
    }

    public final int bytesBefore(int length, byte value) {
        return this.target.bytesBefore(length, value);
    }

    public final int bytesBefore(int index, int length, byte value) {
        return this.target.bytesBefore(index, length, value);
    }

    public final int forEachByte(ByteProcessor processor) {
        return this.target.forEachByte(processor);
    }

    public final int forEachByte(int index, int length, ByteProcessor processor) {
        return this.target.forEachByte(index, length, processor);
    }

    public final int forEachByteDesc(ByteProcessor processor) {
        return this.target.forEachByteDesc(processor);
    }

    public final int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return this.target.forEachByteDesc(index, length, processor);
    }

    public final TByteBuf copy() {
        return new TByteBuf(this.target.copy());
    }

    public final TByteBuf copy(int index, int length) {
        return new TByteBuf(this.target.copy(index, length));
    }

    public final ByteBuf slice() {
        return this.target.slice();
    }

    public final ByteBuf retainedSlice() {
        return this.target.retainedSlice();
    }

    public final ByteBuf slice(int index, int length) {
        return this.target.slice(index, length);
    }

    public final ByteBuf retainedSlice(int index, int length) {
        return this.target.retainedSlice(index, length);
    }

    public final ByteBuf duplicate() {
        return this.target.duplicate();
    }

    public final ByteBuf retainedDuplicate() {
        return this.target.retainedDuplicate();
    }

    public final int nioBufferCount() {
        return this.target.nioBufferCount();
    }

    public final ByteBuffer nioBuffer() {
        return this.target.nioBuffer();
    }

    public final ByteBuffer nioBuffer(int index, int length) {
        return this.target.nioBuffer(index, length);
    }

    public final ByteBuffer internalNioBuffer(int index, int length) {
        return this.target.internalNioBuffer(index, length);
    }

    public final ByteBuffer[] nioBuffers() {
        return this.target.nioBuffers();
    }

    public final ByteBuffer[] nioBuffers(int index, int length) {
        return this.target.nioBuffers(index, length);
    }

    public final boolean hasArray() {
        return this.target.hasArray();
    }

    public final byte[] array() {
        return this.target.array();
    }

    public final int arrayOffset() {
        return this.target.arrayOffset();
    }

    public final boolean hasMemoryAddress() {
        return this.target.hasMemoryAddress();
    }

    public final long memoryAddress() {
        return this.target.memoryAddress();
    }

    public final String toString(Charset charset) {
        return this.target.toString(charset);
    }

    public final String toString(int index, int length, Charset charset) {
        return this.target.toString(index, length, charset);
    }

    public final int compareTo(ByteBuf buffer) {
        return this.target.compareTo(buffer);
    }

    public final ByteBuf retain(int increment) {
        return this.target.retain(increment);
    }

    public final int refCnt() {
        return this.target.refCnt();
    }

    public final ByteBuf retain() {
        return this.target.retain();
    }

    public final ByteBuf touch() {
        return this.target.touch();
    }

    public final ByteBuf touch(Object hint) {
        return this.target.touch(hint);
    }

    public final boolean release() {
        return this.target.release();
    }

    public final boolean release(int decrement) {
        return this.target.release(decrement);
    }

    public final TByteBuf writeCString(@NotNull String str) {
        return this.writeCString(str, StandardCharsets.UTF_8);
    }

    public final TByteBuf writeCString(@NotNull String str, @NotNull Charset charset) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(str);
        Objects.requireNonNull(charset);
        if (str.indexOf(0) != -1) {
            throw new IllegalArgumentException("String must not contain null character (\\0)");
        }
        this.writeCharSequence(str, charset);
        this.writeZero(1);
        return this;
    }

    @Contract(value=" -> new")
    @NotNull
    public final String readCString() throws IndexOutOfBoundsException {
        return this.readCString(StandardCharsets.UTF_8);
    }

    @Contract(value="_ -> new")
    @NotNull
    public final String readCString(@NotNull Charset charset) throws NullPointerException, IndexOutOfBoundsException {
        int initialReaderIndex = this.target.readerIndex();
        int strLength = 0;
        boolean terminated = false;
        while (this.target.isReadable()) {
            if (this.target.readByte() == 0) {
                terminated = true;
                break;
            }
            ++strLength;
        }
        if (!terminated) {
            this.target.readerIndex(initialReaderIndex);
            throw new IndexOutOfBoundsException("Buffer ended before null terminator (\\0) was found.");
        }
        this.target.readerIndex(initialReaderIndex);
        String str = this.target.toString(this.target.readerIndex(), strLength, charset);
        this.target.skipBytes(strLength + 1);
        return str;
    }

    public final TByteBuf writeVarlenString(@NotNull String str) throws NullPointerException {
        return this.writeVarlenString(str, StandardCharsets.UTF_8);
    }

    public final TByteBuf writeVarlenString(@NotNull String str, @NotNull Charset charset) throws NullPointerException {
        Objects.requireNonNull(str);
        Objects.requireNonNull(charset);
        byte[] strBytes = str.getBytes(charset);
        this.target.writeIntLE(strBytes.length);
        this.target.writeBytes(strBytes);
        return this;
    }

    @Contract(value=" -> new")
    @NotNull
    public final String readVarlenString() {
        return this.readVarlenString(StandardCharsets.UTF_8);
    }

    @Contract(value="_ -> new")
    @NotNull
    public final String readVarlenString(@NotNull Charset charset) throws NullPointerException {
        Objects.requireNonNull(charset);
        int strLen = this.target.readIntLE();
        byte[] strBytes = new byte[strLen];
        this.target.readBytes(strBytes);
        return new String(strBytes, charset);
    }

    public final TByteBuf writeRiffChunk(@NotNull String chunkId, @NotNull Consumer<TByteBuf> writer) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(chunkId);
        Objects.requireNonNull(writer);
        if (chunkId.length() != 4) {
            throw new IllegalArgumentException("Chunk ID must be exactly 4 characters long.");
        }
        this.writeCharSequence(chunkId, StandardCharsets.US_ASCII);
        int sizeIndex = this.target.writerIndex();
        this.writeIntLE(0);
        int dataStartIndex = this.target.writerIndex();
        writer.accept(this);
        int dataEndIndex = this.target.writerIndex();
        int chunkSize = dataEndIndex - dataStartIndex;
        this.target.setIntLE(sizeIndex, chunkSize);
        if ((chunkSize & 1) == 1) {
            this.target.writeByte(0);
        }
        return this;
    }

    public final void readRiffChunk(@NotNull BiConsumer<String, TByteBuf> reader) throws NullPointerException, IndexOutOfBoundsException {
        Objects.requireNonNull(reader);
        String chunkId = this.target.toString(this.target.readerIndex(), 4, StandardCharsets.US_ASCII);
        this.target.skipBytes(4);
        int chunkSize = this.target.readIntLE();
        int dataStartIndex = this.target.readerIndex();
        TByteBuf chunkDataBuf = new TByteBuf(this.target.slice(dataStartIndex, chunkSize));
        this.target.skipBytes(chunkSize);
        if ((chunkSize & 1) == 1) {
            this.target.skipBytes(1);
        }
        reader.accept(chunkId, chunkDataBuf);
    }
}

