/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.math;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Bounds2i
implements Cloneable {
    public static final Bounds2i ZERO = new Bounds2i(0, 0, 0, 0);
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final int endX;
    public final int endY;
    public final boolean isEmpty;

    public Bounds2i(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width = Math.max(width, 0);
        this.height = height = Math.max(height, 0);
        this.endX = x + width;
        this.endY = y + height;
        this.isEmpty = width == 0 || height == 0;
    }

    public final int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Bounds2i) {
            Bounds2i tbb = (Bounds2i)obj;
            return this.x == tbb.x && this.y == tbb.y && this.width == tbb.width && this.height == tbb.height;
        }
        return false;
    }

    public final Bounds2i clone() {
        try {
            return (Bounds2i)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final String toString() {
        return super.toString() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public final boolean contains(int x, int y) {
        return x >= this.x && y >= this.y && x <= this.endX && y <= this.endY;
    }

    public final boolean contains(@NotNull Bounds2i other) throws NullPointerException {
        return other.x >= this.x && other.y >= this.y && other.endX <= this.endX && other.endY <= this.endY;
    }

    public final boolean intersects(@NotNull Bounds2i other) throws NullPointerException {
        return other.x <= this.endX && other.endX >= this.x && other.y <= this.endY && other.endY >= this.y;
    }

    public final boolean hasSamePosition(@NotNull Bounds2i other) {
        return this.x == other.x && this.y == other.y;
    }

    public final boolean hasSameSize(@NotNull Bounds2i other) {
        return this.width == other.width && this.height == other.height;
    }

    public final Bounds2i add(int x, int y, int width, int height) {
        return new Bounds2i(this.x + x, this.y + y, this.width + width, this.height + height);
    }

    public final Bounds2i sub(int x, int y, int width, int height) {
        return new Bounds2i(this.x - x, this.y - y, this.width - width, this.height + height);
    }

    public final Bounds2i position(int x, int y) {
        return new Bounds2i(x, y, this.width, this.height);
    }

    public final Bounds2i x(int x) {
        return new Bounds2i(x, this.y, this.width, this.height);
    }

    public final Bounds2i y(int y) {
        return new Bounds2i(this.x, y, this.width, this.height);
    }

    public final Bounds2i size(int width, int height) {
        return new Bounds2i(this.x, this.y, width, height);
    }

    public final Bounds2i width(int width) {
        return new Bounds2i(this.x, this.y, width, this.height);
    }

    public final Bounds2i height(int height) {
        return new Bounds2i(this.x, this.y, this.width, height);
    }
}

