/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.math;

import com.thecsdev.common.math.TMath;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Point2d
implements Cloneable {
    public static final Point2d ZERO = new Point2d(0.0, 0.0);
    public final double x;
    public final double y;

    public Point2d() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Point2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point2d) {
            Point2d tbb = (Point2d)obj;
            return this.x == tbb.x && this.y == tbb.y;
        }
        return false;
    }

    public final Point2d clone() {
        try {
            return (Point2d)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final String toString() {
        return super.toString() + "[x=" + this.x + ",y=" + this.y + "]";
    }

    @NotNull
    public final Point2d add(double dX, double dY) {
        return new Point2d(this.x + dX, this.y + dY);
    }

    @NotNull
    public final Point2d sub(double dX, double dY) {
        return new Point2d(this.x - dX, this.y - dY);
    }

    @NotNull
    public final Point2d clamp01() {
        return new Point2d(TMath.clamp01d(this.x), TMath.clamp01d(this.y));
    }
}

