/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.math;

import java.util.Objects;

public final class UDim {
    public static final UDim ZERO = new UDim();
    public final double scale;
    public final double offset;

    public UDim() {
        this(0.0, 0.0);
    }

    public UDim(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public final int hashCode() {
        return Objects.hash(this.scale, this.offset);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UDim) {
            UDim other = (UDim)obj;
            return this.scale == other.scale && this.offset == other.offset;
        }
        return false;
    }

    public final UDim clone() {
        return new UDim(this.scale, this.offset);
    }

    public final String toString() {
        return this.getClass().getName() + "[scale=" + this.scale + ",offset=" + this.offset + "]";
    }

    public final int computeI(int referenceValue) {
        return (int)Math.round((double)referenceValue * this.scale + this.offset);
    }

    public final float computeF(float referenceValue) {
        return (float)((double)referenceValue * this.scale + this.offset);
    }

    public final double computeD(double referenceValue) {
        return referenceValue * this.scale + this.offset;
    }
}

