/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.math;

import com.thecsdev.common.math.UDim;
import java.util.Objects;

public final class UDim2 {
    public static final UDim2 ZERO = new UDim2();
    public final UDim x;
    public final UDim y;

    public UDim2() {
        this(UDim.ZERO, UDim.ZERO);
    }

    public UDim2(double xScale, double xOffset, double yScale, double yOffset) {
        this(new UDim(xScale, xOffset), new UDim(yScale, yOffset));
    }

    public UDim2(UDim x, UDim y) throws NullPointerException {
        this.x = Objects.requireNonNull(x);
        this.y = Objects.requireNonNull(y);
    }

    public static final UDim2 fromScale(double xScale, double yScale) {
        return new UDim2(xScale, 0.0, yScale, 0.0);
    }

    public static final UDim2 fromOffset(double xOffset, double yOffset) {
        return new UDim2(0.0, xOffset, 0.0, yOffset);
    }

    public final int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UDim2) {
            UDim2 other = (UDim2)obj;
            return Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y);
        }
        return false;
    }

    public final UDim2 clone() {
        return new UDim2(this.x, this.y);
    }

    public final String toString() {
        return this.getClass().getName() + "[xScale=" + this.x.scale + ",xOffset=" + this.x.offset + ",yScale=" + this.y.scale + ",yOffset=" + this.y.offset + "]";
    }

    public final int[] computeI(int referenceValueX, int referenceValueY) {
        return new int[]{this.x.computeI(referenceValueX), this.y.computeI(referenceValueY)};
    }

    public final float[] computeF(float referenceValueX, float referenceValueY) {
        return new float[]{this.x.computeF(referenceValueX), this.y.computeF(referenceValueY)};
    }

    public final double[] computeD(double referenceValueX, double referenceValueY) {
        return new double[]{this.x.computeD(referenceValueX), this.y.computeD(referenceValueY)};
    }
}

