/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.math;

import com.thecsdev.common.math.UDim;
import java.util.Objects;

public final class UDim3 {
    public static final UDim3 ZERO = new UDim3();
    public final UDim x;
    public final UDim y;
    public final UDim z;

    public UDim3() {
        this(UDim.ZERO, UDim.ZERO, UDim.ZERO);
    }

    public UDim3(double xScale, double xOffset, double yScale, double yOffset, double zScale, double zOffset) {
        this(new UDim(xScale, xOffset), new UDim(yScale, yOffset), new UDim(zScale, zOffset));
    }

    public UDim3(UDim x, UDim y, UDim z) throws NullPointerException {
        this.x = Objects.requireNonNull(x);
        this.y = Objects.requireNonNull(y);
        this.z = Objects.requireNonNull(z);
    }

    public static final UDim3 fromScale(double xScale, double yScale, double zScale) {
        return new UDim3(xScale, 0.0, yScale, 0.0, zScale, 0.0);
    }

    public static final UDim3 fromOffset(double xOffset, double yOffset, double zOffset) {
        return new UDim3(0.0, xOffset, 0.0, yOffset, 0.0, zOffset);
    }

    public final int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UDim3) {
            UDim3 other = (UDim3)obj;
            return Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y) && Objects.equals(this.z, other.z);
        }
        return false;
    }

    public final UDim3 clone() {
        return new UDim3(this.x, this.y, this.z);
    }

    public final String toString() {
        return this.getClass().getName() + "[xScale=" + this.x.scale + ",xOffset=" + this.x.offset + ",yScale=" + this.y.scale + ",yOffset=" + this.y.offset + ",zScale=" + this.z.scale + ",zOffset=" + this.z.offset + "]";
    }

    public final int[] computeI(int referenceValueX, int referenceValueY, int referenceValueZ) {
        return new int[]{this.x.computeI(referenceValueX), this.y.computeI(referenceValueY), this.z.computeI(referenceValueZ)};
    }

    public final float[] computeF(float referenceValueX, float referenceValueY, float referenceValueZ) {
        return new float[]{this.x.computeF(referenceValueX), this.y.computeF(referenceValueY), this.z.computeF(referenceValueZ)};
    }

    public final double[] computeD(double referenceValueX, double referenceValueY, double referenceValueZ) {
        return new double[]{this.x.computeD(referenceValueX), this.y.computeD(referenceValueY), this.z.computeD(referenceValueZ)};
    }
}

