/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.properties;

import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.properties.PrimitiveProperty;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed class NotNullProperty<T>
extends ObjectProperty<T>
permits PrimitiveProperty {
    @NotNull
    private final T defaultValue;

    public NotNullProperty(@NotNull T defaultValue) {
        this(defaultValue, defaultValue);
    }

    public NotNullProperty(@Nullable T value, @NotNull T defaultValue) {
        super(value != null ? value : Objects.requireNonNull(defaultValue));
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.addFilter(it -> it != null ? it : this.defaultValue, NotNullProperty.class);
    }

    @Override
    @NotNull
    public final T get() {
        return super.get();
    }

    @Override
    @NotNull
    public final Optional<T> getOptional() {
        return Optional.of(this.get());
    }

    @NotNull
    public final T getDefaultValue() {
        return this.defaultValue;
    }
}

