/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.properties;

import com.thecsdev.common.properties.IChangeListener;
import com.thecsdev.common.properties.ValueHandle;
import com.thecsdev.common.util.TUtils;
import com.thecsdev.common.util.annotations.CallerSensitive;
import com.thecsdev.common.util.annotations.Virtual;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Virtual
public class ObjectProperty<T> {
    private volatile Class<?> owner;
    private volatile boolean readOnly = false;
    private volatile ValueHandle<T> handle = new ValueHandle<Object>(null);
    private final ConcurrentLinkedDeque<Function<T, T>> filters = new ConcurrentLinkedDeque();
    @Nullable
    private volatile IChangeListener<T> interceptor = null;
    @ApiStatus.Internal
    private final ConcurrentLinkedDeque<IChangeListener<T>> changeListeners = new ConcurrentLinkedDeque();

    public ObjectProperty() {
        this(null);
    }

    public ObjectProperty(@Nullable T value) {
        this.handle.set(value);
    }

    public final Class<?> getOwner() {
        return this.owner;
    }

    @CallerSensitive
    public final synchronized void setOwner(@Nullable Class<?> owner, @NotNull Class<?> whoIsAsking) throws NullPointerException, IllegalCallerException {
        if (this.owner != null) {
            this.assertCallerIsOwner(Objects.requireNonNull(whoIsAsking));
        }
        this.owner = owner;
    }

    public final boolean isOwner(@NotNull Class<?> caller) throws NullPointerException {
        Objects.requireNonNull(caller);
        if (this.owner == null) {
            return true;
        }
        return caller == this.owner || this.owner.isAssignableFrom(caller) || ObjectProperty.class.isAssignableFrom(caller);
    }

    protected final void assertCallerIsOwner(@NotNull Class<?> caller) throws IllegalCallerException {
        if (this.isOwner(caller)) {
            return;
        }
        throw new IllegalCallerException("Operation is only permitted from the owning class: " + this.owner.getName());
    }

    public final ValueHandle<T> getHandle() {
        return this.handle;
    }

    public final synchronized void setHandle(@NotNull ValueHandle<T> newHandle) throws NullPointerException {
        Objects.requireNonNull(newHandle);
        if (this.handle == newHandle) {
            return;
        }
        @Nullable V oldValue = this.handle.get();
        @Nullable V newValue = newHandle.get();
        this.handle = newHandle;
        if (!Objects.equals(oldValue, newValue)) {
            this.invokeChangeListeners(oldValue, newValue);
        }
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    @CallerSensitive
    public final synchronized void setReadOnly(boolean readOnly, @NotNull Class<?> whoIsAsking) throws IllegalCallerException {
        if (this.owner != null) {
            this.assertCallerIsOwner(Objects.requireNonNull(whoIsAsking));
        }
        this.readOnly = readOnly;
    }

    @CallerSensitive
    @Nullable
    public final IChangeListener<T> getInterceptor(@NotNull Class<?> whoIsAsking) throws IllegalCallerException {
        if (this.owner != null) {
            this.assertCallerIsOwner(Objects.requireNonNull(whoIsAsking));
        }
        return this.interceptor;
    }

    @CallerSensitive
    public final void setInterceptor(@Nullable IChangeListener<T> interceptor, @NotNull Class<?> whoIsAsking) throws IllegalCallerException {
        if (this.owner != null) {
            this.assertCallerIsOwner(Objects.requireNonNull(whoIsAsking));
        }
        this.interceptor = interceptor;
    }

    @Virtual
    @Nullable
    public T get() {
        return (T)this.handle.get();
    }

    @Virtual
    public @NotNull Optional<@Nullable T> getOptional() {
        return Optional.ofNullable(this.get());
    }

    @Deprecated
    @CallerSensitive
    public final synchronized void set(@Nullable T value) throws IllegalCallerException {
        boolean callerNotOwner;
        value = this.applyFilters(value);
        @Nullable V oldValue = this.handle.get();
        if (Objects.equals(oldValue, value)) {
            return;
        }
        boolean bl = callerNotOwner = this.owner != null && !this.isOwner(TUtils.getStackWalkerRCR().getCallerClass());
        if (callerNotOwner) {
            if (this.readOnly) {
                throw new IllegalCallerException("Attempt to call 'set(...)' on a read-only object property. Note that owner callers get to bypass this rule.");
            }
            if (this.interceptor != null) {
                this.interceptor.apply(this, oldValue, value);
                return;
            }
        }
        this.handle.set(value);
        this.invokeChangeListeners(oldValue, value);
    }

    @CallerSensitive
    public final synchronized void set(@Nullable T value, @NotNull Class<?> whoIsAsking) throws IllegalCallerException {
        boolean callerNotOwner;
        value = this.applyFilters(value);
        @Nullable V oldValue = this.handle.get();
        if (Objects.equals(oldValue, value)) {
            return;
        }
        boolean bl = callerNotOwner = this.owner != null && !this.isOwner(whoIsAsking);
        if (callerNotOwner) {
            if (this.readOnly) {
                throw new IllegalCallerException("Attempt to call 'set(...)' on a read-only object property. Note that owner callers get to bypass this rule.");
            }
            if (this.interceptor != null) {
                this.interceptor.apply(this, oldValue, value);
                return;
            }
        }
        this.handle.set(value);
        this.invokeChangeListeners(oldValue, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallerSensitive
    public final boolean addFilter(Function<T, T> filter, @NotNull Class<?> whoIsAsking) throws IllegalCallerException {
        if (this.owner != null) {
            this.assertCallerIsOwner(Objects.requireNonNull(whoIsAsking));
        }
        ConcurrentLinkedDeque<Function<T, T>> concurrentLinkedDeque = this.filters;
        synchronized (concurrentLinkedDeque) {
            if (this.filters.contains(filter)) {
                return false;
            }
            return this.filters.add(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeFilter(Object filter) {
        ConcurrentLinkedDeque<Function<T, T>> concurrentLinkedDeque = this.filters;
        synchronized (concurrentLinkedDeque) {
            return this.filters.remove(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T applyFilters(T newValue) {
        ConcurrentLinkedDeque<Function<T, T>> concurrentLinkedDeque = this.filters;
        synchronized (concurrentLinkedDeque) {
            if (this.filters.isEmpty()) {
                return newValue;
            }
            for (Function<T, T> filter : this.filters) {
                newValue = filter.apply(newValue);
            }
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addChangeListener(@NotNull IChangeListener<T> changeListener) throws NullPointerException {
        Objects.requireNonNull(changeListener);
        ConcurrentLinkedDeque<IChangeListener<T>> concurrentLinkedDeque = this.changeListeners;
        synchronized (concurrentLinkedDeque) {
            if (this.changeListeners.contains(changeListener)) {
                return false;
            }
            return this.changeListeners.add(Objects.requireNonNull(changeListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeChangeListener(Object changeListener) {
        ConcurrentLinkedDeque<IChangeListener<T>> concurrentLinkedDeque = this.changeListeners;
        synchronized (concurrentLinkedDeque) {
            return this.changeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    private final void invokeChangeListeners(T oldValue, T newValue) {
        ConcurrentLinkedDeque<IChangeListener<T>> concurrentLinkedDeque = this.changeListeners;
        synchronized (concurrentLinkedDeque) {
            if (this.changeListeners.isEmpty()) {
                return;
            }
            LinkedList<Exception> exceptions = null;
            for (IChangeListener<T> changeListener : this.changeListeners) {
                try {
                    changeListener.apply(this, oldValue, newValue);
                }
                catch (Exception exception) {
                    if (exceptions == null) {
                        exceptions = new LinkedList<Exception>();
                    }
                    exceptions.add(exception);
                }
            }
            if (exceptions != null) {
                RuntimeException re = new RuntimeException("Throwables were thrown during execution of change listeners");
                for (Throwable throwable : exceptions) {
                    re.addSuppressed(throwable);
                }
                throw re;
            }
        }
    }
}

