/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.scene;

import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.scene.INode;
import com.thecsdev.common.util.annotations.Virtual;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Node<N extends Node<N>>
implements INode<N> {
    final NotNullProperty<N> root = new NotNullProperty<N>(this.getSelf());
    final ObjectProperty<N> parent = new ObjectProperty<Object>(null);
    final ConcurrentLinkedDeque<N> children = new ConcurrentLinkedDeque();
    final Set<N> childrenSet = new HashSet<N>();

    public Node() {
        this.root.addChangeListener((p, o, n) -> {
            for (Node child : this) {
                NodePropertyAccessor.setRootValue(child, n);
            }
        });
        this.root.setReadOnly(true, Node.class);
        this.root.setOwner(NodePropertyAccessor.class, Node.class);
        this.parent.setInterceptor((p, o, n) -> {
            if (n != null) {
                n.add(this.getSelf());
            } else if (o != null) {
                o.remove(this.getSelf());
            }
        }, Node.class);
        this.parent.setOwner(NodePropertyAccessor.class, Node.class);
    }

    @NotNull
    public abstract N getSelf();

    @Override
    @NotNull
    public abstract Class<N> getBaseType();

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public final NotNullProperty<N> rootProperty() {
        return this.root;
    }

    public final ObjectProperty<N> parentProperty() {
        return this.parent;
    }

    @Virtual
    protected void childAddedCallback(@NotNull N child) {
    }

    @Virtual
    protected void childRemovedCallback(@NotNull N pastChild) {
    }

    @Nullable
    public final N getParent() {
        return (N)((Node)this.parent.get());
    }

    public final @NotNull Optional<@Nullable N> findParent(@NotNull Predicate<N> predicate) throws NullPointerException {
        Objects.requireNonNull(predicate);
        for (N sought = this.getParent(); sought != null; sought = ((Node)sought).getParent()) {
            if (!predicate.test(sought)) continue;
            return Optional.of(sought);
        }
        return Optional.empty();
    }

    public final @NotNull Optional<@Nullable N> findChild(@NotNull Predicate<N> predicate, boolean nested) throws NullPointerException {
        Objects.requireNonNull(predicate);
        for (Node child : this) {
            Optional<N> found;
            if (predicate.test(child)) {
                return Optional.ofNullable(child);
            }
            if (!nested || !(found = child.findChild(predicate, true)).isPresent()) continue;
            return found;
        }
        return Optional.empty();
    }

    public final @NotNull Optional<@Nullable N> findSibling(@NotNull Predicate<N> predicate) throws NullPointerException {
        Objects.requireNonNull(predicate);
        N parent = this.getParent();
        if (parent == null) {
            return Optional.empty();
        }
        for (Node sibling : parent) {
            if (sibling == this || !predicate.test(sibling)) continue;
            return Optional.ofNullable(sibling);
        }
        return Optional.empty();
    }

    @Nullable
    public final N get(int index) throws IndexOutOfBoundsException {
        ConcurrentLinkedDeque<N> concurrentLinkedDeque = this.children;
        synchronized (concurrentLinkedDeque) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            int i = 0;
            for (Node child : this) {
                if (i == index) {
                    return (N)child;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    public final int indexOf(Object o) {
        int index = 0;
        for (Node child : this) {
            if (child == o) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int size() {
        return this.children.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        return this.childrenSet.contains(o);
    }

    @Override
    @NotNull
    public final @NotNull Object @NotNull [] toArray() {
        return this.children.toArray();
    }

    @Override
    @NotNull
    public final <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
        return this.children.toArray(a);
    }

    @Override
    public final boolean containsAll(@NotNull Collection<?> c) {
        return this.children.containsAll(c);
    }

    @Override
    public final void clear() {
        for (Node child : this) {
            this.remove((N)child);
        }
    }

    @Override
    public final boolean addAll(@NotNull Collection<? extends N> c) {
        boolean out = false;
        for (Node el : c) {
            out |= this.add((N)el);
        }
        return out;
    }

    @Override
    public final boolean removeAll(@NotNull Collection<?> c) {
        boolean out = false;
        for (Object el : c) {
            out |= this.remove(el);
        }
        return out;
    }

    @Override
    public final boolean retainAll(@NotNull Collection<?> c) {
        boolean out = false;
        for (Node el : this) {
            if (c.contains(el)) continue;
            out |= this.remove((N)el);
        }
        return out;
    }

    @Override
    @NotNull
    public final Iterator<N> iterator() {
        final Iterator<N> iterator = this.children.iterator();
        return new Iterator<N>(){
            private volatile N current;

            @Override
            public final synchronized N next() {
                this.current = (Node)iterator.next();
                return this.current;
            }

            @Override
            public final synchronized boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public final synchronized void remove() {
                Object current = this.current;
                if (current == null) {
                    throw new IllegalStateException("next() must be called before remove()");
                }
                Node.this.remove(current);
                this.current = null;
            }
        };
    }

    public final void forEach(Consumer<N> action, boolean recursive) throws NullPointerException {
        if (!recursive) {
            this.forEach(action);
            return;
        }
        for (Node child : this) {
            action.accept(child);
            child.forEach(action, true);
        }
    }

    @Override
    public final boolean add(@NotNull N child) throws NullPointerException, ClassCastException, IllegalArgumentException {
        Objects.requireNonNull(child);
        if (this.contains(child)) {
            return false;
        }
        if (!this.getBaseType().isAssignableFrom(child.getClass())) {
            throw new ClassCastException("Cannot add child node of type " + String.valueOf(child.getClass()) + " because it is not an instance of " + String.valueOf(this.getBaseType()));
        }
        if (child == this) {
            throw new IllegalArgumentException("Scene graph violation. Child cannot be 'this' or a grandchild.");
        }
        Node lastParent = (Node)((Node)child).parent.get();
        if (lastParent != null && !lastParent.remove(child)) {
            throw new IllegalArgumentException("Cannot add child node (" + String.valueOf(child.getClass()) + ") because its current parent (" + String.valueOf(lastParent.getClass()) + ") refused to remove it.");
        }
        this.children.add(child);
        this.childrenSet.add(child);
        NodePropertyAccessor.setRootValue(child, (Node)this.root.get());
        NodePropertyAccessor.setParentValue(child, this.getSelf());
        this.childAddedCallback(child);
        return true;
    }

    public final boolean remove() {
        N parent = this.getParent();
        return parent != null && ((Node)parent).remove(this);
    }

    @Override
    public final boolean remove(Object child) {
        return (child == null || this.getBaseType().isAssignableFrom(child.getClass())) && this.remove((N)((Node)child));
    }

    @Override
    public final boolean remove(N child) {
        if (!this.children.remove(child) || child == null) {
            return false;
        }
        this.childrenSet.remove(child);
        NodePropertyAccessor.setRootValue(child, ((Node)child).getSelf());
        NodePropertyAccessor.setParentValue(child, null);
        this.childRemovedCallback(child);
        return true;
    }

    @ApiStatus.Internal
    static final class NodePropertyAccessor {
        private NodePropertyAccessor() {
        }

        static <E extends Node<E>> void setRootValue(Node<E> self, @Nullable E parent) {
            self.root.set(parent, NodePropertyAccessor.class);
        }

        static <E extends Node<E>> void setParentValue(Node<E> self, @Nullable E parent) {
            self.parent.set(parent, NodePropertyAccessor.class);
        }
    }
}

