/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.util;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    @NotNull
    public static final Field[] getAllDeclaredFields(@Nullable Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return new Field[0];
        }
        return (Field[])Stream.concat(Arrays.stream(clazz.getDeclaredFields()), Arrays.stream(ReflectionUtils.getAllDeclaredFields(clazz.getSuperclass()))).distinct().toArray(Field[]::new);
    }

    public static boolean constructorMatchesArgs(Constructor<?> constructor, Object ... args) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        if (paramTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            Class effectiveParamType;
            Class paramType = paramTypes[i];
            Object arg = args[i];
            if (arg == null) {
                if (!paramType.isPrimitive()) continue;
                return false;
            }
            Class<?> argType = arg.getClass();
            Class clazz = effectiveParamType = paramType.isPrimitive() ? Primitives.wrap(paramType) : paramType;
            if (effectiveParamType.isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    public static <T> T createClassInstance(Class<T> type, Object ... params) throws NullPointerException {
        Objects.requireNonNull(type);
        Objects.requireNonNull(params);
        for (Constructor<?> constructor : type.getConstructors()) {
            if (!ReflectionUtils.constructorMatchesArgs(constructor, params)) continue;
            try {
                return (T)constructor.newInstance(params);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to create instance of " + String.valueOf(constructor), e);
            }
        }
        return null;
    }

    @ApiStatus.Experimental
    public static boolean isMethodOverridden(Class<?> topClass, String methodName, Class<?> returnType, Class<?> ... paramTypes) throws NullPointerException {
        Objects.requireNonNull(topClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(paramTypes);
        int concreteCount = 0;
        for (Class<?> cls = topClass; cls != null; cls = cls.getSuperclass()) {
            try {
                Method method = cls.getDeclaredMethod(methodName, paramTypes);
                if (returnType.isAssignableFrom(method.getReturnType())) {
                    if (Modifier.isAbstract(method.getModifiers())) {
                        return concreteCount > 0;
                    }
                    ++concreteCount;
                }
                if (concreteCount < 2) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }
}

