/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.common.util.collections;

import com.thecsdev.common.util.annotations.Virtual;
import java.util.HashMap;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Virtual
public class GenericProperties<K>
extends HashMap<K, Object> {
    private static final long serialVersionUID = 7086758792901773483L;

    @Deprecated
    @Nullable
    public final <V> V getProperty(@NotNull Class<V> type, @NotNull K key) throws NullPointerException {
        return this.getProperty(type, key, null);
    }

    @Contract(value="_, _, !null -> !null; _, _, _ -> _;")
    @Nullable
    public final <V> V getProperty(@NotNull Class<V> type, @NotNull K key, @Nullable V defaultValue) throws NullPointerException {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        @Nullable V val = this.get(key);
        if (type.isInstance(val)) {
            return type.cast(val);
        }
        if (defaultValue != null) {
            this.put(key, defaultValue);
            return defaultValue;
        }
        return null;
    }

    @Nullable
    public final <V> V setProperty(@NotNull Class<V> type, @NotNull K key, @Nullable V value) throws NullPointerException {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        @Nullable V prevVal = this.put(key, value);
        return type.isInstance(prevVal) ? (V)type.cast(prevVal) : null;
    }
}

