/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc;

import com.thecsdev.common.util.TUtils;
import com.thecsdev.commonmc.TCDCommonsConfig;
import com.thecsdev.commonmc.client.TCDCommonsClient;
import com.thecsdev.commonmc.server.TCDCommonsServer;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCDCommons {
    public static final String MOD_ID = "tcdcommons";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tcdcommons");
    private static final Properties PROPERTIES = new Properties();
    private static final TCDCommonsConfig CONFIG = new TCDCommonsConfig();
    private static TCDCommons INSTANCE;
    private final String modName;
    private final String modVersion;

    protected TCDCommons() {
        if (!(this instanceof TCDCommonsClient) && !(this instanceof TCDCommonsServer)) {
            throw new IllegalStateException("Unexpected subclass " + String.valueOf(this.getClass()));
        }
        if (INSTANCE != null) {
            throw new IllegalStateException("Mod already initialized - tcdcommons");
        }
        INSTANCE = this;
        LOGGER.info("Initializing 'tcdcommons' as '" + this.getClass().getSimpleName() + "'.");
        try {
            PROPERTIES.load(TCDCommons.class.getResourceAsStream("/tcdcommons.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load 'tcdcommons.properties'", e);
        }
        this.modName = Objects.requireNonNull(PROPERTIES.getProperty("mod.name"));
        this.modVersion = Objects.requireNonNull(PROPERTIES.getProperty("mod.version"));
        TUtils.uncheckedCall(CONFIG::loadFromFile);
    }

    public static final TCDCommons getInstance() {
        return INSTANCE;
    }

    public static final TCDCommonsConfig getConfig() {
        return CONFIG;
    }

    public final String getModName() {
        return this.modName;
    }

    public final String getModVersion() {
        return this.modVersion;
    }
}

