/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.math.UDim2;
import com.thecsdev.common.properties.BooleanProperty;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.scene.INodeBounded;
import com.thecsdev.common.scene.INodeRenderable;
import com.thecsdev.common.scene.Node;
import com.thecsdev.common.util.ReflectionUtils;
import com.thecsdev.common.util.annotations.Reflected;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.ctxmenu.TContextMenu;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.screen.TScreen;
import com.thecsdev.commonmc.api.client.gui.util.CursorType;
import com.thecsdev.commonmc.api.client.gui.util.SceneGraphPath;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.client.mixin.hooks.AccessorTElement;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Reflected(value={AccessorTElement.class})
@Virtual
public class TElement
extends Node<TElement>
implements INodeBounded<TElement, Bounds2i>,
INodeRenderable<TElement, TGuiGraphics> {
    private final NotNullProperty<Bounds2i> bounds = new NotNullProperty<Bounds2i>(Bounds2i.ZERO);
    private final ObjectProperty<TScreen> screen = new ObjectProperty<Object>(null);
    private final BooleanProperty visible = new BooleanProperty(true);
    private final BooleanProperty clipsDescendants = new BooleanProperty(true);
    private final BooleanProperty focusable = new BooleanProperty(false);
    private final BooleanProperty hoverable = new BooleanProperty(true);
    private final ObjectProperty<Function<TElement, TElement>> tooltip = new ObjectProperty<Object>(null);
    private final ObjectProperty<Function<TElement, TContextMenu>> contextMenu = new ObjectProperty<Object>(null);
    @Nullable
    private Bounds2i contentBounds = null;
    @Nullable
    private TElement currentTooltip = null;
    public final Event<Consumer<TElement>> eInitialized = EventFactory.createLoop((Object[])new Consumer[0]);
    @ApiStatus.Internal
    private static final Object2BooleanMap<Class<?>> OVERRIDES_INIT = new Object2BooleanOpenHashMap();

    public TElement() {
        this.screen.setReadOnly(true, TElement.class);
        this.screen.setOwner(TElementPropertyAccessor.class, TElement.class);
        this.parentProperty().addChangeListener((p, o, n) -> {
            TElementPropertyAccessor.setScreenValue(this, this.findParent(ps -> ps instanceof TScreen).orElse(null));
            if (o != null) {
                o.contentBounds = null;
            }
            if (n != null) {
                n.contentBounds = null;
            }
        });
        this.screen.addChangeListener((p, o, n) -> {
            for (TElement child : this) {
                TElementPropertyAccessor.setScreenValue(child, n);
            }
            if (o != null) {
                if (o.hoveredElementProperty().get() == this) {
                    o.hoveredElementProperty().set(null, TScreen.class);
                }
                if (o.focusedElementProperty().get() == this) {
                    o.focusedElementProperty().set(null, TScreen.class);
                }
            }
        });
        this.boundsProperty().addChangeListener((p, o, n) -> {
            this.contentBounds = null;
            TElement pe = (TElement)this.getParent();
            if (pe != null) {
                pe.contentBounds = null;
            }
        });
        this.tooltip.addChangeListener((p, o, n) -> this.invalidateTooltipCache());
    }

    @Override
    @NotNull
    public final TElement getSelf() {
        return this;
    }

    @Override
    @NotNull
    public final Class<TElement> getBaseType() {
        return TElement.class;
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
    }

    @Override
    @Virtual
    public void postRenderCallback(@NotNull TGuiGraphics pencil) {
    }

    @Virtual
    public String toString() {
        Bounds2i bb = this.getBounds();
        return String.format("%s[x=%d,y=%d,width=%d,height=%d]", super.toString(), bb.x, bb.y, bb.width, bb.height);
    }

    @Override
    @NotNull
    public final Bounds2i getBounds() {
        return this.bounds.get();
    }

    @NotNull
    public final Bounds2i getContentBounds() {
        Bounds2i cb = this.contentBounds;
        if (cb == null) {
            if (!this.isEmpty()) {
                int sX = Integer.MAX_VALUE;
                int sY = Integer.MAX_VALUE;
                int eX = Integer.MIN_VALUE;
                int eY = Integer.MIN_VALUE;
                for (TElement child : this) {
                    Bounds2i childBounds = child.getBounds();
                    if (childBounds.x < sX) {
                        sX = childBounds.x;
                    }
                    if (childBounds.y < sY) {
                        sY = childBounds.y;
                    }
                    if (childBounds.endX > eX) {
                        eX = childBounds.endX;
                    }
                    if (childBounds.endY <= eY) continue;
                    eY = childBounds.endY;
                }
                cb = new Bounds2i(sX, sY, eX - sX, eY - sY);
            } else {
                Bounds2i bb = this.getBounds();
                cb = new Bounds2i(bb.x, bb.y, 0, 0);
            }
            this.contentBounds = cb;
        }
        return cb;
    }

    @ApiStatus.NonExtendable
    @Nullable
    public class_310 getClient() {
        TScreen screen = this.screenProperty().get();
        return screen != null ? screen.getClient() : null;
    }

    public final NotNullProperty<Bounds2i> boundsProperty() {
        return this.bounds;
    }

    public final ObjectProperty<TScreen> screenProperty() {
        return this.screen;
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    public final BooleanProperty clipsDescendantsProperty() {
        return this.clipsDescendants;
    }

    public final BooleanProperty focusableProperty() {
        return this.focusable;
    }

    public final BooleanProperty hoverableProperty() {
        return this.hoverable;
    }

    public final ObjectProperty<Function<@NotNull TElement, @NotNull TElement>> tooltipProperty() {
        return this.tooltip;
    }

    public final ObjectProperty<Function<@NotNull TElement, @Nullable TContextMenu>> contextMenuProperty() {
        return this.contextMenu;
    }

    public final boolean isVisible() {
        TElement parent = (TElement)this.getParent();
        if (parent != null) {
            return this.visible.getZ() && parent.isVisible();
        }
        return this.visible.getZ();
    }

    public final boolean isHovered() {
        TScreen s = this.screenProperty().get();
        return s != null && s.hoveredElementProperty().get() == this;
    }

    public final boolean isFocused() {
        TScreen s = this.screenProperty().get();
        return s != null && s.focusedElementProperty().get() == this;
    }

    public final boolean isHoveredOrFocused() {
        return this.isHovered() || this.isFocused();
    }

    @Virtual
    public boolean isFocusable() {
        return this.focusable.getZ();
    }

    @Virtual
    public boolean isHoverable() {
        return this.hoverable.getZ();
    }

    @Nullable
    public final TElement getTooltip() {
        if (this.currentTooltip != null) {
            return this.currentTooltip;
        }
        Function<TElement, TElement> tts = this.tooltip.get();
        if (tts == null) {
            TElement parent = (TElement)this.getParent();
            return parent != null ? parent.getTooltip() : null;
        }
        this.currentTooltip = Objects.requireNonNull(tts.apply(this), "Tooltip supplier returned null");
        this.currentTooltip.initCallback();
        return this.currentTooltip;
    }

    public final void invalidateTooltipCache() {
        this.currentTooltip = null;
    }

    public final void move(int dX, int dY) {
        if (dX == 0 && dY == 0) {
            return;
        }
        Bounds2i bb = this.getBounds();
        this.setBounds(bb.x + dX, bb.y + dY, bb.width, bb.height);
        this.moveChildren(dX, dY);
    }

    public final void moveChildren(int dX, int dY) {
        if (dX == 0 && dY == 0) {
            return;
        }
        for (TElement child : this) {
            child.move(dX, dY);
        }
    }

    public final void moveTo(int x, int y) {
        Bounds2i bb = this.getBounds();
        this.move(x - bb.x, y - bb.y);
    }

    public final void setBounds(int x, int y, int width, int height) {
        this.setBounds(new Bounds2i(x, y, width, height));
    }

    public final void setBounds(@NotNull Bounds2i bounds) {
        this.bounds.set(bounds, TElement.class);
    }

    public final void setBounds(@NotNull UDim2 position, @NotNull UDim2 size) throws NullPointerException, IllegalStateException {
        Objects.requireNonNull(position);
        Objects.requireNonNull(size);
        TElement parent = (TElement)this.getParent();
        if (parent == null) {
            throw new IllegalStateException("");
        }
        Bounds2i pbb = parent.getBounds();
        this.bounds.set(new Bounds2i(pbb.x + position.x.computeI(pbb.width), pbb.y + position.y.computeI(pbb.height), size.x.computeI(pbb.width), size.y.computeI(pbb.height)), TElement.class);
    }

    @Nullable
    public final TElement findElementAt(int screenX, int screenY) {
        @Nullable TElement bestCandidate = null;
        for (TElement child : this) {
            if (!((Boolean)child.visible.get()).booleanValue()) continue;
            TElement candidate = null;
            if (child.getBounds().contains(screenX, screenY)) {
                @Nullable TElement descendantCandidate = child.findElementAt(screenX, screenY);
                candidate = descendantCandidate != null ? descendantCandidate : (child.isHoverable() ? child : null);
            } else if (!((Boolean)child.clipsDescendants.get()).booleanValue()) {
                candidate = child.findElementAt(screenX, screenY);
            }
            if (candidate == null) continue;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }

    public final void forEachVisible(@NotNull Consumer<TElement> action, boolean recursive) throws NullPointerException {
        Objects.requireNonNull(action);
        if (!this.isVisible()) {
            return;
        }
        for (TElement child : this) {
            if (!((Boolean)child.visibleProperty().get()).booleanValue()) continue;
            action.accept(child);
            if (!recursive) continue;
            child.forEachVisible(action, true);
        }
    }

    @Contract(pure=true)
    @Virtual
    @NotNull
    public CursorType getCursor() {
        return CursorType.DEFAULT;
    }

    public final void clearAndInit() {
        TScreen s;
        TScreen screen;
        TElement tElement = this;
        TScreen tScreen = screen = tElement instanceof TScreen ? (s = (TScreen)tElement) : this.screenProperty().get();
        if (screen == null) {
            this._clearAndInit();
            return;
        }
        SceneGraphPath path_focus = SceneGraphPath.of(this, screen.focusedElementProperty().get());
        this._clearAndInit();
        if (path_focus != null) {
            @Nullable TElement finding = path_focus.resolve(this);
            screen.focusedElementProperty().set(finding, TElement.class);
            if (finding != null) {
                TGuiUtils.scrollToElement(finding);
            }
        }
    }

    @ApiStatus.Internal
    private final void _clearAndInit() {
        if (this.overridesInitCallback()) {
            this.clear();
            this.initCallback();
        }
        for (TElement c : this) {
            c._clearAndInit();
        }
        ((Consumer)this.eInitialized.invoker()).accept(this);
    }

    @Reflected
    @Virtual
    protected void initCallback() {
    }

    @Virtual
    public boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) throws NullPointerException {
        return false;
    }

    @Reflected
    @ApiStatus.Internal
    private final void tick() {
        this.tickCallback();
        Bounds2i bb = this.getBounds();
        for (TElement child : this) {
            if (!child.getBounds().intersects(bb)) continue;
            child.tick();
        }
    }

    @Virtual
    protected void tickCallback() {
    }

    @Reflected
    @Virtual
    protected void hoverGainedCallback() {
    }

    @Reflected
    @Virtual
    protected void hoverLostCallback() {
    }

    @Reflected
    @Virtual
    protected void focusGainedCallback() {
    }

    @Reflected
    @Virtual
    protected void focusLostCallback() {
    }

    @Reflected
    @Virtual
    protected void dragStartCallback() {
    }

    @Reflected
    @Virtual
    protected void dragEndCallback() {
    }

    public final void addRel(TElement child) {
        this.add(child);
        Bounds2i bb = this.getBounds();
        child.move(bb.x, bb.y);
    }

    public final void removeRel(TElement child) {
        this.remove(child);
        Bounds2i bb = this.getBounds();
        child.move(-bb.x, -bb.y);
    }

    private final boolean overridesInitCallback() {
        return TElement.overridesInitCallback(this.getClass());
    }

    private static final boolean overridesInitCallback(Class<? extends TElement> clazz) {
        return OVERRIDES_INIT.computeIfAbsent(clazz, __ -> ReflectionUtils.isMethodOverridden(clazz, "initCallback", Void.TYPE, new Class[0]));
    }

    @Nullable
    public final TContextMenu showContextMenu() {
        TScreen screen = this.screenProperty().get();
        if (screen == null) {
            return null;
        }
        Function<TElement, TContextMenu> supplier = this.contextMenu.get();
        if (supplier == null) {
            return null;
        }
        boolean moveToCursor = this.isHovered() && !this.isFocused();
        TContextMenu menu = supplier.apply(this);
        if (menu == null) {
            return null;
        }
        screen.add(menu);
        if (moveToCursor) {
            class_310 client = this.getClient();
            assert (client != null);
            class_1041 window = client.method_22683();
            menu.moveTo((int)client.field_1729.method_68879(window), (int)client.field_1729.method_68883(window));
        } else {
            Bounds2i bb = this.getBounds();
            Bounds2i mbb = menu.getBounds();
            Bounds2i sbb = screen.getBounds();
            menu.moveTo(bb.x, bb.endY + mbb.height > sbb.endY ? bb.y - mbb.height : bb.endY);
        }
        menu.snapToParent();
        return menu;
    }

    @ApiStatus.Internal
    static final class TElementPropertyAccessor {
        private TElementPropertyAccessor() {
        }

        static void setScreenValue(TElement element, @Nullable TScreen value) {
            element.screen.set(value, TElementPropertyAccessor.class);
        }
    }
}

