/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.ctxmenu;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.label.TLabelElement;
import com.thecsdev.commonmc.api.client.gui.misc.THoverScrollElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.screen.TScreen;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.api.client.gui.widget.TButtonWidget;
import com.thecsdev.commonmc.api.client.gui.widget.TClickableWidget;
import com.thecsdev.commonmc.resources.TCDCSprites;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TContextMenu
extends TElement {
    private final NotNullProperty<TContextMenu> rootContextMenu = new NotNullProperty<TContextMenu>(this);

    public TContextMenu() {
        this.hoverableProperty().set(true, TContextMenu.class);
        this.focusableProperty().set(true, TContextMenu.class);
        this.clipsDescendantsProperty().set(false, TContextMenu.class);
        this.clipsDescendantsProperty().addFilter(__ -> false, TContextMenu.class);
        this.screenProperty().addChangeListener((p, o, n) -> {
            if (n == null) {
                return;
            }
            n.forEach(el -> {
                if (el instanceof TContextMenu && el != this && !TGuiUtils.isAncestor(el, this) && !TGuiUtils.isAncestor(this, el)) {
                    el.remove();
                }
            }, true);
            n.focusedElementProperty().set(this, TContextMenu.class);
        });
        this.parentProperty().addChangeListener((p, o, n) -> {
            if (n == null) {
                return;
            }
            if (!(n instanceof TScreen) && !(n instanceof TContextMenu)) {
                n.remove(this);
                throw new IllegalStateException("Context menu assigned to an illegal parent - " + String.valueOf(n));
            }
        });
        this.rootContextMenu.setReadOnly(true, TContextMenu.class);
        this.rootContextMenu.setOwner(PropertyAccessor.class, TContextMenu.class);
        this.rootContextMenu.addChangeListener((p, o, n) -> {
            for (TElement child : this) {
                if (!(child instanceof TContextMenu)) continue;
                TContextMenu childMenu = (TContextMenu)child;
                PropertyAccessor.setRootCtxMenuValue(childMenu, n);
            }
        });
        this.parentProperty().addChangeListener((p, o, n) -> {
            TContextMenu root = this;
            TElement next = this;
            while (next != null) {
                TContextMenu pcm;
                TElement patt0$temp = next = (TElement)next.getParent();
                if (!(patt0$temp instanceof TContextMenu)) continue;
                root = pcm = (TContextMenu)patt0$temp;
            }
            PropertyAccessor.setRootCtxMenuValue(this, root);
        });
    }

    public final NotNullProperty<TContextMenu> rootContextMenuProperty() {
        return this.rootContextMenu;
    }

    @Override
    public final boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) {
        if (phase == TInputContext.InputDiscoveryPhase.PREEMPT) {
            switch (context.getInputType()) {
                case MOUSE_SCROLL: {
                    return !this.isHoverAncestor() && !(this.getParent() instanceof TContextMenu);
                }
                case MOUSE_PRESS: {
                    if (this.isHoverAncestor()) break;
                    boolean result = !this.rootContextMenuProperty().get().isHoverAncestor();
                    this.remove();
                    return result;
                }
                case KEY_PRESS: {
                    if (this.isFocusAncestor() && context.getKeyCode() != 256) break;
                    return this.remove();
                }
            }
        } else if (phase == TInputContext.InputDiscoveryPhase.MAIN && context.getInputType() == TInputContext.InputType.MOUSE_PRESS) {
            return true;
        }
        return false;
    }

    @Virtual
    protected void renderShadow(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.drawShadow(bb.x, bb.y, bb.width, bb.height, 0, 0, 5, 1, 0x10000000, false);
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
        this.renderShadow(pencil);
        Bounds2i bb = this.getBounds();
        pencil.fillColor(bb.x, bb.y, bb.width, bb.height, -14737633);
        pencil.drawOutlineOut(bb.x, bb.y, bb.width, bb.height, this.isFocused() ? -8487298 : -10592674);
    }

    public final boolean isFocusAncestor() {
        TScreen screen = this.screenProperty().get();
        if (screen == null) {
            return false;
        }
        TElement focus = screen.focusedElementProperty().get();
        return focus == this || TGuiUtils.isAncestor(focus, this);
    }

    public final boolean isHoverAncestor() {
        TScreen screen = this.screenProperty().get();
        if (screen == null) {
            return false;
        }
        TElement hover = screen.hoveredElementProperty().get();
        return hover == this || TGuiUtils.isAncestor(hover, this);
    }

    public final void snapToParent() {
        TContextMenu pcm;
        TElement viewport = (TElement)this.rootContextMenuProperty().get().getParent();
        if (viewport == null) {
            return;
        }
        Object n = this.getParent();
        TContextMenu parentcm = n instanceof TContextMenu ? (pcm = (TContextMenu)n) : null;
        Bounds2i bb = this.getBounds();
        Bounds2i vbb = viewport.getBounds();
        int dX = 0;
        int dY = 0;
        if (bb.endY > vbb.endY) {
            dY = vbb.endY - bb.endY;
        }
        if (bb.y + dY < vbb.y) {
            dY += vbb.y - (bb.y + dY);
        }
        if (bb.endX > vbb.endX) {
            int n2 = dX = parentcm != null ? parentcm.getBounds().x - bb.endX : vbb.endX - bb.endX;
        }
        if (bb.x + dX < vbb.x) {
            dX += vbb.x - (bb.x + dX);
        }
        this.move(dX, dY);
    }

    @ApiStatus.Internal
    static final class PropertyAccessor {
        private PropertyAccessor() {
        }

        static void setRootCtxMenuValue(TContextMenu self, @Nullable TContextMenu root) {
            self.rootContextMenu.set(root, PropertyAccessor.class);
        }
    }

    public static final class Builder {
        private final class_310 client;
        private final ArrayList<TElement> entries = new ArrayList();
        private int maxW;
        private int maxH;

        public Builder(@NotNull class_310 client) {
            this.client = Objects.requireNonNull(client);
            class_1041 wnd = client.method_22683();
            this.maxW = Math.max(wnd.method_4486() / 3, 300);
            this.maxH = Math.max(wnd.method_4502() - 4, 20);
        }

        public final Builder setMaxWidth(int maxWidth) {
            this.maxW = Math.max(maxWidth, 300);
            return this;
        }

        public final Builder setMaxHeight(int maxHeight) {
            this.maxH = Math.max(maxHeight, 20);
            return this;
        }

        public final Builder setMaxSize(int maxWidth, int maxHeight) {
            return this.setMaxWidth(maxWidth).setMaxHeight(maxHeight);
        }

        public final Builder addElement(@NotNull TElement element) throws NullPointerException {
            this.entries.add(Objects.requireNonNull(element));
            return this;
        }

        public final Builder addButton(@NotNull class_2561 text, @NotNull Consumer<TClickableWidget> onClick) throws NullPointerException {
            Button btn = new Button();
            btn.getLabel().setText(text);
            btn.getLabel().textAlignmentProperty().set(CompassDirection.WEST, Builder.class);
            btn.setBounds(0, 0, this.client.field_1772.method_27525((class_5348)text) + 10, 15);
            btn.eClicked.register(onClick);
            btn.eClicked.register(__ -> btn.getParentMenu().rootContextMenuProperty().get().remove());
            this.entries.add(btn);
            return this;
        }

        public final Builder addContextMenu(@NotNull class_2561 text, @NotNull TContextMenu menu) throws NullPointerException {
            Button btn = new Button();
            btn.getLabel().setText(text);
            btn.getLabel().textAlignmentProperty().set(CompassDirection.WEST, Builder.class);
            btn.setBounds(0, 0, this.client.field_1772.method_27525((class_5348)text) + 10, 15);
            btn.eClicked.register(__ -> {
                btn.getParentMenu().add(menu);
                Bounds2i pbb = btn.getParentMenu().getBounds();
                Bounds2i bbb = btn.getBounds();
                menu.moveTo(pbb.endX, bbb.y);
                menu.snapToParent();
            });
            this.entries.add(btn);
            return this;
        }

        public final Builder addSeparator() {
            TElement sep = new TElement(this){

                @Override
                public final void renderCallback(@NotNull TGuiGraphics pencil) {
                    Bounds2i bb = this.getBounds();
                    pencil.fillColor(bb.x + 2, bb.y + bb.height / 2, bb.width - 4, 1, 0x2EFFFFFF);
                }
            };
            sep.setBounds(0, 0, 0, 4);
            this.entries.add(sep);
            return this;
        }

        @NotNull
        public final TContextMenu build() {
            TPanelElement.Transparent panel = new TPanelElement.Transparent();
            panel.setBounds(0, 0, TGuiUtils.calcMaxWidth(this.entries), 0);
            panel.addAllVertically(this.entries, 0);
            panel.setBounds(panel.getContentBounds());
            boolean panelTooBig = false;
            Bounds2i pbb = panel.getBounds();
            if (pbb.width > this.maxW || pbb.height > this.maxH) {
                panel.setBounds(pbb.x, pbb.y, Math.min(pbb.width, this.maxW), Math.min(pbb.height, this.maxH));
                panelTooBig = true;
            }
            TContextMenu ctx = new TContextMenu(this){

                @Override
                public final void renderCallback(@NotNull TGuiGraphics pencil) {
                    this.renderShadow(pencil);
                    Bounds2i bb = this.getBounds();
                    pencil.drawGuiSprite(this.isFocused() ? TCDCSprites.gui_popup_ctxmenuHighlighted() : TCDCSprites.gui_popup_ctxmenu(), bb.x, bb.y, bb.width, bb.height, -1);
                }
            };
            ctx.setBounds(panel.getBounds().add(-1, -2, 2, 4));
            ctx.add(panel);
            if (panelTooBig) {
                Bounds2i mbb = ctx.getBounds();
                HScroll scroll_up = new HScroll(panel);
                scroll_up.directionProperty().set(CompassDirection.NORTH, Builder.class);
                scroll_up.setBounds(mbb.x + 2, mbb.y + 1, mbb.width - 4, 15);
                ctx.add(scroll_up);
                HScroll scroll_down = new HScroll(panel);
                scroll_down.directionProperty().set(CompassDirection.SOUTH, Builder.class);
                scroll_down.setBounds(mbb.x + 2, mbb.endY - 15 - 1, mbb.width - 4, 15);
                ctx.add(scroll_down);
                TLabelElement lbl_up = new TLabelElement();
                lbl_up.setText((class_2561)class_2561.method_43470((String)"\u25b2"));
                lbl_up.textAlignmentProperty().set(CompassDirection.CENTER, Builder.class);
                lbl_up.setBounds(scroll_up.getBounds());
                scroll_up.add(lbl_up);
                TLabelElement lbl_down = new TLabelElement();
                lbl_down.setText((class_2561)class_2561.method_43470((String)"\u25bc"));
                lbl_down.textAlignmentProperty().set(CompassDirection.CENTER, Builder.class);
                lbl_down.setBounds(scroll_down.getBounds());
                scroll_down.add(lbl_down);
            }
            ctx.clearAndInit();
            return ctx;
        }

        private static final class Button
        extends TButtonWidget.Transparent {
            private Button() {
            }

            @Override
            public final void postRenderCallback(@NotNull TGuiGraphics pencil) {
            }

            @Override
            public final void renderCallback(@NotNull TGuiGraphics pencil) {
                if (!this.isHoveredOrFocused()) {
                    return;
                }
                Bounds2i bb = this.getBounds();
                pencil.fillColor(bb.x, bb.y, bb.width, bb.height, -13224395);
            }

            @NotNull
            public final TContextMenu getParentMenu() {
                TElement parent = this.findParent(p -> p instanceof TContextMenu).orElse(null);
                assert (parent != null);
                return (TContextMenu)parent;
            }
        }

        private static final class HScroll
        extends THoverScrollElement.Panel {
            public HScroll(@NotNull TPanelElement target) {
                super(target);
            }

            @Override
            @Virtual
            public void renderCallback(@NotNull TGuiGraphics pencil) {
                Bounds2i bb = this.getBounds();
                pencil.fillColor(bb.x, bb.y, bb.width, bb.height, -1442840576);
            }
        }
    }
}

