/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.label;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.BooleanProperty;
import com.thecsdev.common.properties.DoubleProperty;
import com.thecsdev.common.properties.IChangeListener;
import com.thecsdev.common.properties.IntegerProperty;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

public final class TLabelElement
extends TElement {
    private final NotNullProperty<class_2561> text = new NotNullProperty<class_5250>(class_2561.method_43473());
    private final NotNullProperty<class_327> font;
    private final IntegerProperty lineSpacing;
    private final IntegerProperty textColor;
    private final BooleanProperty wrapText;
    private final NotNullProperty<CompassDirection> textAlignment;
    private final DoubleProperty textScale;
    private boolean isDirty;
    private List<class_5481> lines;
    private int textWidth;
    private int textHeight;

    public TLabelElement(@NotNull class_2561 text) {
        this();
        this.setText(text);
    }

    public TLabelElement() {
        this.font = new NotNullProperty<class_327>(class_310.method_1551().field_1772);
        this.lineSpacing = new IntegerProperty(2);
        this.textColor = new IntegerProperty(-1);
        this.wrapText = new BooleanProperty(false);
        this.textAlignment = new NotNullProperty<CompassDirection>(CompassDirection.WEST);
        this.textScale = new DoubleProperty(1.0);
        this.isDirty = true;
        this.focusableProperty().set(false, TLabelElement.class);
        this.hoverableProperty().set(false, TLabelElement.class);
        IChangeListener<Object> cl_refresh = (p, o, n) -> {
            this.isDirty = true;
        };
        this.boundsProperty().addChangeListener((p, o, n) -> {
            if (!o.hasSameSize((Bounds2i)n)) {
                this.isDirty = true;
            }
        });
        this.text.addChangeListener(cl_refresh);
        this.lineSpacing.addChangeListener(cl_refresh);
        this.wrapText.addChangeListener(cl_refresh);
        this.textAlignment.addChangeListener(cl_refresh);
        this.textScale.addChangeListener(cl_refresh);
    }

    public final NotNullProperty<class_2561> textProperty() {
        return this.text;
    }

    public final NotNullProperty<class_327> fontProperty() {
        return this.font;
    }

    public final IntegerProperty lineSpacingProperty() {
        return this.lineSpacing;
    }

    public final IntegerProperty textColorProperty() {
        return this.textColor;
    }

    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public final NotNullProperty<CompassDirection> textAlignmentProperty() {
        return this.textAlignment;
    }

    public final DoubleProperty textScaleProperty() {
        return this.textScale;
    }

    @Override
    protected final void initCallback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void renderCallback(@NotNull TGuiGraphics pencil) {
        if (this.isDirty) {
            this.refresh();
        } else if (this.lines.isEmpty()) {
            return;
        }
        Bounds2i bb = this.getBounds();
        class_327 font = this.font.get();
        float textScale = this.textScale.getF();
        int lineSpacing = this.lines.size() < 2 ? 0 : this.lineSpacing.getI();
        Objects.requireNonNull(font);
        int totalLineH = 9 + lineSpacing;
        int textHeight = (int)((float)this.getTextHeight() / textScale);
        int color = this.textColor.getI();
        CompassDirection align = this.textAlignment.get();
        float textHeightScaled = (float)textHeight * textScale;
        float totalTranslateY = align.isTop() ? (float)bb.y : (align.isCenterY() ? (float)bb.y + ((float)bb.height - textHeightScaled) / 2.0f : (float)bb.endY - textHeightScaled);
        int maxUnscaledWidth = 0;
        for (class_5481 line : this.lines) {
            int lineWidth = font.method_30880(line);
            if (lineWidth <= maxUnscaledWidth) continue;
            maxUnscaledWidth = lineWidth;
        }
        float textWidthScaled = (float)maxUnscaledWidth * textScale;
        float totalTranslateX = align.isLeft() ? (float)bb.x : (align.isCenterX() ? (float)bb.x + ((float)bb.width - textWidthScaled) / 2.0f : (float)bb.endX - textWidthScaled);
        pencil.pushScissors(bb.x, bb.y, bb.width, bb.height);
        Matrix3x2fStack matrix = pencil.getNativeMatrices();
        matrix.pushMatrix();
        matrix.scale(textScale, textScale);
        matrix.translate(totalTranslateX / textScale, totalTranslateY / textScale);
        try {
            boolean startY = false;
            int offsetY = 0;
            for (class_5481 line : this.lines) {
                int lineWidth = font.method_30880(line);
                int drawX = align.isLeft() ? 0 : (align.isCenterX() ? Math.round((float)(maxUnscaledWidth - lineWidth) / 2.0f) : maxUnscaledWidth - lineWidth);
                int drawY = 0 + offsetY;
                pencil.getNative().method_35720(font, line, drawX, drawY, color);
                offsetY += totalLineH;
            }
        }
        finally {
            matrix.popMatrix();
            pencil.popScissors();
        }
    }

    @Override
    @Virtual
    public void postRenderCallback(@NotNull TGuiGraphics pencil) {
        if (!this.isFocused()) {
            return;
        }
        Bounds2i bb = this.getBounds();
        pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, -620756993);
    }

    public final void refresh() {
        this.isDirty = false;
        class_2561 text = this.text.get();
        double textScale = this.textScale.getD();
        if (StringUtils.isEmpty((CharSequence)text.getString()) || textScale < 0.01) {
            this.lines = List.of();
            this.textHeight = 0;
            return;
        }
        class_327 font = this.font.get();
        List lines = this.lines = font.method_1728((class_5348)text, this.wrapText.getZ() ? (int)((double)this.getBounds().width / textScale) : Integer.MAX_VALUE);
        double lineSpacing = lines.size() < 2 ? 0.0 : this.lineSpacing.getD();
        Objects.requireNonNull(font);
        double totalLineH = (9.0 + lineSpacing) * textScale;
        this.textWidth = (int)Math.ceil((double)lines.stream().map(arg_0 -> ((class_327)font).method_30880(arg_0)).max(Integer::compare).orElse(0).intValue() * textScale);
        this.textHeight = (int)Math.ceil((double)lines.size() * totalLineH - lineSpacing * textScale);
    }

    @NotNull
    public final class_2561 getText() {
        return this.text.get();
    }

    public final void setText(@NotNull class_2561 text) {
        this.text.set(text, TLabelElement.class);
    }

    public final void setBoundsToFitText(int maxWidth) {
        Bounds2i bb = this.getBounds();
        this.setBoundsToFitText(bb.x, bb.y, maxWidth);
    }

    public final void setBoundsToFitText(int x, int y, int maxWidth) {
        Bounds2i bb = this.getBounds();
        if (this.wrapTextProperty().getZ()) {
            bb = new Bounds2i(bb.x, bb.y, maxWidth, Integer.MAX_VALUE);
            this.boundsProperty().getHandle().set(bb);
            this.refresh();
            this.setBounds(x, y, bb.width, this.textHeight);
        } else {
            bb = new Bounds2i(bb.x, bb.y, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.boundsProperty().getHandle().set(bb);
            this.refresh();
            this.setBounds(x, y, this.textWidth, this.textHeight);
        }
        this.isDirty = true;
    }

    public final int getTextWidth() {
        if (this.isDirty) {
            this.refresh();
        }
        return this.textWidth;
    }

    public final int getTextHeight() {
        if (this.isDirty) {
            this.refresh();
        }
        return this.textHeight;
    }
}

