/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.misc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.BooleanProperty;
import com.thecsdev.common.properties.DoubleProperty;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.TCDCommons;
import com.thecsdev.commonmc.TCDCommonsConfig;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.world.sandbox.SandboxLevel;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TEntityElement
extends TElement {
    private final NotNullProperty<class_1299<?>> entityType = new NotNullProperty<class_1299>(class_1299.field_33456);
    private final BooleanProperty followsCursor = new BooleanProperty(true);
    private final DoubleProperty entityScale = new DoubleProperty(1.0);
    @Nullable
    private class_1297 displayEntity;

    public TEntityElement(@NotNull class_1299<?> entityType) {
        this();
        this.entityType.set(entityType, TEntityElement.class);
    }

    public TEntityElement() {
        this.focusableProperty().set(false, TEntityElement.class);
        this.hoverableProperty().set(false, TEntityElement.class);
        this.boundsProperty().addChangeListener((p, o, n) -> {
            if (!o.hasSameSize((Bounds2i)n)) {
                this.refresh();
            }
        });
        this.entityType.addChangeListener((p, o, n) -> this.refresh());
        this.refresh();
    }

    @ApiStatus.Internal
    private final void refresh() {
        try {
            this.displayEntity = EntityProvider.getOrCreate(this.entityType.get());
        }
        catch (Exception e) {
            if (TCDCommonsConfig.FLAG_DEV_ENV) {
                TCDCommons.LOGGER.error("Failed to create GUI entity instance for {}", this.entityType.get(), (Object)e);
            }
            this.displayEntity = null;
        }
    }

    public final NotNullProperty<class_1299<?>> entityTypeProperty() {
        return this.entityType;
    }

    public final BooleanProperty followsCursorProperty() {
        return this.followsCursor;
    }

    public final DoubleProperty entityScaleProperty() {
        return this.entityScale;
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        if (this.displayEntity != null) {
            pencil.pushScissors(bb.x, bb.y, bb.width, bb.height);
            try {
                pencil.renderEntity(this.displayEntity, bb.x, bb.y, bb.width, bb.height, this.entityScale.getD(), this.followsCursor.getZ());
            }
            catch (Exception e) {
                if (TCDCommonsConfig.FLAG_DEV_ENV) {
                    TCDCommons.LOGGER.error("Failed to render GUI Entity {}", (Object)this.displayEntity, (Object)e);
                }
                this.displayEntity = null;
            }
            pencil.popScissors();
        } else {
            pencil.drawMissingNo(bb.x, bb.y, bb.width, bb.height, -1);
        }
    }

    @Nullable
    public final class_1297 getDisplayEntity() {
        return this.displayEntity;
    }

    @ApiStatus.Internal
    public static final class EntityProvider {
        private static final Cache<class_1299<?>, class_1297> CACHE = CacheBuilder.newBuilder().weakValues().build();

        private EntityProvider() {
        }

        @NotNull
        public static final <E extends class_1297> E getOrCreate(@NotNull class_1299<E> entityType) throws NullPointerException, RuntimeException {
            Objects.requireNonNull(entityType);
            try {
                if (entityType == class_1299.field_6097) {
                    return (E)((class_1297)Objects.requireNonNull(class_310.method_1551().field_1724, "Local player instance is not present"));
                }
                return (E)((class_1297)CACHE.get(entityType, () -> Objects.requireNonNull(entityType.method_5883((class_1937)SandboxLevel.INSTANCE, class_3730.field_16471), "Entity creator factory returned 'null'.")));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create entity of type " + String.valueOf(entityType), e);
            }
        }
    }
}

