/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.misc;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.IntegerProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import org.jetbrains.annotations.NotNull;

@Virtual
public class TFillColorElement
extends TElement {
    private final IntegerProperty fillColor = new IntegerProperty();
    private final IntegerProperty outlineColor = new IntegerProperty();

    public TFillColorElement() {
        this(0, 0);
    }

    public TFillColorElement(int fillColor) {
        this(fillColor, 0);
    }

    public TFillColorElement(int fillColor, int outlineColor) {
        this.fillColor.set(fillColor, TFillColorElement.class);
        this.outlineColor.set(outlineColor, TFillColorElement.class);
    }

    public final IntegerProperty fillColorProperty() {
        return this.fillColor;
    }

    public final IntegerProperty outlineColorProperty() {
        return this.outlineColor;
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        int color = this.fillColor.getI();
        if (color != 0) {
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, color);
        }
    }

    @Override
    @Virtual
    public void postRenderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        int color = this.outlineColor.getI();
        if (color != 0) {
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, color);
        }
    }

    @Virtual
    public static class Flat
    extends TFillColorElement {
        public Flat() {
        }

        public Flat(int fillColor) {
            super(fillColor);
        }

        public Flat(int fillColor, int outlineColor) {
            super(fillColor, outlineColor);
        }

        @Override
        @Virtual
        public void postRenderCallback(@NotNull TGuiGraphics pencil) {
        }

        @Override
        @Virtual
        public void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            int fcolor = this.fillColorProperty().getI();
            int ocolor = this.outlineColorProperty().getI();
            if (fcolor != 0) {
                pencil.fillColor(bb.x, bb.y, bb.width, bb.height, fcolor);
            }
            if (ocolor != 0) {
                pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, ocolor);
            }
        }
    }
}

