/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.misc;

import com.thecsdev.common.math.Point2d;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Virtual
public class THoverScrollElement<E extends TElement>
extends TElement {
    private final ObjectProperty<E> target = new ObjectProperty();
    private final NotNullProperty<CompassDirection> direction = new NotNullProperty<CompassDirection>(CompassDirection.SOUTH);

    public THoverScrollElement() {
        this.hoverableProperty().set(true, THoverScrollElement.class);
        this.focusableProperty().set(false, THoverScrollElement.class);
    }

    public THoverScrollElement(@NotNull E target) {
        this();
        this.target.set(target, THoverScrollElement.class);
    }

    @NotNull
    public final ObjectProperty<E> targetProperty() {
        return this.target;
    }

    @NotNull
    public final NotNullProperty<CompassDirection> directionProperty() {
        return this.direction;
    }

    @Override
    @Virtual
    protected void tickCallback() {
        if (this.isHovered()) {
            double dY;
            TElement target = (TElement)this.target.get();
            if (target == null) {
                return;
            }
            class_310 client = this.getClient();
            assert (client != null);
            class_1041 window = client.method_22683();
            double mouseX = client.field_1729.method_68879(window);
            double mouseY = client.field_1729.method_68883(window);
            double dX = switch (this.direction.get()) {
                case CompassDirection.EAST, CompassDirection.NORTH_EAST, CompassDirection.SOUTH_EAST -> 0.3;
                case CompassDirection.WEST, CompassDirection.NORTH_WEST, CompassDirection.SOUTH_WEST -> -0.3;
                default -> 0.0;
            };
            switch (this.direction.get()) {
                case NORTH_EAST: 
                case NORTH_WEST: 
                case NORTH: {
                    double d = 0.3;
                    break;
                }
                case SOUTH_EAST: 
                case SOUTH_WEST: 
                case SOUTH: {
                    double d = -0.3;
                    break;
                }
                default: {
                    double d = dY = 0.0;
                }
            }
            if (dX != 0.0 || dY != 0.0) {
                target.inputCallback(TInputContext.InputDiscoveryPhase.MAIN, TInputContext.ofMouseScroll(mouseX, mouseY, dX, dY));
            }
        }
        if (this.visibleProperty().getZ() != this.shouldBeVisible()) {
            this.visibleProperty().set(!this.visibleProperty().getZ(), THoverScrollElement.class);
        }
    }

    @Virtual
    public boolean shouldBeVisible() {
        return true;
    }

    @Virtual
    public static class Panel
    extends THoverScrollElement<TPanelElement> {
        public Panel() {
        }

        public Panel(@NotNull TPanelElement target) {
            super(target);
        }

        @Override
        @Virtual
        public boolean shouldBeVisible() {
            TPanelElement panel = (TPanelElement)this.targetProperty().get();
            if (panel == null) {
                return false;
            }
            Point2d psa = panel.scrollAmountProperty().get();
            return switch (this.directionProperty().get()) {
                case CompassDirection.NORTH -> {
                    if (psa.y > 0.0) {
                        yield true;
                    }
                    yield false;
                }
                case CompassDirection.SOUTH -> {
                    if (psa.y < 1.0) {
                        yield true;
                    }
                    yield false;
                }
                case CompassDirection.EAST -> {
                    if (psa.x < 1.0) {
                        yield true;
                    }
                    yield false;
                }
                case CompassDirection.WEST -> {
                    if (psa.x > 0.0) {
                        yield true;
                    }
                    yield false;
                }
                case CompassDirection.NORTH_EAST -> {
                    if (psa.y > 0.0 || psa.x < 1.0) {
                        yield true;
                    }
                    yield false;
                }
                case CompassDirection.NORTH_WEST -> {
                    if (psa.y > 0.0 || psa.x > 0.0) {
                        yield true;
                    }
                    yield false;
                }
                case CompassDirection.SOUTH_EAST -> {
                    if (psa.y < 1.0 || psa.x < 1.0) {
                        yield true;
                    }
                    yield false;
                }
                case CompassDirection.SOUTH_WEST -> {
                    if (psa.y < 1.0 || psa.x > 0.0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }
}

