/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.misc;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.IntegerProperty;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TTextureElement
extends TElement {
    private final NotNullProperty<RenderPipeline> renderPipeline = new NotNullProperty<RenderPipeline>(class_10799.field_56883);
    private final NotNullProperty<class_2960> texture = new NotNullProperty<class_2960>(class_1060.field_5285);
    private final NotNullProperty<Mode> mode = new NotNullProperty<Mode>(Mode.TEXTURE);
    private final IntegerProperty color = new IntegerProperty(-1);

    public TTextureElement() {
        this(null);
    }

    public TTextureElement(@Nullable class_2960 texture) {
        if (texture != null) {
            this.texture.getHandle().set(texture);
            this.mode.getHandle().set(texture.method_12832().endsWith(".png") ? Mode.TEXTURE : Mode.GUI_SPRITE);
        }
        this.focusableProperty().set(false, TTextureElement.class);
        this.hoverableProperty().set(false, TTextureElement.class);
    }

    public final NotNullProperty<RenderPipeline> renderPipelineProperty() {
        return this.renderPipeline;
    }

    public final NotNullProperty<class_2960> textureProperty() {
        return this.texture;
    }

    public final NotNullProperty<Mode> modeProperty() {
        return this.mode;
    }

    public final IntegerProperty colorProperty() {
        return this.color;
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
        RenderPipeline pipeline = this.renderPipeline.get();
        class_2960 sprite = this.texture.get();
        int color = this.color.getI();
        Bounds2i bb = this.getBounds();
        switch (this.mode.get().ordinal()) {
            case 0: {
                pencil.drawTexture(pipeline, sprite, bb.x, bb.y, bb.width, bb.height, color);
                break;
            }
            case 1: {
                pencil.drawGuiSprite(pipeline, sprite, bb.x, bb.y, bb.width, bb.height, color);
            }
        }
    }

    public static enum Mode {
        TEXTURE,
        GUI_SPRITE;

    }
}

