/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.panel;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.math.Point2d;
import com.thecsdev.common.properties.IntegerProperty;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import org.jetbrains.annotations.NotNull;

@Virtual
public class TPanelElement
extends TElement {
    public static final int COLOR_BACKGROUND = 0x50000000;
    public static final int COLOR_OUTLINE = 0x50FFFFFF;
    public static final int COLOR_OUTLINE_FOCUSED = -5570561;
    private final NotNullProperty<Point2d> scrollAmount = new NotNullProperty<Point2d>(Point2d.ZERO);
    private final IntegerProperty scrollPadding = new IntegerProperty(0);
    private final IntegerProperty scrollSensitivity = new IntegerProperty(30);
    private double mouseDragX = 0.0;
    private double mouseDragY = 0.0;

    public TPanelElement() {
        this.focusableProperty().set(true, TPanelElement.class);
        this.scrollAmount.addFilter(Point2d::clamp01, TPanelElement.class);
        this.scrollAmount.addChangeListener((p, o, n) -> {
            Bounds2i ccb = this.getContentBounds();
            Bounds2i ncb = this.computeContentBoundsFromScrollAmount();
            this.moveChildren(ncb.x - ccb.x, ncb.y - ccb.y);
        });
    }

    public NotNullProperty<Point2d> scrollAmountProperty() {
        return this.scrollAmount;
    }

    public final IntegerProperty scrollPaddingProperty() {
        return this.scrollPadding;
    }

    public final IntegerProperty scrollSensitivityProperty() {
        return this.scrollSensitivity;
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.fillColor(bb.x, bb.y, bb.width, bb.height, 0x50000000);
    }

    @Override
    @Virtual
    public void postRenderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        if (this.isFocused()) {
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, -5570561);
        } else {
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, 0x50FFFFFF);
        }
    }

    @Override
    @Virtual
    public boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) {
        if (phase != TInputContext.InputDiscoveryPhase.MAIN) {
            return false;
        }
        switch (context.getInputType()) {
            case MOUSE_PRESS: {
                return (context.getMouseButton() == 0 || context.getMouseButton() == 2) && this.isFocusable();
            }
            case MOUSE_SCROLL: {
                int s = this.scrollSensitivity.getI();
                this.scroll((int)(-context.getScrollX().doubleValue() * (double)s), (int)(context.getScrollY() * (double)s));
                return true;
            }
            case MOUSE_DRAG: {
                this.mouseDragX += context.getMouseDeltaX().doubleValue();
                this.mouseDragY += context.getMouseDeltaY().doubleValue();
                int dX = (int)this.mouseDragX;
                int dY = (int)this.mouseDragY;
                if (dX == 0 && dY == 0) {
                    return false;
                }
                this.mouseDragX -= (double)dX;
                this.mouseDragY -= (double)dY;
                this.scroll(dX, dY);
                return true;
            }
            case MOUSE_RELEASE: {
                this.mouseDragY = 0.0;
                this.mouseDragX = 0.0;
                return true;
            }
            case KEY_PRESS: {
                if (!this.isFocused()) break;
                int s = this.scrollSensitivity.getI();
                int dX = 0;
                int dY = 0;
                switch (context.getKeyCode()) {
                    case 265: {
                        dY += s;
                        break;
                    }
                    case 264: {
                        dY -= s;
                        break;
                    }
                    case 263: {
                        dX += s;
                        break;
                    }
                    case 262: {
                        dX -= s;
                        break;
                    }
                }
                if (dX == 0 && dY == 0) break;
                this.scroll(dX, dY);
                return true;
            }
        }
        return false;
    }

    private final Bounds2i computeContentBoundsFromScrollAmount() {
        Bounds2i bb = this.getBounds();
        Bounds2i cbb = this.getContentBounds();
        Point2d sa = this.scrollAmount.get();
        int sp = this.scrollPadding.getI();
        double maxScrollX = Math.max(0, cbb.width - (bb.width - 2 * sp));
        double maxScrollY = Math.max(0, cbb.height - (bb.height - 2 * sp));
        int newX = (int)((double)(bb.x + sp) - sa.x * maxScrollX);
        int newY = (int)((double)(bb.y + sp) - sa.y * maxScrollY);
        return new Bounds2i(newX, newY, cbb.width, cbb.height);
    }

    private final Point2d computeScrollAmountFromContentBounds() {
        Bounds2i bb = this.getBounds();
        Bounds2i cbb = this.getContentBounds();
        int sp = this.scrollPadding.getI();
        double maxScrollX = Math.max(0, cbb.width - (bb.width - 2 * sp));
        double maxScrollY = Math.max(0, cbb.height - (bb.height - 2 * sp));
        double offsetX = bb.x + sp - cbb.x;
        double offsetY = bb.y + sp - cbb.y;
        double scrollAmountX = maxScrollX > 0.0 ? offsetX / maxScrollX : 0.0;
        double scrollAmountY = maxScrollY > 0.0 ? offsetY / maxScrollY : 0.0;
        double clampedX = Math.max(0.0, Math.min(1.0, scrollAmountX));
        double clampedY = Math.max(0.0, Math.min(1.0, scrollAmountY));
        return new Point2d(clampedX, clampedY);
    }

    public final void scroll(int deltaX, int deltaY) {
        this.moveChildren(deltaX, deltaY);
        this.scrollAmount.set(this.computeScrollAmountFromContentBounds(), TPanelElement.class);
        Bounds2i old_cbb = this.getContentBounds();
        Bounds2i new_cbb = this.computeContentBoundsFromScrollAmount();
        this.moveChildren(new_cbb.x - old_cbb.x, new_cbb.y - old_cbb.y);
    }

    @NotNull
    public final Bounds2i computeNextYBounds(int height, int gap) {
        Bounds2i bb = this.getBounds();
        Bounds2i cbb = this.getContentBounds();
        int pad = this.scrollPaddingProperty().getI();
        return new Bounds2i(bb.x + pad, this.isEmpty() ? bb.y + pad : cbb.endY + gap, bb.width - pad * 2, height);
    }

    public final void addAllVertically(@NotNull Iterable<TElement> elements, int gap) throws NullPointerException {
        for (TElement el : elements) {
            el.setBounds(this.computeNextYBounds(el.getBounds().height, gap));
            this.add(el);
        }
    }

    @Virtual
    public static class Paintable
    extends TPanelElement {
        private final IntegerProperty background = new IntegerProperty(0x50000000);
        private final IntegerProperty outline = new IntegerProperty(0x50FFFFFF);
        private final IntegerProperty outlineFocused = new IntegerProperty(-5570561);

        public Paintable() {
        }

        public Paintable(int backgroundColor, int outlineColor, int focusOutlineColor) {
            this.background.set(backgroundColor, Paintable.class);
            this.outline.set(outlineColor, Paintable.class);
            this.outlineFocused.set(focusOutlineColor, Paintable.class);
        }

        public final IntegerProperty backgroundColorProperty() {
            return this.background;
        }

        public final IntegerProperty outlineColorProperty() {
            return this.outline;
        }

        public final IntegerProperty focusedOutlineColorProperty() {
            return this.outlineFocused;
        }

        @Override
        @Virtual
        public void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, this.background.getI());
        }

        @Override
        @Virtual
        public void postRenderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, this.isFocused() ? this.outlineFocused.getI() : this.outline.getI());
        }
    }

    @Virtual
    public static class Transparent
    extends TPanelElement {
        @Override
        @Virtual
        public void postRenderCallback(@NotNull TGuiGraphics pencil) {
        }

        @Override
        @Virtual
        public void renderCallback(@NotNull TGuiGraphics pencil) {
        }
    }
}

