/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.panel.window;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.BooleanProperty;
import com.thecsdev.common.properties.IntegerProperty;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.label.TLabelElement;
import com.thecsdev.commonmc.api.client.gui.misc.TFillColorElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.screen.TScreen;
import com.thecsdev.commonmc.api.client.gui.util.CursorType;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.api.client.gui.widget.TButtonWidget;
import com.thecsdev.commonmc.resources.TComponent;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public abstract class TWindowElement
extends TElement {
    private final NotNullProperty<class_2561> title = new NotNullProperty<class_5250>(TComponent.missingNo().method_27693(" -"));
    private final NotNullProperty<CloseOperation> closeOperation = new NotNullProperty<CloseOperation>(CloseOperation.DO_NOTHING);
    private final BooleanProperty maximized = new BooleanProperty(false);
    private final NotNullProperty<Bounds2i> restoredBounds = new NotNullProperty<Bounds2i>(new Bounds2i(0, 0, 400, 300));
    private final IntegerProperty backgroundColor = new IntegerProperty(-1);
    private double dragDeltaX = 0.0;
    private double dragDeltaY = 0.0;

    public TWindowElement() {
        this.focusableProperty().set(true, TWindowElement.class);
        this.title.addChangeListener((p, o, n) -> this.findChild(c -> c instanceof TitlebarElement, false).ifPresent(c -> ((TitlebarElement)c).lbl_title.setText((class_2561)n)));
        this.maximized.addChangeListener((p, o, n) -> {
            if (n.booleanValue()) {
                this.restoredBounds.set(this.getBounds(), TWindowElement.class);
            }
            TElement parent = (TElement)this.getParent();
            this.setBounds(n != false && parent != null ? ((TElement)this.getParent()).getBounds() : this.restoredBounds.get());
            this.clearAndInit();
        });
    }

    public final NotNullProperty<class_2561> titleProperty() {
        return this.title;
    }

    public final NotNullProperty<CloseOperation> closeOperationProperty() {
        return this.closeOperation;
    }

    public final BooleanProperty maximizedProperty() {
        return this.maximized;
    }

    public final NotNullProperty<Bounds2i> restoredBoundsProperty() {
        return this.restoredBounds;
    }

    public final IntegerProperty backgroundColorProperty() {
        return this.backgroundColor;
    }

    @Override
    protected final void initCallback() {
        Bounds2i bb = this.getBounds();
        TitlebarElement el_title = new TitlebarElement();
        el_title.setBounds(bb.height(15));
        this.add(el_title);
        TFillColorElement.Flat el_body = new TFillColorElement.Flat(0, 0x33888888);
        el_body.setBounds(bb.x, bb.y + 15, bb.width, bb.height - 15);
        this.add(el_body);
        this.initBodyCallback(el_body);
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.drawShadow(bb.x, bb.y, bb.width, bb.height, 0, 0, 5, 1, 0x10000000, false);
        pencil.fillColor(bb.x, bb.y, bb.width, bb.height, this.backgroundColor.getI());
    }

    @Override
    public final void postRenderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.drawOutlineOut(bb.x, bb.y, bb.width, bb.height, -16777216);
    }

    @Override
    public final boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) throws NullPointerException {
        if (phase != TInputContext.InputDiscoveryPhase.MAIN) {
            return false;
        }
        return switch (context.getInputType()) {
            case TInputContext.InputType.MOUSE_PRESS -> {
                if (context.getMouseButton() == 0) {
                    yield true;
                }
                yield false;
            }
            case TInputContext.InputType.MOUSE_RELEASE -> {
                if (context.getMouseButton() != 0) {
                    yield false;
                }
                this.dragDeltaY = 0.0;
                this.dragDeltaX = 0.0;
                TGuiUtils.keepElementWithinBounds(this, ((TElement)this.getParent()).getBounds());
                yield true;
            }
            case TInputContext.InputType.MOUSE_DRAG -> {
                this.dragDeltaX += context.getMouseDeltaX().doubleValue();
                this.dragDeltaY += context.getMouseDeltaY().doubleValue();
                int dX = (int)this.dragDeltaX;
                int dY = (int)this.dragDeltaY;
                if (dX == 0 && dY == 0) {
                    yield true;
                }
                this.dragDeltaX -= (double)dX;
                this.dragDeltaY -= (double)dY;
                this.move(dX, dY);
                yield true;
            }
            default -> false;
        };
    }

    protected abstract void initBodyCallback(@NotNull TElement var1);

    public final void close() {
        switch (this.closeOperation.get().ordinal()) {
            case 2: {
                this.remove();
                break;
            }
            case 1: {
                this.visibleProperty().set(false, TWindowElement.class);
                break;
            }
            case 3: {
                this.screenProperty().getOptional().ifPresent(TScreen::close);
                break;
            }
        }
    }

    public static enum CloseOperation {
        DO_NOTHING,
        HIDE,
        DISPOSE,
        CLOSE_SCREEN;

    }

    private final class TitlebarElement
    extends TElement {
        final TLabelElement lbl_title = new TLabelElement();
        final TButtonWidget.Paintable btn_close = new TButtonWidget.Paintable(-65536, 0, -1);
        final TButtonWidget.Paintable btn_maximize = new TButtonWidget.Paintable(0x66888888, 0, -1);

        TitlebarElement() {
            this.lbl_title.textScaleProperty().set(0.8, TitlebarElement.class);
            this.btn_close.getLabel().setText((class_2561)class_2561.method_43470((String)"X"));
            this.btn_close.getLabel().textScaleProperty().set(0.8, TitlebarElement.class);
            this.btn_maximize.getLabel().setText((class_2561)class_2561.method_43470((String)"\u25a0"));
            this.btn_maximize.getLabel().textScaleProperty().set(0.8, TitlebarElement.class);
        }

        @Override
        @Virtual
        @NotNull
        public CursorType getCursor() {
            return CursorType.RESIZE_ALL;
        }

        @Override
        protected final void initCallback() {
            Bounds2i bb = this.getBounds();
            this.lbl_title.setBounds(bb.add(4, 0, -8, 0));
            this.lbl_title.setText(TWindowElement.this.title.get());
            this.add(this.lbl_title);
            this.btn_maximize.setBounds(bb.width - 40, 0, 20, 15);
            this.btn_maximize.eClicked.register(__ -> TWindowElement.this.maximized.toggle());
            this.addRel(this.btn_maximize);
            this.btn_close.setBounds(bb.width - 20, 0, 20, 15);
            this.btn_close.eClicked.register(__ -> TWindowElement.this.close());
            this.addRel(this.btn_close);
        }
    }
}

