/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphicsDefault;
import com.thecsdev.commonmc.api.client.gui.screen.TScreen;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.client.mixin.hooks.AccessorDrawContext;
import com.thecsdev.commonmc.client.mixin.hooks.AccessorGuiRenderer;
import com.thecsdev.commonmc.resources.TCDCSprites;
import java.util.Objects;
import net.minecraft.class_10017;
import net.minecraft.class_1041;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11875;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class TGuiGraphics {
    private final class_332 drawContext;
    private final class_310 client;
    private final Matrix3x2fStack matrices;
    private final class_4597.class_4598 bufferSource;
    private final int mouseX;
    private final int mouseY;
    private final float deltaTicks;
    private final int screenW;
    private final int screenH;
    @Nullable
    private TElement currentElement;

    @ApiStatus.Internal
    public static final TGuiGraphics createInstance(@NotNull class_332 drawContext, int mouseX, int mouseY, float deltaTicks) {
        return new TGuiGraphicsDefault(drawContext, mouseX, mouseY, deltaTicks);
    }

    protected TGuiGraphics(class_332 drawContext, int mouseX, int mouseY, float deltaTicks) {
        AccessorDrawContext aDrawContext = (AccessorDrawContext)Objects.requireNonNull(drawContext);
        this.drawContext = drawContext;
        this.client = aDrawContext.getClient();
        this.matrices = aDrawContext.getMatrices();
        this.bufferSource = ((AccessorGuiRenderer)TGuiUtils.getGuiRenderer(aDrawContext.getClient())).getVertexConsumers();
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.deltaTicks = deltaTicks;
        class_1041 window = this.client.method_22683();
        this.screenW = window.method_4486();
        this.screenH = window.method_4502();
    }

    @ApiStatus.Experimental
    public final class_332 getNative() {
        return this.drawContext;
    }

    @ApiStatus.Experimental
    public final class_310 getNativeClient() {
        return this.client;
    }

    @ApiStatus.Experimental
    public final class_4597.class_4598 getNativeBufferSource() {
        return this.bufferSource;
    }

    @ApiStatus.Experimental
    public final Matrix3x2fStack getNativeMatrices() {
        return this.matrices;
    }

    public final int getMouseX() {
        return this.mouseX;
    }

    public final int getMouseY() {
        return this.mouseY;
    }

    public final float getDeltaTicks() {
        return this.deltaTicks;
    }

    public final int getScreenWidth() {
        return this.screenW;
    }

    public final int getScreenHeight() {
        return this.screenH;
    }

    @Nullable
    public final TElement getCurrentElement() {
        return this.currentElement;
    }

    public final void pushScissors(int x, int y, int width, int height) {
        this.drawContext.method_44379(x, y, x + width, y + height);
    }

    public final void popScissors() throws IllegalStateException {
        this.drawContext.method_44380();
    }

    @Virtual
    public void drawMissingNo(int x, int y, int width, int height, int color) {
        this.drawGuiSprite(class_1060.field_5285, x, y, width, height, color);
    }

    @Virtual
    public void drawShadow(int x, int y, int width, int height, int offsetX, int offsetY, int blurRadius, int spreadRadius, int color, boolean inset) {
        if (inset) {
            for (int i = 0; i < blurRadius; ++i) {
                int offset = i + 1 + Math.max(spreadRadius, 0);
                if (width - offset * 2 <= 0 || height - offset * 2 <= 0) continue;
                this.drawGuiSprite(TCDCSprites.gui_popup_shadow(), x + offset + offsetX, y + offset + offsetY, width - offset * 2, height - offset * 2, color);
            }
        } else {
            for (int i = 0; i < blurRadius; ++i) {
                int offset = i + 1;
                int currentSpread = offset + Math.max(spreadRadius, 0);
                this.drawGuiSprite(TCDCSprites.gui_popup_shadow(), x - currentSpread + offsetX, y - currentSpread + offsetY, width + currentSpread * 2, height + currentSpread * 2, color);
            }
        }
    }

    public abstract void fillColor(int var1, int var2, int var3, int var4, int var5);

    @Virtual
    public void drawOutlineIn(int x, int y, int width, int height, int color) {
        this.fillColor(x, y, width, 1, color);
        this.fillColor(x, y + 1, 1, height - 2, color);
        this.fillColor(x + width - 1, y + 1, 1, height - 2, color);
        this.fillColor(x, y + height - 1, width, 1, color);
    }

    @Virtual
    public void drawOutlineOut(int x, int y, int width, int height, int color) {
        this.fillColor(x - 1, y - 1, width + 2, 1, color);
        this.fillColor(x - 1, y, 1, height, color);
        this.fillColor(x + width, y, 1, height, color);
        this.fillColor(x - 1, y + height, width + 2, 1, color);
    }

    public final void drawTexture(@NotNull class_2960 id, int x, int y, int width, int height, int color) {
        this.drawTexture(class_10799.field_56883, id, x, y, width, height, color);
    }

    public final void drawTexture(@NotNull class_2960 id, int x, int y, int width, int height, float uvX, float uvY, int uvWidth, int uvHeight, int textureWidth, int textureHeight, int color) {
        this.drawTexture(class_10799.field_56883, id, x, y, width, height, uvX, uvY, uvWidth, uvHeight, textureWidth, textureHeight, color);
    }

    public final void drawTexture(@NotNull RenderPipeline renderPipeline, @NotNull class_2960 id, int x, int y, int width, int height, int color) {
        this.drawTexture(renderPipeline, id, x, y, width, height, 0.0f, 0.0f, 1, 1, 1, 1, color);
    }

    public abstract void drawTexture(@NotNull RenderPipeline var1, @NotNull class_2960 var2, int var3, int var4, int var5, int var6, float var7, float var8, int var9, int var10, int var11, int var12, int var13);

    public final void drawGuiSprite(@NotNull class_2960 id, int x, int y, int width, int height, int color) {
        this.drawGuiSprite(class_10799.field_56883, id, x, y, width, height, color);
    }

    public abstract void drawGuiSprite(@NotNull RenderPipeline var1, @NotNull class_2960 var2, int var3, int var4, int var5, int var6, int var7);

    public final void draw9SlicedTexture(@NotNull class_2960 id, int x, int y, int width, int height, float u, float v, int uvWidth, int uvHeight, int textureWidth, int textureHeight, int color, int sliceSize) {
        this.draw9SlicedTexture(class_10799.field_56883, id, x, y, width, height, u, v, uvWidth, uvHeight, textureWidth, textureHeight, color, sliceSize);
    }

    public final void drawRepeatingTexture(@NotNull class_2960 id, int x, int y, int width, int height, float u, float v, int uvWidth, int uvHeight, int textureWidth, int textureHeight, int color) {
        this.drawRepeatingTexture(class_10799.field_56883, id, x, y, width, height, u, v, uvWidth, uvHeight, textureWidth, textureHeight, color);
    }

    public final void draw9SlicedTexture(@NotNull RenderPipeline renderPipeline, @NotNull class_2960 id, int x, int y, int width, int height, float u, float v, int uvWidth, int uvHeight, int textureWidth, int textureHeight, int color, int sliceSize) {
        int s2 = sliceSize * 2;
        if (s2 < width || s2 < height) {
            this.drawTexture(renderPipeline, id, x, y, sliceSize, sliceSize, u, v, sliceSize, sliceSize, textureWidth, textureHeight, color);
            this.drawTexture(renderPipeline, id, x + width - sliceSize, y, sliceSize, sliceSize, u + (float)uvWidth - (float)sliceSize, v, sliceSize, sliceSize, textureWidth, textureHeight, color);
            this.drawTexture(renderPipeline, id, x, y + height - sliceSize, sliceSize, sliceSize, u, v + (float)uvHeight - (float)sliceSize, sliceSize, sliceSize, textureWidth, textureHeight, color);
            this.drawTexture(renderPipeline, id, x + width - sliceSize, y + height - sliceSize, sliceSize, sliceSize, u + (float)uvWidth - (float)sliceSize, v + (float)uvHeight - (float)sliceSize, sliceSize, sliceSize, textureWidth, textureHeight, color);
            this.drawTexture(renderPipeline, id, x + sliceSize, y, width - s2, sliceSize, u + (float)sliceSize, v, uvWidth - s2, sliceSize, textureWidth, textureHeight, color);
            this.drawTexture(renderPipeline, id, x, y + sliceSize, sliceSize, height - s2, u, v + (float)sliceSize, sliceSize, uvHeight - s2, textureWidth, textureHeight, color);
            this.drawTexture(renderPipeline, id, x + width - sliceSize, y + sliceSize, sliceSize, height - s2, u + (float)uvWidth - (float)sliceSize, v + (float)sliceSize, sliceSize, uvHeight - s2, textureWidth, textureHeight, color);
            this.drawTexture(renderPipeline, id, x + sliceSize, y + height - sliceSize, width - s2, sliceSize, u + (float)sliceSize, v + (float)uvHeight - (float)sliceSize, uvWidth - s2, sliceSize, textureWidth, textureHeight, color);
            this.drawRepeatingTexture(renderPipeline, id, x + sliceSize, y + sliceSize, width - s2, height - s2, u + (float)sliceSize, v + (float)sliceSize, uvWidth - s2, uvHeight - s2, textureWidth, textureHeight, color);
        } else {
            this.drawTexture(renderPipeline, id, x, y, width, height, u, v, uvWidth, uvHeight, textureWidth, textureHeight, color);
        }
    }

    public final void drawRepeatingTexture(@NotNull RenderPipeline renderPipeline, @NotNull class_2960 id, int x, int y, int width, int height, float u, float v, int uvWidth, int uvHeight, int textureWidth, int textureHeight, int color) {
        int endX = x + width;
        int endY = y + height;
        for (int y1 = y; y1 < endY; y1 += uvHeight) {
            for (int x1 = x; x1 < endX; x1 += uvWidth) {
                int nextW = uvWidth;
                int nextH = uvHeight;
                if (x1 + nextW > endX) {
                    nextW -= x1 + nextW - endX;
                }
                if (y1 + nextH > endY) {
                    nextH -= y1 + nextH - endY;
                }
                if (nextW < 1 || nextH < 1) continue;
                this.drawTexture(renderPipeline, id, x1, y1, nextW, nextH, u, v, nextW, nextH, textureWidth, textureHeight, color);
            }
        }
    }

    public abstract void drawButton(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    public abstract void drawCheckbox(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7, boolean var8);

    @Virtual
    public void renderItem(@NotNull class_1799 item, int x, int y, int width, int height) {
        Matrix3x2fStack mat = this.getNativeMatrices();
        mat.pushMatrix();
        mat.translate((float)x, (float)y);
        mat.scale((float)width / 16.0f, (float)height / 16.0f);
        this.getNative().method_51445(item, 0, 0);
        mat.popMatrix();
    }

    @ApiStatus.Internal
    private static final int computeEntitySize(@NotNull class_1297 entity, int viewportW, int viewportH) {
        float modelHeight;
        int maxSize = Math.min(viewportW, viewportH);
        if (maxSize == 0) {
            return 5;
        }
        float modelWidth = entity.method_5864().method_17685();
        double hypotenuse = Math.sqrt(modelWidth * modelWidth + (modelHeight = entity.method_5864().method_17686()) * modelHeight);
        if (hypotenuse == 0.0) {
            hypotenuse = 0.1;
        }
        int result = (int)((double)maxSize / hypotenuse);
        return Math.max(result, 5);
    }

    @Virtual
    public void renderEntity(@NotNull class_1297 entity, int x, int y, int width, int height, double scale, boolean followsCursor) throws Exception {
        Objects.requireNonNull(entity);
        if (width == 0 || height == 0) {
            return;
        }
        this.renderEntityInInventoryFollowsMouse(x, y, x + width, y + height, (int)((double)TGuiGraphics.computeEntitySize(entity, width, height) * scale), followsCursor ? (float)this.getMouseX() : (float)(x + width), followsCursor ? (float)this.getMouseY() : (float)(y + height), entity);
    }

    @ApiStatus.Internal
    private final void renderEntityInInventoryFollowsMouse(int x1, int y1, int x2, int y2, int size, float mouseX, float mouseY, @NotNull class_1297 entity) {
        class_1309 livingEntity;
        class_1309 le = entity instanceof class_1309 ? (livingEntity = (class_1309)entity) : null;
        float n = (float)(x1 + x2) / 2.0f;
        float o = (float)(y1 + y2) / 2.0f;
        float p = (float)Math.atan((n - mouseX) / 40.0f);
        float q = (float)Math.atan((o - mouseY) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(q * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float old_yRot = entity.method_36454();
        float old_xRot = entity.method_36455();
        float old_yBodyRot = 0.0f;
        float old_yHeadRot0 = 0.0f;
        float old_yHeadRot = 0.0f;
        if (le != null) {
            old_yBodyRot = le.field_6283;
            old_yHeadRot0 = le.field_6259;
            old_yHeadRot = le.field_6241;
        }
        entity.method_36456(180.0f + p * 40.0f);
        entity.method_36457(-q * 20.0f);
        if (le != null) {
            le.field_6283 = 180.0f + p * 20.0f;
            le.field_6241 = entity.method_36454();
            le.field_6259 = entity.method_36454();
        }
        float w = le != null ? le.method_55693() : 1.0f;
        Vector3f vector3f = new Vector3f(0.0f, entity.method_17682() / 2.0f + 0.03125f * w, 0.0f);
        float nextScale = (float)size / w;
        this.renderEntityInInventory(x1, y1, x2, y2, nextScale, vector3f, quaternionf, quaternionf2, entity);
        entity.method_36456(old_yRot);
        entity.method_36457(old_xRot);
        if (le != null) {
            le.field_6283 = old_yBodyRot;
            le.field_6259 = old_yHeadRot0;
            le.field_6241 = old_yHeadRot;
        }
    }

    @ApiStatus.Internal
    private final void renderEntityInInventory(int x1, int y1, int x2, int y2, float scale, @NotNull Vector3f translation, @NotNull Quaternionf rotation, @Nullable Quaternionf overrideCameraAngle, @NotNull class_1297 entity) {
        class_898 entityRenderDispatcher = this.getNativeClient().method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953(entity);
        if (entityRenderer == null) {
            return;
        }
        class_10017 entityRenderState = entityRenderer.method_62425(entity, 1.0f);
        entityRenderState.field_61820 = 0xF000F0;
        entityRenderState.field_61823.clear();
        entityRenderState.field_61821 = 0;
        this.getNative().method_70856(entityRenderState, scale, translation, rotation, overrideCameraAngle, x1, y1, x2, y2);
    }

    @ApiStatus.Internal
    public final void renderTScreen(@NotNull TScreen screen) {
        this.renderTElement(screen, screen);
        TElement focus = screen.focusedElementProperty().get();
        TElement hover = screen.hoveredElementProperty().get();
        this.renderTooltip(focus);
        if (focus != hover) {
            this.renderTooltip(hover);
        }
        this.getNative().method_74037(hover != null ? hover.getCursor().getNative() : class_11875.field_62449);
    }

    @ApiStatus.Internal
    private final void renderTElement(@NotNull TElement element, TScreen expectedScreen) {
        assert (element.screenProperty().get() == expectedScreen || element == expectedScreen || expectedScreen == null) : "Illegal " + TScreen.class.getSimpleName() + " value for " + String.valueOf(element) + ". Expected " + String.valueOf(expectedScreen) + ", got " + String.valueOf(element.screenProperty().get()) + ".";
        if (!((Boolean)element.visibleProperty().get()).booleanValue()) {
            return;
        }
        Bounds2i elBB = element.getBounds();
        if (elBB.isEmpty || elBB.x > this.screenW || elBB.y > this.screenH || elBB.endX < 0 || elBB.endY < 0) {
            return;
        }
        TElement lastCurrentElement = this.currentElement;
        this.currentElement = element;
        element.renderCallback(this);
        boolean clips = (Boolean)element.clipsDescendantsProperty().get();
        if (clips) {
            this.pushScissors(elBB.x, elBB.y, elBB.width, elBB.height);
        }
        for (TElement child : element) {
            this.renderTElement(child, expectedScreen);
        }
        if (clips) {
            this.popScissors();
        }
        this.currentElement = element;
        element.postRenderCallback(this);
        this.currentElement = lastCurrentElement;
    }

    @ApiStatus.Internal
    private final void renderTooltip(@Nullable TElement element) {
        if (element == null || !element.isVisible()) {
            return;
        }
        TElement root = (TElement)element.rootProperty().get();
        TElement tooltip = element.getTooltip();
        if (tooltip == null) {
            return;
        }
        Bounds2i screenBounds = root.getBounds();
        Bounds2i elementBounds = element.getBounds();
        Bounds2i tooltipBounds = tooltip.getBounds();
        Matrix3x2fStack matrices = this.getNativeMatrices();
        matrices.pushMatrix();
        matrices.translate((float)(-tooltipBounds.x), (float)(-tooltipBounds.y));
        if (element.isFocused()) {
            int offsetX = elementBounds.x;
            int offsetY = elementBounds.endY + 1;
            if (offsetX + tooltipBounds.width > screenBounds.endX) {
                offsetX = elementBounds.endX - tooltipBounds.width;
            }
            if (offsetY + tooltipBounds.height > screenBounds.endY) {
                offsetY = elementBounds.y - tooltipBounds.height - 1;
            }
            matrices.translate((float)offsetX, (float)offsetY);
        } else {
            int offsetX = this.mouseX + 8;
            int offsetY = this.mouseY;
            if (offsetX + tooltipBounds.width > screenBounds.endX) {
                offsetX = this.mouseX - tooltipBounds.width - 1;
            }
            if (offsetY + tooltipBounds.height > screenBounds.endY) {
                offsetY = this.mouseY - tooltipBounds.height - 1;
            }
            matrices.translate((float)offsetX, (float)offsetY);
        }
        this.renderTElement(tooltip, null);
        matrices.popMatrix();
    }
}

