/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.screen;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.math.UDim2;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.ctxmenu.TContextMenu;
import com.thecsdev.commonmc.api.client.gui.label.TLabelElement;
import com.thecsdev.commonmc.api.client.gui.misc.TFillColorElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.panel.window.TWindowElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.screen.ILastScreenProvider;
import com.thecsdev.commonmc.api.client.gui.screen.TScreenPlus;
import com.thecsdev.commonmc.api.client.gui.screen.TTextDialogScreen;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.api.client.gui.widget.TButtonWidget;
import com.thecsdev.commonmc.api.client.gui.widget.TDropdownWidget;
import com.thecsdev.commonmc.api.client.gui.widget.TScrollBarWidget;
import com.thecsdev.commonmc.api.client.gui.widget.text.TSimpleTextFieldWidget;
import com.thecsdev.commonmc.resources.TCDCLang;
import com.thecsdev.commonmc.resources.TCDCSprites;
import com.thecsdev.commonmc.resources.TComponent;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TFileChooserScreen
extends TScreenPlus
implements ILastScreenProvider {
    @Nullable
    private final class_437 lastScreen;
    @NotNull
    private final Mode mode;
    @NotNull
    private final List<FileFilter> fileFilters;
    @NotNull
    private final BiConsumer<Result, File> onResult;
    @Nullable
    private FileFilter currFileFilter;
    @NotNull
    private File history_currDir;
    @NotNull
    private final Deque<File> history_back = new LinkedList<File>();
    @NotNull
    private final Deque<File> history_fwd = new LinkedList<File>();
    private boolean output_invoked = false;
    @NotNull
    private Result output_result = Result.ERROR;
    @NotNull
    private final ObjectProperty<File> output_file = new ObjectProperty<Object>(null);

    private TFileChooserScreen(@Nullable class_437 lastScreen, @NotNull Mode mode, @NotNull File currDir, @NotNull List<FileFilter> fileFilters, @NotNull BiConsumer<Result, File> onResult) throws NullPointerException {
        super(Objects.requireNonNull(mode).getWindowTitle());
        this.lastScreen = lastScreen;
        this.mode = mode;
        this.history_currDir = Objects.requireNonNull(currDir);
        this.fileFilters = Objects.requireNonNull(fileFilters);
        this.onResult = Objects.requireNonNull(onResult);
        if (!this.fileFilters.isEmpty()) {
            this.currFileFilter = fileFilters.getFirst();
        }
        this.output_file.addFilter(file -> {
            String newName;
            if (file == null || file.getParentFile() == null) {
                return null;
            }
            if (this.currFileFilter != null && (newName = this.currFileFilter.postProcessFilename(file.getName())).equals(file.getName())) {
                file = new File(file.getParentFile(), newName);
            }
            return file;
        }, TFileChooserScreen.class);
        this.output_file.addChangeListener((p, o, n) -> this.findChild(c -> c instanceof ActionPanel, true).ifPresent(c -> ((ActionPanel)c).in_filename.textProperty().set(n != null ? n.getName() : "", TFileChooserScreen.class)));
        this.output_file.setOwner(TFileChooserScreen.class, TFileChooserScreen.class);
    }

    @Override
    @Nullable
    public final class_437 getLastScreen() {
        return this.lastScreen;
    }

    @Override
    public final void renderCallback(@NotNull TGuiGraphics pencil) {
        if (this.lastScreen != null) {
            this.lastScreen.method_25394(pencil.getNative(), pencil.getMouseX(), pencil.getMouseY(), pencil.getDeltaTicks());
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, 0x22FFFFFF);
        }
    }

    @Override
    protected final void initCallback() {
        if (this.output_invoked) {
            this.close();
            return;
        }
        WindowElement wnd = new WindowElement();
        this.add(wnd);
        wnd.setBounds(new UDim2(0.1, 0.0, 0.1, 0.0), new UDim2(0.8, 0.0, 0.8, 0.0));
    }

    @Override
    public final boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) {
        if (super.inputCallback(phase, context)) {
            return true;
        }
        if (phase != TInputContext.InputDiscoveryPhase.MAIN) {
            return false;
        }
        if (context.getInputType() == TInputContext.InputType.KEY_PRESS && context.getKeyCode() == 256) {
            this.output_result = Result.CANCEL;
            this.output_file.set(null, TFileChooserScreen.class);
            this.close();
            return true;
        }
        return false;
    }

    @Override
    protected final void closeCallback() {
        if (this.output_invoked) {
            return;
        }
        this.output_invoked = true;
        if (this.output_result != Result.APPROVE) {
            this.output_file.set(null, TFileChooserScreen.class);
        } else if (this.output_file.get() == null) {
            this.output_result = Result.ERROR;
        }
        try {
            this.onResult.accept(this.output_result, this.output_file.get());
        }
        catch (Exception exc) {
            class_310 client = Objects.requireNonNull(this.getClient(), "Missing 'client' instance");
            String message = ExceptionUtils.getStackTrace((Throwable)exc).replace("\r\n", "\n").replace("\t", "    ");
            client.method_63588(() -> {
                TTextDialogScreen screen = new TTextDialogScreen(client.field_1755, (class_2561)TComponent.gui("icon/unseen_notification").method_27693(" ").method_10852((class_2561)TCDCLang.gui_screen_textDialog_errorTitle()), (class_2561)class_2561.method_43470((String)message));
                screen.getMessageLabel().wrapTextProperty().set(false, TFileChooserScreen.class);
                client.method_1507(screen.getAsScreen());
            });
        }
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    @NotNull
    public final File getCurrentDirectory() {
        return this.history_currDir;
    }

    public final void refresh() {
        if (!this.isOpen()) {
            return;
        }
        this.findChild(c -> c instanceof WindowElement, false).ifPresent(TElement::clearAndInit);
    }

    public final void navigateTo(@NotNull File directory) throws NullPointerException {
        this.output_file.set(null, TFileChooserScreen.class);
        this.history_back.push(this.history_currDir);
        this.history_currDir = Objects.requireNonNull(directory);
        while (this.history_back.size() > 32) {
            this.history_back.removeLast();
        }
        this.history_fwd.clear();
        this.refresh();
    }

    public final boolean navigateBack() {
        this.output_file.set(null, TFileChooserScreen.class);
        if (this.history_back.isEmpty()) {
            return false;
        }
        this.history_fwd.push(this.history_currDir);
        this.history_currDir = this.history_back.pop();
        while (this.history_fwd.size() > 32) {
            this.history_fwd.removeLast();
        }
        this.refresh();
        return true;
    }

    public final boolean navigateForward() {
        this.output_file.set(null, TFileChooserScreen.class);
        if (this.history_fwd.isEmpty()) {
            return false;
        }
        this.history_back.push(this.history_currDir);
        this.history_currDir = this.history_fwd.pop();
        while (this.history_back.size() > 32) {
            this.history_back.removeLast();
        }
        this.refresh();
        return true;
    }

    public static enum Mode {
        EXPLORE((class_2561)TComponent.gui(TCDCSprites.gui_icon_fsFolder()).method_27693(" ").method_10852((class_2561)TCDCLang.gui_fileChooser_mode_explore())),
        CHOOSE_FILE((class_2561)TComponent.gui(TCDCSprites.gui_icon_fsFolder()).method_27693(" ").method_10852((class_2561)TCDCLang.gui_fileChooser_mode_chooseFile())),
        CREATE_FILE((class_2561)TComponent.gui(TCDCSprites.gui_icon_fsFolder()).method_27693(" ").method_10852((class_2561)TCDCLang.gui_fileChooser_mode_createFile()));

        private final class_2561 windowTitle;

        private Mode(class_2561 windowTitle) {
            this.windowTitle = windowTitle;
        }

        @NotNull
        public final class_2561 getWindowTitle() {
            return this.windowTitle;
        }
    }

    public static enum Result {
        APPROVE,
        CANCEL,
        ERROR;

    }

    @FunctionalInterface
    public static interface FileFilter
    extends java.io.FileFilter,
    Predicate<File>,
    TDropdownWidget.Entry {
        public static final FileFilter ALL = new FileFilter(){
            private static final class_2561 DISPLAY_NAME = class_2561.method_43470((String)"*.*");

            @Override
            @NotNull
            public final class_2561 getDisplayName() {
                return DISPLAY_NAME;
            }

            @Override
            public final boolean accept(@Nullable File pathname) {
                return true;
            }
        };

        @Override
        @NotNull
        default public class_2561 getDisplayName() {
            return class_2561.method_43470((String)"*.?");
        }

        @Override
        @ApiStatus.NonExtendable
        default public boolean test(@Nullable File file) {
            return this.accept(file);
        }

        @Override
        public boolean accept(File var1);

        @NotNull
        default public String postProcessFilename(@NotNull String fileName) throws NullPointerException {
            return fileName;
        }

        public static FileFilter extname(@NotNull String extnameCaseSensitive) throws NullPointerException, IllegalArgumentException {
            char[] illegalChars;
            Objects.requireNonNull(extnameCaseSensitive);
            for (char c : illegalChars = new char[]{'/', '\\', '?', '%', '*', ':', '|', '\"', '<', '>'}) {
                if (extnameCaseSensitive.indexOf(c) < 0) continue;
                throw new IllegalArgumentException("Extension name cannot contain character: " + c);
            }
            Object extnameF = extnameCaseSensitive.startsWith(".") ? extnameCaseSensitive : "." + extnameCaseSensitive;
            final class_5250 extnameC = class_2561.method_43470((String)extnameF);
            return new FileFilter(){
                final /* synthetic */ String val$extnameF;
                {
                    this.val$extnameF = string;
                }

                @Override
                @NotNull
                public final class_2561 getDisplayName() {
                    return extnameC;
                }

                @Override
                public final boolean accept(@Nullable File pathname) {
                    return pathname != null && pathname.getName().endsWith(this.val$extnameF);
                }

                @Override
                @NotNull
                public final String postProcessFilename(@NotNull String fileName) throws NullPointerException {
                    return (fileName = fileName.replaceAll("[\n\r<>:\"/\\\\|?*\\x00-\\x1F]", "_").trim()).endsWith(this.val$extnameF) ? fileName : fileName + this.val$extnameF;
                }
            };
        }
    }

    final class WindowElement
    extends TWindowElement {
        WindowElement() {
            this.titleProperty().set((class_2561)TFileChooserScreen.this.title.get(), WindowElement.class);
            this.backgroundColorProperty().set(-13948117, WindowElement.class);
            this.closeOperationProperty().set(TWindowElement.CloseOperation.CLOSE_SCREEN, WindowElement.class);
        }

        @Override
        protected final void initBodyCallback(@NotNull TElement body) {
            TFillColorElement.Flat panel_main = new TFillColorElement.Flat(-14671840, 0);
            panel_main.setBounds(TFileChooserScreen.this.mode == Mode.EXPLORE ? body.getBounds() : body.getBounds().add(0, 0, 0, -18));
            body.add(panel_main);
            NavigationPanel panel_nav = new NavigationPanel();
            panel_main.add(panel_nav);
            panel_nav.setBounds(UDim2.ZERO, new UDim2(1.0, 0.0, 0.0, 15.0));
            QuickAccessPanel panel_qa = new QuickAccessPanel();
            panel_main.add(panel_qa);
            panel_qa.setBounds(new UDim2(0.0, 0.0, 0.0, 15.0), new UDim2(0.25, -7.0, 1.0, -15.0));
            ExplorerPanel panel_ex = new ExplorerPanel();
            panel_main.add(panel_ex);
            panel_ex.setBounds(new UDim2(0.25, 0.0, 0.0, 15.0), new UDim2(0.75, -7.0, 1.0, -15.0));
            TScrollBarWidget.Flat scroll_qa = new TScrollBarWidget.Flat(panel_qa);
            panel_main.add(scroll_qa);
            scroll_qa.setBounds(new UDim2(0.25, -8.0, 0.0, 15.0), new UDim2(0.0, 8.0, 1.0, -15.0));
            TScrollBarWidget.Flat scroll_ex = new TScrollBarWidget.Flat(panel_ex);
            panel_main.add(scroll_ex);
            scroll_ex.setBounds(new UDim2(1.0, -8.0, 0.0, 15.0), new UDim2(0.0, 8.0, 1.0, -15.0));
            if (TFileChooserScreen.this.mode != Mode.EXPLORE) {
                ActionPanel panel_action = new ActionPanel();
                body.add(panel_action);
                panel_action.setBounds(new UDim2(0.0, 0.0, 1.0, -18.0), new UDim2(1.0, 0.0, 0.0, 18.0));
            }
        }
    }

    final class ActionPanel
    extends TElement {
        private final TSimpleTextFieldWidget in_filename = new TSimpleTextFieldWidget();
        private final TDropdownWidget<FileFilter> dd_filefilter;
        private final TButtonWidget.Paintable btn_cancel;
        private final TButtonWidget.Paintable btn_accept;

        public ActionPanel() {
            this.dd_filefilter = new TDropdownWidget<FileFilter>(TFileChooserScreen.this.currFileFilter);
            this.btn_cancel = new TButtonWidget.Paintable(0x50440000, 0x50FFFFFF, -5570561);
            this.btn_accept = new TButtonWidget.Paintable(0x50004400, 0x50FFFFFF, -5570561);
            this.in_filename.placeholderProperty().set((class_2561)TCDCLang.gui_fileChooser_action_inputFilename_placeholder(), ActionPanel.class);
            this.in_filename.getTextLabel().textScaleProperty().set(0.8, ActionPanel.class);
            this.in_filename.getPlaceholderLabel().textScaleProperty().set(0.8, ActionPanel.class);
            this.dd_filefilter.getLabel().textScaleProperty().set(0.8, ActionPanel.class);
            this.dd_filefilter.getLabel().textAlignmentProperty().set(CompassDirection.WEST, ActionPanel.class);
            this.btn_cancel.getLabel().setText((class_2561)class_2561.method_43470((String)"x"));
            this.btn_cancel.getLabel().textAlignmentProperty().set(CompassDirection.CENTER, ActionPanel.class);
            this.btn_cancel.getLabel().textScaleProperty().set(0.8, ActionPanel.class);
            this.btn_accept.getLabel().setText((class_2561)class_2561.method_43470((String)"\u2713"));
            this.btn_accept.getLabel().textAlignmentProperty().set(CompassDirection.CENTER, ActionPanel.class);
            this.btn_accept.getLabel().textScaleProperty().set(0.8, ActionPanel.class);
            this.btn_accept.visibleProperty().set(TFileChooserScreen.this.mode != Mode.EXPLORE, ActionPanel.class);
            this.in_filename.textProperty().addFilter(n -> n.replace("\\", "/").replace("/", ""), ActionPanel.class);
            this.dd_filefilter.getEntries().addAll(TFileChooserScreen.this.fileFilters);
            this.dd_filefilter.selectedEntryProperty().addChangeListener((p, o, n) -> {
                TFileChooserScreen.this.currFileFilter = n;
                TFileChooserScreen.this.refresh();
            });
            this.btn_cancel.eClicked.register(__ -> {
                TFileChooserScreen.this.output_result = Result.CANCEL;
                TFileChooserScreen.this.output_file.set(null, ActionPanel.class);
                TFileChooserScreen.this.close();
            });
            this.btn_accept.eClicked.register(__ -> {
                String fileName = this.in_filename.textProperty().get().trim();
                if (TFileChooserScreen.this.currFileFilter != null) {
                    fileName = TFileChooserScreen.this.currFileFilter.postProcessFilename(fileName);
                }
                if (fileName.isBlank()) {
                    this.screenProperty().get().focusedElementProperty().set(this.in_filename, ActionPanel.class);
                    return;
                }
                try {
                    TFileChooserScreen.this.output_file.set(new File(TFileChooserScreen.this.history_currDir, fileName), ActionPanel.class);
                }
                catch (InvalidPathException e) {
                    TFileChooserScreen.this.output_file.set(null, ActionPanel.class);
                }
                File output_file = TFileChooserScreen.this.output_file.get();
                if (output_file == null) {
                    return;
                }
                switch (TFileChooserScreen.this.mode.ordinal()) {
                    case 1: {
                        if (!output_file.exists()) break;
                    }
                    case 2: {
                        TFileChooserScreen.this.output_result = Result.APPROVE;
                        TFileChooserScreen.this.close();
                        break;
                    }
                }
            });
        }

        @Override
        protected final void initCallback() {
            Bounds2i bb = this.getBounds();
            this.in_filename.setBounds(bb.x + 2, bb.y + 2, bb.width - 150, 15);
            this.add(this.in_filename);
            this.dd_filefilter.setBounds(bb.endX - 146, bb.y + 2, 90, 15);
            this.add(this.dd_filefilter);
            this.btn_cancel.setBounds(bb.endX - 54, bb.y + 2, 25, 15);
            this.add(this.btn_cancel);
            this.btn_accept.setBounds(bb.endX - 27, bb.y + 2, 25, 15);
            this.add(this.btn_accept);
        }

        @Override
        public final void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, -13948117);
            pencil.fillColor(bb.x, bb.y, bb.width, 1, -16777216);
        }
    }

    final class FileEntryElement
    extends TButtonWidget.Paintable {
        private final File file;
        private long lastClickMs = 0L;
        private static final Function<FileEntryElement, TContextMenu> CONTEXT_MENU = fee -> new TContextMenu.Builder(Objects.requireNonNull(fee.getClient())).addContextMenu((class_2561)TComponent.gui(TCDCSprites.gui_icon_fsFolder()).method_27693(" ").method_10852((class_2561)TCDCLang.gui_fileChooser_ctxmenu_openIn()), new TContextMenu.Builder(fee.getClient()).addButton((class_2561)TComponent.gui(TCDCSprites.gui_icon_fsFile()).method_27693(" ").method_10852((class_2561)TCDCLang.gui_fileChooser_ctxmenu_openIn_assocApp()), btn -> class_156.method_668().method_673(fee.getFile().toURI())).build()).build();

        public FileEntryElement(File file) {
            this(file, (class_2561)FileEntryElement.computeFileLabelText(file));
        }

        public FileEntryElement(@NotNull File file, class_2561 text) {
            this.file = Objects.requireNonNull(file);
            this.getLabel().setText(text);
            this.getLabel().textAlignmentProperty().set(CompassDirection.WEST, FileEntryElement.class);
            this.getLabel().textScaleProperty().set(0.8, FileEntryElement.class);
            this.backgroundColorProperty().set(0, FileEntryElement.class);
            this.outlineColorProperty().set(0, FileEntryElement.class);
            this.contextMenuProperty().set(CONTEXT_MENU, FileEntryElement.class);
        }

        @Override
        protected final void clickCallback() {
            if (this.file.isDirectory()) {
                TFileChooserScreen.this.navigateTo(this.file);
                return;
            }
            TFileChooserScreen.this.output_file.set(this.file, FileEntryElement.class);
            long lastClickMs = this.lastClickMs;
            long thisClickMs = this.lastClickMs = System.currentTimeMillis();
            if (thisClickMs - lastClickMs > 500L) {
                return;
            }
            switch (TFileChooserScreen.this.mode.ordinal()) {
                case 1: 
                case 2: {
                    TFileChooserScreen.this.output_result = Result.APPROVE;
                    TFileChooserScreen.this.close();
                    break;
                }
                default: {
                    class_156.method_668().method_673(this.file.toURI());
                }
            }
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public static final class_5250 computeFileLabelText(@NotNull File file) {
            return FileEntryElement.computeFileIcon(file).method_27693(" " + (!file.getName().isBlank() ? file.getName() : file.getPath()));
        }

        @NotNull
        public static final class_5250 computeFileIcon(@NotNull File file) {
            return TComponent.gui(file.isDirectory() ? TCDCSprites.gui_icon_fsFolder() : TCDCSprites.gui_icon_fsFile());
        }
    }

    final class ExplorerPanel
    extends TPanelElement.Transparent {
        ExplorerPanel() {
            this.scrollPaddingProperty().set(7, ExplorerPanel.class);
        }

        @Override
        protected final void initCallback() {
            FileEntryElement el;
            File dir = TFileChooserScreen.this.history_currDir;
            File parent = dir.getParentFile();
            if (parent != null && parent.exists()) {
                FileEntryElement el_up = new FileEntryElement(parent, (class_2561)TComponent.gui(TCDCSprites.gui_icon_fsFolderGray()).method_27693(" ../"));
                el_up.setBounds(this.computeNextYBounds(15, 0));
                this.add(el_up);
            }
            @NotNull File[] dir_files = null;
            Exception dir_filesErr = null;
            try {
                dir_files = dir.listFiles();
                if (dir_files == null) {
                    throw new FileNotFoundException(dir.getAbsolutePath());
                }
            }
            catch (Exception e) {
                dir_filesErr = e;
            }
            if (dir_filesErr != null) {
                Bounds2i bb = this.getBounds();
                int pad = this.scrollPaddingProperty().getI();
                TLabelElement lbl = new TLabelElement((class_2561)class_2561.method_43470((String)(dir_filesErr.getClass().getName() + "\n" + dir_filesErr.getLocalizedMessage())));
                lbl.setBounds(pad, pad + 15, bb.width - pad * 2, bb.height - pad * 2 - 30);
                lbl.wrapTextProperty().set(true, ExplorerPanel.class);
                lbl.textAlignmentProperty().set(CompassDirection.CENTER, ExplorerPanel.class);
                lbl.textColorProperty().set(0x55FFFFFF, ExplorerPanel.class);
                lbl.textScaleProperty().set(0.8, ExplorerPanel.class);
                this.addRel(lbl);
                return;
            }
            for (File file2 : dir_files = (File[])Arrays.stream(dir_files).filter(File::exists).filter(file -> !file.isHidden()).filter(file -> file.isDirectory() || TFileChooserScreen.this.currFileFilter == null || TFileChooserScreen.this.currFileFilter.test((File)file)).toArray(File[]::new)) {
                if (!file2.isDirectory()) continue;
                el = new FileEntryElement(file2);
                el.setBounds(this.computeNextYBounds(15, 0));
                this.add(el);
            }
            for (File file2 : dir_files) {
                if (!file2.isFile()) continue;
                el = new FileEntryElement(file2);
                el.setBounds(this.computeNextYBounds(15, 0));
                this.add(el);
            }
        }

        @Override
        public final void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            if (this.isFocused()) {
                pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, 0x22FFFFFF);
            }
        }
    }

    final class QuickAccessPanel
    extends TPanelElement.Transparent {
        QuickAccessPanel() {
            this.scrollPaddingProperty().set(7, QuickAccessPanel.class);
        }

        @Override
        protected final void initCallback() {
            this.initCategory((class_2561)TComponent.gui("icon/accessibility").method_27693(" ").method_10852((class_2561)TCDCLang.gui_fileChooser_quickAccess()));
            File dir_home = new File(System.getProperty("user.home"));
            File dir_desk = new File(dir_home, "Desktop");
            File dir_down = new File(dir_home, "Downloads");
            File dir_docs = new File(dir_home, "Documents");
            File dir_udir = new File(System.getProperty("user.dir"));
            if (dir_home.exists()) {
                this.initFileEntry(dir_home);
            }
            if (dir_down.exists()) {
                this.initFileEntry(dir_down);
            }
            if (dir_desk.exists()) {
                this.initFileEntry(dir_desk);
            }
            if (dir_docs.exists()) {
                this.initFileEntry(dir_docs);
            }
            if (dir_udir.exists()) {
                this.initFileEntry(dir_udir);
            }
            this.initCategory((class_2561)TComponent.gui("statistics/item_crafted").method_27693(" ").method_10852((class_2561)TCDCLang.gui_fileChooser_quickAccess_mountPoints()));
            File[] roots = File.listRoots();
            if (roots != null) {
                for (File root : roots) {
                    if (root.exists()) {
                        this.initFileEntry(root);
                        continue;
                    }
                    this.initFileEntry(new File("/"));
                }
            }
        }

        @Override
        public final void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            if (this.isFocused()) {
                pencil.drawOutlineIn(bb.x, bb.y, bb.width - 1, bb.height, 0x22FFFFFF);
            }
        }

        private final void initCategory(@NotNull class_2561 name) {
            TLabelElement lbl = new TLabelElement(name);
            lbl.setBounds(this.computeNextYBounds(15, 10));
            lbl.textScaleProperty().set(0.8, QuickAccessPanel.class);
            this.add(lbl);
            TElement el_gap = new TElement();
            el_gap.setBounds(this.computeNextYBounds(3, 0));
            this.add(el_gap);
        }

        private final void initFileEntry(@NotNull File file) {
            FileEntryElement el = new FileEntryElement(file);
            el.setBounds(this.computeNextYBounds(15, 0).add(5, 0, -5, 0));
            this.add(el);
        }
    }

    final class NavigationPanel
    extends TElement {
        NavigationPanel() {
        }

        @Override
        protected final void initCallback() {
            TButtonWidget.Paintable btn_back = new TButtonWidget.Paintable(0x66888888, 0, -1);
            btn_back.setBounds(0, 0, 20, 15);
            btn_back.getLabel().setText((class_2561)class_2561.method_43470((String)"<"));
            btn_back.getLabel().textScaleProperty().set(0.8, NavigationPanel.class);
            btn_back.eClicked.register(__ -> TFileChooserScreen.this.navigateBack());
            this.addRel(btn_back);
            TButtonWidget.Paintable btn_fwd = new TButtonWidget.Paintable(0x66888888, 0, -1);
            btn_fwd.setBounds(20, 0, 20, 15);
            btn_fwd.getLabel().setText((class_2561)class_2561.method_43470((String)">"));
            btn_fwd.getLabel().textScaleProperty().set(0.8, NavigationPanel.class);
            btn_fwd.eClicked.register(__ -> TFileChooserScreen.this.navigateForward());
            this.addRel(btn_fwd);
            TButtonWidget.Paintable btn_refresh = new TButtonWidget.Paintable(0x66888888, 0, -1);
            btn_refresh.setBounds(40, 0, 20, 15);
            btn_refresh.getLabel().setText((class_2561)class_2561.method_43470((String)"o"));
            btn_refresh.getLabel().textScaleProperty().set(0.85, NavigationPanel.class);
            btn_refresh.eClicked.register(__ -> TFileChooserScreen.this.refresh());
            this.addRel(btn_refresh);
            TLabelElement lbl_path = new TLabelElement();
            lbl_path.setBounds(this.getBounds().add(65, 0, -65, 0));
            lbl_path.setText((class_2561)class_2561.method_43470((String)TFileChooserScreen.this.history_currDir.getAbsolutePath().replace("\\", "/").replace("/", " > ")));
            lbl_path.textScaleProperty().set(0.7, NavigationPanel.class);
            lbl_path.textColorProperty().set(-855638017, NavigationPanel.class);
            lbl_path.textAlignmentProperty().set((double)lbl_path.fontProperty().get().method_27525((class_5348)lbl_path.getText()) * lbl_path.textScaleProperty().getD() < (double)lbl_path.getBounds().width ? CompassDirection.WEST : CompassDirection.EAST, NavigationPanel.class);
            this.add(lbl_path);
        }

        @Override
        public final void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, -16777216);
        }
    }

    public static final class Builder {
        @NotNull
        private final Mode mode;
        @Nullable
        private class_437 lastScreen;
        @NotNull
        private File currDir = new File(System.getProperty("user.home"));
        @NotNull
        private final List<FileFilter> fileFilters;

        public Builder(@NotNull Mode mode) throws NullPointerException {
            this.mode = Objects.requireNonNull(mode);
            this.fileFilters = new ArrayList<FileFilter>();
        }

        @NotNull
        public final Mode getmode() {
            return this.mode;
        }

        public final Builder setLastScreen(@Nullable class_437 lastScreen) {
            this.lastScreen = lastScreen;
            return this;
        }

        public final Builder setCurrentDirectory(@NotNull File currDir) throws NullPointerException {
            this.currDir = Objects.requireNonNull(currDir);
            return this;
        }

        public final Builder setFileFilter(@NotNull FileFilter fileFilter) throws NullPointerException {
            Objects.requireNonNull(fileFilter);
            this.fileFilters.clear();
            this.fileFilters.add(fileFilter);
            return this;
        }

        public final Builder addFileFilter(@NotNull FileFilter fileFilter) throws NullPointerException, IllegalStateException {
            Objects.requireNonNull(fileFilter);
            if (this.mode == Mode.EXPLORE && this.fileFilters.size() == 1) {
                throw new IllegalStateException("Cannot have multiple file-filters in " + Mode.class.getName() + "#" + String.valueOf((Object)Mode.EXPLORE));
            }
            this.fileFilters.add(fileFilter);
            return this;
        }

        @NotNull
        public final TFileChooserScreen build(@NotNull @NotNull BiConsumer<@NotNull Result, @Nullable File> resultHandler) throws NullPointerException {
            return new TFileChooserScreen(this.lastScreen, this.mode, this.currDir, this.fileFilters, resultHandler);
        }
    }
}

