/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.screen;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.screen.ILastScreenProvider;
import com.thecsdev.commonmc.api.client.gui.screen.TScreenWrapper;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.client.mixin.hooks.AccessorTElement;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class TScreen
extends TElement {
    @ApiStatus.Internal
    final TScreenWrapper<?> screen = Objects.requireNonNull(this.createWrapperScreen());
    @ApiStatus.Internal
    final NotNullProperty<class_2561> title = new NotNullProperty<class_5250>(class_2561.method_43473());
    @ApiStatus.Internal
    final ObjectProperty<TElement> hovered = new ObjectProperty<Object>(null);
    @ApiStatus.Internal
    final ObjectProperty<TElement> focused = new ObjectProperty<Object>(null);
    @ApiStatus.Internal
    final ObjectProperty<TElement> dragged = new ObjectProperty<Object>(null);

    public TScreen(@NotNull class_2561 title) {
        this();
        this.titleProperty().set(title, TScreen.class);
    }

    public TScreen() {
        this.hovered.addFilter(el -> el != null && el.screenProperty().get() != this ? null : el, TScreen.class);
        this.focused.addFilter(el -> el != null && el.screenProperty().get() != this ? null : el, TScreen.class);
        this.dragged.addFilter(el -> el != null && el.screenProperty().get() != this ? null : el, TScreen.class);
        this.hovered.addChangeListener((p, o, n) -> {
            if (o != null) {
                ((AccessorTElement)((Object)o))._hoverLostCallback();
            }
            if (n != null) {
                n.invalidateTooltipCache();
                ((AccessorTElement)((Object)n))._hoverGainedCallback();
            }
        });
        this.focused.addChangeListener((p, o, n) -> {
            if (o != null) {
                ((AccessorTElement)((Object)o))._focusLostCallback();
            }
            if (n != null) {
                n.invalidateTooltipCache();
                ((AccessorTElement)((Object)n))._focusGainedCallback();
                TGuiUtils.scrollToElement(n);
            }
        });
        this.dragged.addChangeListener((p, o, n) -> {
            if (o != null) {
                ((AccessorTElement)((Object)o))._dragEndCallback();
            }
            if (n != null) {
                ((AccessorTElement)((Object)n))._dragStartCallback();
            }
        });
        this.boundsProperty().addFilter(bb -> bb.x != 0 || bb.y != 0 ? new Bounds2i(0, 0, bb.width, bb.height) : bb, TScreen.class);
        this.boundsProperty().addChangeListener((p, o, n) -> {
            this.hovered.set(null, TScreen.class);
            this.focused.set(null, TScreen.class);
            this.dragged.set(null, TScreen.class);
            this.clearAndInit();
        });
    }

    @Virtual
    @NotNull
    protected TScreenWrapper<?> createWrapperScreen() {
        return new TScreenWrapper<TScreen>(this);
    }

    @NotNull
    public final TScreenWrapper<?> getAsScreen() {
        return this.screen;
    }

    @Override
    @NotNull
    public final class_310 getClient() {
        return this.screen.getClient();
    }

    public final NotNullProperty<class_2561> titleProperty() {
        return this.title;
    }

    public final ObjectProperty<TElement> hoveredElementProperty() {
        return this.hovered;
    }

    public final ObjectProperty<TElement> focusedElementProperty() {
        return this.focused;
    }

    @Contract(pure=true)
    public final boolean isOpen() {
        TScreenWrapper<?> screen = this.getAsScreen();
        class_310 client = screen.getClient();
        return client != null && client.field_1755 == screen;
    }

    @Contract(pure=true)
    @Virtual
    public boolean isPauseScreen() {
        return true;
    }

    @Contract(pure=true)
    @Virtual
    public boolean isAllowingInGameHud() {
        return true;
    }

    public final boolean sendInput(@NotNull TInputContext context) {
        return this.screen.sendInput(context);
    }

    @Override
    protected abstract void initCallback();

    @Virtual
    protected void openCallback() {
    }

    @Virtual
    protected void closeCallback() {
    }

    @Virtual
    public void close() throws IllegalStateException {
        class_310 client = this.getClient();
        if (client == null) {
            throw new IllegalStateException("Missing 'client' instance");
        }
        if (this.isOpen()) {
            client.method_1507(ILastScreenProvider.getLastScreen(this));
        }
    }
}

