/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.screen;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.screen.TScreen;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TScreenPlus
extends TScreen {
    private static final Predicate<TElement> FCSE_DEFAULT = e -> e.isFocusable() && e.isVisible();

    public TScreenPlus() {
    }

    public TScreenPlus(@NotNull class_2561 title) {
        super(title);
    }

    @Override
    @Virtual
    public boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) {
        if (super.inputCallback(phase, context)) {
            return true;
        }
        if (phase != TInputContext.InputDiscoveryPhase.MAIN) {
            return false;
        }
        if (context.getInputType() == TInputContext.InputType.KEY_PRESS) {
            CompassDirection direction;
            Integer n = context.getKeyCode();
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{265, 264, 263, 262}, (Object)n, n2)) {
                case 0: {
                    CompassDirection compassDirection = CompassDirection.NORTH;
                    break;
                }
                case 1: {
                    CompassDirection compassDirection = CompassDirection.SOUTH;
                    break;
                }
                case 2: {
                    CompassDirection compassDirection = CompassDirection.WEST;
                    break;
                }
                case 3: {
                    CompassDirection compassDirection = CompassDirection.EAST;
                    break;
                }
                default: {
                    CompassDirection compassDirection = direction = null;
                }
            }
            if (direction == null) {
                return false;
            }
            TElement closest = this.findClosestSideElement(this.focused.get(), direction);
            if (closest == null) {
                return false;
            }
            this.focused.set(closest, TScreenPlus.class);
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> null; _, null -> null; _, _ -> _")
    @Nullable
    private TElement findClosestSideElement(@Nullable TElement target, @Nullable CompassDirection direction) {
        return this.findClosestSideElement(target, direction, FCSE_DEFAULT);
    }

    @Contract(value="null, _, _ -> null; _, null, _ -> null; _, _, _ -> _")
    @Nullable
    private TElement findClosestSideElement(@Nullable TElement target, @Nullable CompassDirection direction, @NotNull Predicate<TElement> predicate) {
        if (target == null || direction == null || target.getParent() == null) {
            return null;
        }
        Objects.requireNonNull(predicate);
        Bounds2i tbb = target.getBounds();
        int x = tbb.x + tbb.width / 2;
        int y = tbb.y + tbb.height / 2;
        AtomicReference<Object> closest = new AtomicReference<Object>(null);
        AtomicInteger dX = new AtomicInteger(0);
        AtomicInteger dY = new AtomicInteger(0);
        Predicate<TElement> finalPredicate = child -> {
            if (child == target || !predicate.test((TElement)child)) {
                return false;
            }
            Bounds2i cbb = child.getBounds();
            int cX = cbb.x + cbb.width / 2;
            int cY = cbb.y + cbb.height / 2;
            switch (direction) {
                case NORTH: {
                    if (cY <= y - 1) break;
                    return false;
                }
                case SOUTH: {
                    if (cY >= y + 1) break;
                    return false;
                }
                case WEST: {
                    if (cX <= x - 1) break;
                    return false;
                }
                case EAST: {
                    if (cX >= x + 1) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (closest.get() == null) {
                closest.set(child);
                dX.set(Math.abs(cX - x));
                dY.set(Math.abs(cY - y));
                return false;
            }
            if (Math.abs(cX - x) < dX.get() || Math.abs(cY - y) < dY.get()) {
                closest.set(child);
                dX.set(Math.abs(cX - x));
                dY.set(Math.abs(cY - y));
                return false;
            }
            return false;
        };
        ((TElement)target.getParent()).findChild(finalPredicate, true);
        if (closest.get() == null) {
            this.findChild(finalPredicate, true);
        }
        return closest.get();
    }
}

