/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.screen;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.scene.Node;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.TCDCommons;
import com.thecsdev.commonmc.TCDCommonsConfig;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.screen.TScreen;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.client.mixin.hooks.AccessorTElement;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TScreenWrapper<T extends TScreen>
extends class_437 {
    @NotNull
    private final T target;

    protected TScreenWrapper(@NotNull T target) {
        super((class_2561)class_2561.method_43473());
        this.target = (TScreen)Objects.requireNonNull(target);
    }

    public final T getTargetTScreen() {
        return this.target;
    }

    @NotNull
    public final class_310 getClient() {
        return this.field_22787;
    }

    public final boolean isAllowingInGameHud() {
        return ((TScreen)this.target).isAllowingInGameHud();
    }

    public final boolean method_25422() {
        return false;
    }

    public final boolean method_25421() {
        return ((TScreen)this.target).isPauseScreen();
    }

    public final void method_49589() {
        ((TScreen)this.target).openCallback();
    }

    public final void method_25432() {
        ((TScreen)this.target).closeCallback();
        if (!((TScreen)this.target).isOpen()) {
            ((Node)this.target).clear();
        }
    }

    public final void method_25419() {
        if (((TScreen)this.target).isOpen()) {
            ((TScreen)this.target).close();
        }
    }

    protected final void method_25426() {
        long ns = System.nanoTime();
        ((TElement)this.target).boundsProperty().getHandle().set(Bounds2i.ZERO);
        ((TElement)this.target).setBounds(0, 0, this.field_22789, this.field_22790);
        super.method_25426();
        if (TCDCommonsConfig.FLAG_DEV_ENV) {
            TCDCommons.LOGGER.info("Initialized '" + String.valueOf(this.target.getClass()) + "' in " + (System.nanoTime() - ns) + "ns.");
        }
    }

    public final void method_25393() {
        ((AccessorTElement)this.target)._tick();
        super.method_25393();
    }

    public final void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float deltaTicks) {
        TGuiGraphics tgg = TGuiGraphics.createInstance(context, mouseX, mouseY, deltaTicks);
        tgg.renderTScreen((TScreen)this.target);
        super.method_25394(context, mouseX, mouseY, deltaTicks);
    }

    public final boolean method_25404(@NotNull class_11908 e) {
        if (super.method_25404(e)) {
            return true;
        }
        return this.sendInput(TInputContext.ofKeyPress(e.comp_4795(), e.comp_4796(), e.comp_4797()));
    }

    public final boolean method_16803(@NotNull class_11908 e) {
        if (super.method_16803(e)) {
            return true;
        }
        return this.sendInput(TInputContext.ofKeyRelease(e.comp_4795(), e.comp_4796(), e.comp_4797()));
    }

    public final boolean method_25400(@NotNull class_11905 e) {
        if (super.method_25400(e)) {
            return true;
        }
        return this.sendInput(TInputContext.ofCharType((char)e.comp_4793(), e.comp_4794()));
    }

    public final boolean method_25402(@NotNull class_11909 e, boolean doubled) {
        if (super.method_25402(e, doubled)) {
            return true;
        }
        return this.sendInput(TInputContext.ofMousePress(e.comp_4798(), e.comp_4799(), e.method_74245()));
    }

    public final boolean method_25406(@NotNull class_11909 e) {
        if (super.method_25406(e)) {
            return true;
        }
        return this.sendInput(TInputContext.ofMouseRelease(e.comp_4798(), e.comp_4799(), e.method_74245()));
    }

    public final void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        this.sendInput(TInputContext.ofMouseMove(mouseX, mouseY));
    }

    public final boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return this.sendInput(TInputContext.ofMouseScroll(mouseX, mouseY, horizontalAmount, verticalAmount));
    }

    public final boolean method_25403(@NotNull class_11909 e, double deltaX, double deltaY) {
        if (super.method_25403(e, deltaX, deltaY)) {
            return true;
        }
        return this.sendInput(TInputContext.ofMouseDrag(e.comp_4798(), e.comp_4799(), e.method_74245(), deltaX, deltaY));
    }

    @ApiStatus.Internal
    final boolean sendInput(TInputContext context) {
        TElement hovered;
        if (context.getInputType().isMouse()) {
            @Nullable Double mouseX = context.getMouseX();
            @Nullable Double mouseY = context.getMouseY();
            if (mouseX != null && mouseY != null) {
                ((TScreen)this.target).hovered.set(((TElement)this.target).findElementAt((int)mouseX.doubleValue(), (int)mouseY.doubleValue()), TScreenWrapper.class);
            }
        }
        ((TElement)this.target).inputCallback(TInputContext.InputDiscoveryPhase.BROADCAST, context);
        ((Node)this.target).forEach(child -> child.inputCallback(TInputContext.InputDiscoveryPhase.BROADCAST, context), true);
        if (((TElement)this.target).inputCallback(TInputContext.InputDiscoveryPhase.PREEMPT, context)) {
            return true;
        }
        if (((Node)this.target).findChild(child -> child.inputCallback(TInputContext.InputDiscoveryPhase.PREEMPT, context), true).isPresent()) {
            return true;
        }
        switch (context.getInputType()) {
            case MOUSE_PRESS: {
                TElement handledE;
                TElement handled = TScreenWrapper.sendInputBubbleMain(context, ((TScreen)this.target).hovered.get());
                ((TScreen)this.target).focused.set(handled instanceof TElement ? ((handledE = handled).isFocusable() ? handledE : null) : null, TScreenWrapper.class);
                ((TScreen)this.target).dragged.set(handled, TScreenWrapper.class);
                if (handled == null) break;
                return true;
            }
            case MOUSE_DRAG: {
                TElement draggedEl = ((TScreen)this.target).dragged.get();
                if (draggedEl == null || !draggedEl.inputCallback(TInputContext.InputDiscoveryPhase.MAIN, context)) break;
                return true;
            }
            case MOUSE_RELEASE: 
            case KEY_PRESS: 
            case KEY_RELEASE: 
            case CHAR_TYPE: {
                TElement focusedEl;
                if (context.getInputType() == TInputContext.InputType.MOUSE_RELEASE) {
                    TElement dragged = ((TScreen)this.target).dragged.get();
                    ((TScreen)this.target).dragged.set(null, TScreenWrapper.class);
                    if (dragged != null && ((TScreen)this.target).focused.get() != dragged) {
                        dragged.inputCallback(TInputContext.InputDiscoveryPhase.MAIN, context);
                    }
                }
                if (TScreenWrapper.sendInputBubbleMain(context, focusedEl = Optional.ofNullable(((TScreen)this.target).focused.get()).orElse((TElement)this.target)) == null) break;
                return true;
            }
            case MOUSE_SCROLL: {
                TElement handled = TScreenWrapper.sendInputBubbleMain(context, ((TScreen)this.target).hovered.get());
                if (handled == null) break;
                return true;
            }
        }
        if (context.getInputType() == TInputContext.InputType.KEY_PRESS) {
            if (context.getKeyCode() == 258) {
                boolean forward = !TGuiUtils.isShiftDown();
                @Nullable TElement current = ((TScreen)this.target).focused.get();
                current = current == null ? (forward ? TGuiUtils.nextFocusableTElement(this.target, true) : TGuiUtils.previousFocusableTElement(this.target, true)) : (forward ? TGuiUtils.nextFocusableTElement(current, false) : TGuiUtils.previousFocusableTElement(current, false));
                ((TScreen)this.target).focused.set(current, TScreenWrapper.class);
                return true;
            }
            if (context.getKeyCode() == 348) {
                TElement focused = ((TScreen)this.target).focused.get();
                if (focused != null && focused.showContextMenu() != null) {
                    return true;
                }
            } else if (context.getKeyCode() == 256) {
                this.method_25419();
                return true;
            }
        } else if (context.getInputType() == TInputContext.InputType.MOUSE_PRESS && context.getMouseButton() == 1 && (hovered = ((TScreen)this.target).hovered.get()) != null && hovered.showContextMenu() != null) {
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    private static final TElement sendInputBubbleMain(TInputContext context, @Nullable TElement element) {
        if (element == null) {
            return null;
        }
        while (element != null && !element.inputCallback(TInputContext.InputDiscoveryPhase.MAIN, context)) {
            element = (TElement)element.getParent();
        }
        return element;
    }
}

